/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class CustomURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final Map classMap_;
    private final Map instanceMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.util");

    public CustomURLStreamHandlerFactory() {
        this(new HashMap());
    }

    public CustomURLStreamHandlerFactory(Map classMap) {
        this.classMap_ = classMap;
        this.instanceMap_ = new HashMap();
    }

    public Map getHandlerClassMap() {
        return this.classMap_;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        Map classMap = this.getHandlerClassMap();
        if (this.instanceMap_.containsKey(protocol)) {
            return (URLStreamHandler)this.instanceMap_.get(protocol);
        }
        if (classMap.containsKey(protocol)) {
            URLStreamHandler handler;
            String clazzName = String.valueOf(classMap.get(protocol));
            try {
                handler = (URLStreamHandler)Class.forName(clazzName).newInstance();
            }
            catch (Throwable e) {
                handler = null;
                logger_.warning("Cannot instantiate handler for URL protocol " + protocol + ": " + e);
            }
            this.instanceMap_.put(protocol, handler);
            return handler;
        }
        return null;
    }
}

