/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class GenericNioBuffer {
    private final Accessor acc;
    private final Buffer buf;

    public GenericNioBuffer(final Buffer buf) {
        this.buf = buf;
        if (buf instanceof ByteBuffer) {
            this.acc = new Accessor(){
                ByteBuffer buffer;
                {
                    this.buffer = (ByteBuffer)buf;
                }

                void get(Object dst, int offset, int length) {
                    this.buffer.get((byte[])dst, offset, length);
                }

                void put(Object src, int offset, int length) {
                    this.buffer.put((byte[])src, offset, length);
                }

                Buffer duplicate() {
                    return this.buffer.duplicate();
                }

                boolean hasArray() {
                    return this.buffer.hasArray();
                }

                int arrayOffset() {
                    return this.buffer.arrayOffset();
                }

                Object array() {
                    return this.buffer.array();
                }

                Class getElementClass() {
                    return Byte.TYPE;
                }
            };
        } else if (buf instanceof ShortBuffer) {
            this.acc = new Accessor(){
                ShortBuffer buffer;
                {
                    this.buffer = (ShortBuffer)buf;
                }

                void get(Object dst, int offset, int length) {
                    this.buffer.get((short[])dst, offset, length);
                }

                void put(Object src, int offset, int length) {
                    this.buffer.put((short[])src, offset, length);
                }

                Buffer duplicate() {
                    return this.buffer.duplicate();
                }

                boolean hasArray() {
                    return this.buffer.hasArray();
                }

                int arrayOffset() {
                    return this.buffer.arrayOffset();
                }

                Object array() {
                    return this.buffer.array();
                }

                Class getElementClass() {
                    return Short.TYPE;
                }
            };
        } else if (buf instanceof IntBuffer) {
            this.acc = new Accessor(){
                IntBuffer buffer;
                {
                    this.buffer = (IntBuffer)buf;
                }

                void get(Object dst, int offset, int length) {
                    this.buffer.get((int[])dst, offset, length);
                }

                void put(Object src, int offset, int length) {
                    this.buffer.put((int[])src, offset, length);
                }

                Buffer duplicate() {
                    return this.buffer.duplicate();
                }

                boolean hasArray() {
                    return this.buffer.hasArray();
                }

                int arrayOffset() {
                    return this.buffer.arrayOffset();
                }

                Object array() {
                    return this.buffer.array();
                }

                Class getElementClass() {
                    return Integer.TYPE;
                }
            };
        } else if (buf instanceof FloatBuffer) {
            this.acc = new Accessor(){
                FloatBuffer buffer;
                {
                    this.buffer = (FloatBuffer)buf;
                }

                void get(Object dst, int offset, int length) {
                    this.buffer.get((float[])dst, offset, length);
                }

                void put(Object src, int offset, int length) {
                    this.buffer.put((float[])src, offset, length);
                }

                Buffer duplicate() {
                    return this.buffer.duplicate();
                }

                boolean hasArray() {
                    return this.buffer.hasArray();
                }

                int arrayOffset() {
                    return this.buffer.arrayOffset();
                }

                Object array() {
                    return this.buffer.array();
                }

                Class getElementClass() {
                    return Float.TYPE;
                }
            };
        } else if (buf instanceof DoubleBuffer) {
            this.acc = new Accessor(){
                DoubleBuffer buffer;
                {
                    this.buffer = (DoubleBuffer)buf;
                }

                void get(Object dst, int offset, int length) {
                    this.buffer.get((double[])dst, offset, length);
                }

                void put(Object src, int offset, int length) {
                    this.buffer.put((double[])src, offset, length);
                }

                Buffer duplicate() {
                    return this.buffer.duplicate();
                }

                boolean hasArray() {
                    return this.buffer.hasArray();
                }

                int arrayOffset() {
                    return this.buffer.arrayOffset();
                }

                Object array() {
                    return this.buffer.array();
                }

                Class getElementClass() {
                    return Double.TYPE;
                }
            };
        } else {
            throw new IllegalArgumentException("Buffer " + buf + " is of unsupported type");
        }
    }

    public Buffer getBuffer() {
        return this.buf;
    }

    public void get(Object dst) {
        this.acc.get(dst, 0, Array.getLength(dst));
    }

    public void get(Object dst, int offset, int length) {
        this.acc.get(dst, offset, length);
    }

    public void put(Object src) {
        this.acc.put(src, 0, Array.getLength(src));
    }

    public void put(Object src, int offset, int length) {
        this.acc.put(src, offset, length);
    }

    public Buffer duplicate() {
        return this.acc.duplicate();
    }

    public boolean hasArray() {
        return this.acc.hasArray();
    }

    public Object array() {
        return this.acc.array();
    }

    public int arrayOffset() {
        return this.acc.arrayOffset();
    }

    public Class getElementClass() {
        return this.acc.getElementClass();
    }

    private static abstract class Accessor {
        private Accessor() {
        }

        abstract void get(Object var1, int var2, int var3);

        abstract void put(Object var1, int var2, int var3);

        abstract Buffer duplicate();

        abstract boolean hasArray();

        abstract int arrayOffset();

        abstract Object array();

        abstract Class getElementClass();
    }
}

