/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapGroup {
    private final List maps = new ArrayList();
    private List ordering;
    private Comparator keyComparator;
    private List knownKeys;

    public MapGroup() {
        this.setKeyOrder(new ArrayList());
    }

    public void addMap(Map map) {
        this.maps.add(map);
    }

    public List getMaps() {
        return Collections.unmodifiableList(this.maps);
    }

    public int size() {
        return this.maps.size();
    }

    public void setKeyOrder(List ordering) {
        this.ordering = new ArrayList(ordering);
        final ArrayList order = new ArrayList(this.ordering);
        Collections.reverse(order);
        this.keyComparator = new Comparator(){

            public int compare(Object key1, Object key2) {
                int ik1 = order.indexOf(key1);
                int ik2 = order.indexOf(key2);
                if (ik1 >= 0 || ik2 >= 0) {
                    return ik2 - ik1;
                }
                if (key1 instanceof Comparable && key2 instanceof Comparable) {
                    return ((Comparable)key1).compareTo(key2);
                }
                return System.identityHashCode(key1) - System.identityHashCode(key2);
            }
        };
    }

    public List getKeyOrder() {
        return this.ordering;
    }

    public void removeKeys(Collection keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            this.removeKey(it.next());
        }
    }

    public void removeKey(Object key) {
        Iterator it = this.maps.iterator();
        while (it.hasNext()) {
            ((Map)it.next()).remove(key);
        }
    }

    public void retainKeys(Collection keys) {
        Iterator it = this.maps.iterator();
        while (it.hasNext()) {
            ((Map)it.next()).keySet().retainAll(keys);
        }
    }

    public void setKnownKeys(List keys) {
        this.knownKeys = new ArrayList(keys);
    }

    public List getKnownKeys() {
        if (this.knownKeys != null) {
            return this.knownKeys;
        }
        HashSet keyset = new HashSet();
        Iterator it = this.maps.iterator();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            keyset.addAll(map.keySet());
        }
        ArrayList keylist = new ArrayList(keyset);
        Collections.sort(keylist, this.keyComparator);
        return keylist;
    }
}

