/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class MappedFileInputStream
extends FileInputStream {
    private MappedByteBuffer mapped_;

    MappedFileInputStream(File file) throws IOException {
        super(file);
        FileChannel chan = this.getChannel();
        long size = chan.size();
        if (size >= Integer.MAX_VALUE) {
            throw new IOException("File too long to map");
        }
        this.mapped_ = chan.map(FileChannel.MapMode.READ_ONLY, 0L, size);
    }

    public int read() {
        return this.mapped_.hasRemaining() ? (int)this.mapped_.get() : -1;
    }

    public int read(byte[] buf) {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int leng) {
        int remain = this.mapped_.remaining();
        if (remain == 0) {
            return -1;
        }
        int count = Math.min(leng, remain);
        this.mapped_.get(buf, off, count);
        return count;
    }

    public long skip(long n) {
        int count = Math.min(this.mapped_.remaining(), (int)Math.min(Integer.MAX_VALUE, n));
        this.mapped_.position(this.mapped_.position() + count);
        return count;
    }

    public void close() throws IOException {
        this.getChannel().close();
        this.mapped_ = null;
        super.close();
    }
}

