/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.util.LoadException;

public class ObjectFactory {
    private final Class superClass_;
    private Map nameMap_ = new HashMap();
    private List nameList_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.util");

    public ObjectFactory(Class clazz) {
        this.superClass_ = clazz;
    }

    public Class getFactoryClass() {
        return this.superClass_;
    }

    public void register(String nickName, String className) {
        this.nameList_.add(nickName);
        this.nameMap_.put(nickName, className);
    }

    public String[] getNickNames() {
        return this.nameList_.toArray(new String[0]);
    }

    public boolean isRegistered(String name) {
        if (this.nameMap_.containsKey(name)) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(name);
            if (this.superClass_.isAssignableFrom(clazz)) {
                this.nameMap_.put(name, clazz.getName());
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Object createObject(String name) throws LoadException {
        Class<?> clazz;
        if (!this.isRegistered(name)) {
            throw new LoadException("Unknown classname/nickname " + name);
        }
        String className = (String)this.nameMap_.get(name);
        logger_.config("Instantiating " + className + " for " + name);
        try {
            clazz = Class.forName(className);
        }
        catch (LinkageError e) {
            throw new LoadException(name + ": can't load " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new LoadException(name + ": can't load " + className, e);
        }
        if (!this.superClass_.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz + " does not subclass " + this.superClass_);
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No no-arg constructor for " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            if (e2 instanceof Error) {
                throw (Error)e2;
            }
            throw new RuntimeException(e2);
        }
    }
}

