/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import uk.ac.starlink.util.gui.SelectCharacters;
import uk.ac.starlink.util.gui.SelectTextField;

public class SelectStringDialog
extends JDialog {
    protected SelectTextField textField = null;
    protected String value = null;

    public static String showDialog(Component component, String title, String labelText, String initialValue) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        SelectStringDialog dialog = new SelectStringDialog(frame, title, labelText, initialValue);
        dialog.setLocationRelativeTo(frame);
        dialog.show();
        return dialog.getValue();
    }

    private SelectStringDialog(Frame frame, String title, String labelText, String initialValue) {
        super(frame, title, true);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectStringDialog.this.acceptValue();
                SelectStringDialog.this.closeWindow();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectStringDialog.this.closeWindow();
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JPanel actionPane = new JPanel();
        SelectCharacters selectCharacters = new SelectCharacters(frame, "Select Characters", true, this.getFont());
        this.textField = new SelectTextField(initialValue, selectCharacters);
        this.textField.setColumns(25);
        JLabel label = new JLabel(labelText + ": ");
        actionPane.setLayout(new BoxLayout(actionPane, 0));
        actionPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        actionPane.add(Box.createHorizontalGlue());
        actionPane.add(label);
        actionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        actionPane.add(this.textField);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectStringDialog.this.acceptValue();
                SelectStringDialog.this.closeWindow();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(okButton);
        this.getContentPane().add((Component)actionPane, "North");
        this.getContentPane().add((Component)buttonPane, "South");
        this.pack();
    }

    protected String getValue() {
        return this.value;
    }

    protected void acceptValue() {
        this.value = this.textField.getText();
    }

    protected void closeWindow() {
        this.setVisible(false);
    }
}

