/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.engine.DefaultProperties;
import alma.acs.commandcenter.engine.Executor;
import alma.acs.commandcenter.engine.NativeCommand;
import alma.acs.commandcenter.engine.RunModel;
import alma.acs.commandcenter.engine.ToolManager;
import alma.acs.commandcenter.util.MiscUtils;
import alma.acs.util.ACSPorts;
import alma.acs.util.AcsLocations;
import alma.entity.xmlbinding.acscommandcentertools.Tool;
import com.cosylab.acs.maci.manager.app.Manager;
import java.util.Properties;

public class ExecuteManager {
    protected RunModel runModel;
    String[] localJavaManagerLocation;
    public String startLocalJavaPexpect = "Manager Application initialized";
    public String stopLocalJavaPexpect = "Destroyed.";
    private Manager localManager = null;

    public ExecuteManager(RunModel runModel) {
        this.runModel = runModel;
    }

    public String[] startLocalJava(NativeCommand.Listener listener) {
        DefaultProperties props = new DefaultProperties();
        String cdbHost = this.runModel.getManagerLocalJavaAgainstCDBHost();
        String cdbPort = this.runModel.getManagerLocalJavaAgainstCDBPort();
        props.setProperty("DAL.defaultReference", AcsLocations.convertToCdbLocation((String)cdbHost, (String)cdbPort));
        String mgrPort = this.runModel.getManagerLocalJavaPort();
        props.setProperty("OAPort", mgrPort);
        props.setProperty("ACS.noExit", "true");
        String acsInstance = this.runModel.getScriptBase();
        props.setProperty("ACS.tmp", props.getProperty("ACS.data") + "/tmp/ACS_INSTANCE." + acsInstance);
        Executor.localInProc(props, this.startLocalJavaPexpect, listener, new Executor.RunMain(){

            @Override
            public void runMain() {
                ExecuteManager.this.localManager = new Manager();
            }
        });
        this.localJavaManagerLocation = new String[]{ACSPorts.getIP(), mgrPort};
        return this.localJavaManagerLocation;
    }

    public void stopLocalJava() {
        NativeCommand.Listener listener = null;
        Properties props = new Properties();
        Executor.localInProc(props, this.stopLocalJavaPexpect, listener, new Executor.RunMain(){

            @Override
            public void runMain() {
                if (ExecuteManager.this.localManager != null) {
                    boolean sigInt = false;
                    ExecuteManager.this.localManager.shutdown(sigInt);
                }
            }
        });
    }

    public String[] startLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Manager_startLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000L, t.getExpectedOutput(), listener);
        String acsBasePort = this.runModel.getScriptBase();
        ACSPorts ports = ACSPorts.globalInstance((int)MiscUtils.parseInt(acsBasePort));
        return new String[]{ports.giveIP(), ports.giveManagerPort()};
    }

    public void stopLocalScript(NativeCommand.Listener listener) throws Throwable {
        Tool t = ToolManager.getBuiltinTool("Manager_stopLocalScript");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.localOutProc(command, true, t.getMaxStartupSeconds() * 1000L, t.getExpectedOutput(), listener);
    }

    public boolean startRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Manager_startRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        return Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }

    public void stopRemote(boolean nativeSSH, NativeCommand.Listener listener) throws Throwable {
        String host = this.runModel.getRemoteHost();
        String username = this.runModel.getRemoteAccount();
        String password = this.runModel.getRemotePassword();
        Tool t = ToolManager.getBuiltinTool("Manager_stopRemote");
        String command = ToolManager.generateCommand(t, this.runModel);
        Executor.remote(nativeSSH, username, password, command, t.getExpectedOutput(), listener, host);
    }
}

