/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.trace;

import alma.acs.commandcenter.trace.FlowListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class Flow {
    protected final Node UNDEF = new Node("");
    protected Map<String, Node> name2node = new HashMap<String, Node>();
    protected Node latestSuccess = this.UNDEF;
    protected Node nowTrying = this.UNDEF;
    protected Vector<FlowListener> listeners = new Vector();

    protected Node node(String name) {
        Node node = this.name2node.get(name);
        if (node == null) {
            node = new Node(name);
            this.name2node.put(name, node);
        }
        return node;
    }

    public void consistsOf(String parent, String[] kids) {
        for (int i = 0; i < kids.length; ++i) {
            this.node(parent).add(this.node(kids[i]));
        }
    }

    public String current() {
        Node step = this.nowTrying;
        if (step == this.UNDEF) {
            try {
                Node current = this.latestSuccess;
                if (current == null) {
                    current = this.node(null);
                }
                if ((step = (Node)current.getNextLeaf()) == null) {
                    step = (Node)this.node(null).getChildAt(0);
                }
            }
            catch (Exception exc) {
                System.err.println("Flow.failure: " + exc);
                step = this.UNDEF;
            }
        }
        return step.getName();
    }

    public void reset(Object info) {
        this.latestSuccess = this.UNDEF;
        this.nowTrying = this.UNDEF;
        this.fireReset(info);
    }

    public void trying(String step) {
        this.nowTrying = this.node(step);
        this.fireTrying(step);
    }

    public void success(String step) {
        this.latestSuccess = this.node(step);
        this.nowTrying = this.UNDEF;
        this.fireSuccess(step);
        if (this.latestSuccess.getNextLeaf() == null) {
            this.fireCompletion();
        }
    }

    public void failure(Object info) {
        String failed = this.current();
        this.fireFailure(failed, info);
    }

    protected void fireReset(Object info) {
        Object[] l = new FlowListener[this.listeners.size()];
        this.listeners.copyInto(l);
        for (int i = 0; i < l.length; ++i) {
            l[i].reset(this, info);
        }
    }

    protected void fireTrying(String step) {
        Object[] l = new FlowListener[this.listeners.size()];
        this.listeners.copyInto(l);
        for (int i = 0; i < l.length; ++i) {
            l[i].trying(this, step);
        }
    }

    protected void fireSuccess(String step) {
        Object[] l = new FlowListener[this.listeners.size()];
        this.listeners.copyInto(l);
        for (int i = 0; i < l.length; ++i) {
            l[i].success(this, step);
        }
    }

    protected void fireFailure(String step, Object info) {
        Object[] l = new FlowListener[this.listeners.size()];
        this.listeners.copyInto(l);
        for (int i = 0; i < l.length; ++i) {
            l[i].failure(this, step, info);
        }
    }

    protected void fireCompletion() {
        Object[] l = new FlowListener[this.listeners.size()];
        this.listeners.copyInto(l);
        for (int i = 0; i < l.length; ++i) {
            l[i].completion(this);
        }
    }

    public void addListener(FlowListener l) {
        this.listeners.add(l);
    }

    public void removeListener(FlowListener l) {
        this.listeners.remove(l);
    }

    protected class Node
    extends DefaultMutableTreeNode {
        protected Node(String name) {
            super(name);
        }

        protected String getName() {
            return String.valueOf(this.getUserObject());
        }
    }
}

