/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class ImageMath
implements PlugInFilter {
    private String arg;
    private ImagePlus imp;
    private boolean canceled;
    private boolean first;
    private double lower;
    private double upper;
    private static double addValue = 25.0;
    private static double mulValue = 1.25;
    private static double minValue = 0.0;
    private static double maxValue = 255.0;
    private static final String defaultAndValue = "11110000";
    private static String andValue = "11110000";
    private static final double defaultGammaValue = 0.5;
    private static double gammaValue = 0.5;

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        this.first = true;
        IJ.register(ImageMath.class);
        return IJ.setupDialog(imp, 95);
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (this.arg.equals("add")) {
            if (this.first) {
                addValue = this.getValue("Add", "Value: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add(addValue);
            return;
        }
        if (this.arg.equals("sub")) {
            if (this.first) {
                addValue = this.getValue("Subtract", "Value: ", addValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.add(-addValue);
            return;
        }
        if (this.arg.equals("mul")) {
            if (this.first) {
                mulValue = this.getValue("Multiply", "Value: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            ip.multiply(mulValue);
            return;
        }
        if (this.arg.equals("div")) {
            if (this.first) {
                mulValue = this.getValue("Divide", "Value: ", mulValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (mulValue != 0.0) {
                ip.multiply(1.0 / mulValue);
            }
            return;
        }
        if (this.arg.equals("and")) {
            if (this.first) {
                andValue = this.getBinaryValue("AND", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.and(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("or")) {
            if (this.first) {
                andValue = this.getBinaryValue("OR", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.or(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("xor")) {
            if (this.first) {
                andValue = this.getBinaryValue("XOR", "Value (binary): ", andValue);
            }
            if (this.canceled) {
                return;
            }
            try {
                ip.xor(Integer.parseInt(andValue, 2));
            }
            catch (NumberFormatException e) {
                andValue = defaultAndValue;
                IJ.error("Binary number required");
            }
            return;
        }
        if (this.arg.equals("min")) {
            if (this.first) {
                minValue = this.getValue("Min", "Value: ", minValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.min(minValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("max")) {
            if (this.first) {
                maxValue = this.getValue("Max", "Value: ", maxValue, 0);
            }
            if (this.canceled) {
                return;
            }
            ip.max(maxValue);
            if (!(ip instanceof ByteProcessor)) {
                ip.resetMinAndMax();
            }
            return;
        }
        if (this.arg.equals("gamma")) {
            if (this.first) {
                gammaValue = this.getValue("Gamma", "Value (0.1-5.0): ", gammaValue, 2);
            }
            if (this.canceled) {
                return;
            }
            if (gammaValue < 0.1 || gammaValue > 5.0) {
                IJ.error("Gamma must be between 0.1 and 5.0");
                gammaValue = 0.5;
                return;
            }
            ip.gamma(gammaValue);
            return;
        }
        if (this.arg.equals("log")) {
            ip.log();
            return;
        }
        if (this.arg.equals("exp")) {
            ip.exp();
            return;
        }
        if (this.arg.equals("sqr")) {
            ip.sqr();
            return;
        }
        if (this.arg.equals("sqrt")) {
            ip.sqrt();
            return;
        }
        if (this.arg.equals("reciprocal")) {
            if (!this.isFloat(ip)) {
                return;
            }
            float[] pixels = (float[])ip.getPixels();
            for (int i = 0; i < ip.getWidth() * ip.getHeight(); ++i) {
                pixels[i] = pixels[i] == 0.0f ? Float.NaN : 1.0f / pixels[i];
            }
            ip.resetMinAndMax();
            return;
        }
        if (this.arg.equals("nan")) {
            this.setBackgroundToNaN(ip);
            return;
        }
        if (this.arg.equals("abs")) {
            if (!(ip instanceof FloatProcessor) && !this.imp.getCalibration().isSigned16Bit()) {
                IJ.error("32-bit or signed 16-bit image required");
                this.canceled = true;
            } else {
                ip.abs();
                ip.resetMinAndMax();
            }
            return;
        }
    }

    boolean isFloat(ImageProcessor ip) {
        if (!(ip instanceof FloatProcessor)) {
            IJ.error("32-bit float image required");
            this.canceled = true;
            return false;
        }
        return true;
    }

    double getValue(String title, String prompt, double defaultValue, int digits) {
        int places = Analyzer.getPrecision();
        if (digits > 0 || (double)((int)defaultValue) != defaultValue) {
            digits = Math.max(places, 1);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addNumericField(prompt, defaultValue, digits, 8, null);
        gd.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextNumber();
    }

    String getBinaryValue(String title, String prompt, String defaultValue) {
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultValue);
        gd.showDialog();
        if (this.first) {
            this.imp.startTiming();
        }
        this.first = false;
        this.canceled = gd.wasCanceled();
        if (this.canceled) {
            return defaultValue;
        }
        return gd.getNextString();
    }

    void setBackgroundToNaN(ImageProcessor ip) {
        if (this.first) {
            this.lower = ip.getMinThreshold();
            this.upper = ip.getMaxThreshold();
            this.first = false;
            if (this.lower == -808080.0 || !(ip instanceof FloatProcessor)) {
                IJ.error("Thresholded 32-bit float image required");
                this.canceled = true;
                return;
            }
        }
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double v = pixels[y * width + x];
                if (!(v < this.lower) && !(v > this.upper)) continue;
                pixels[y * width + x] = Float.NaN;
            }
        }
        ip.resetMinAndMax();
    }
}

