/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.util.Tools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;

public class LineWidthAdjuster
extends PlugInFrame
implements PlugIn,
Runnable,
AdjustmentListener,
TextListener {
    int sliderRange = 100;
    Scrollbar slider;
    int value;
    boolean setText;
    static Frame instance;
    Thread thread;
    boolean done;
    TextField tf;

    public LineWidthAdjuster() {
        super("Line Width");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.slider = new Scrollbar(0, 1, 1, 1, this.sliderRange + 1);
        Panel panel = new Panel();
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(grid);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.ipadx = 75;
        c.insets = new Insets(5, 15, 5, 5);
        c.anchor = 17;
        grid.setConstraints(this.slider, c);
        panel.add(this.slider);
        c.ipadx = 0;
        c.gridx = 1;
        c.insets = new Insets(5, 5, 5, 15);
        c.anchor = 13;
        this.tf = new TextField("" + Line.getWidth(), 3);
        this.tf.addTextListener(this);
        grid.setConstraints(this.tf, c);
        panel.add(this.tf);
        this.add((Component)panel, "Center");
        this.slider.addAdjustmentListener(this);
        this.slider.setUnitIncrement(1);
        this.pack();
        this.setResizable(false);
        GUI.center(this);
        this.show();
        this.thread = new Thread((Runnable)this, "LineWidthAdjuster");
        this.thread.start();
        this.setup();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        this.value = this.slider.getValue();
        this.setText = true;
        this.notify();
    }

    public synchronized void textValueChanged(TextEvent e) {
        int width = (int)Tools.parseDouble(this.tf.getText(), -1.0);
        if (width == -1) {
            return;
        }
        if (width < 0) {
            width = 1;
        }
        if (width != Line.getWidth()) {
            this.slider.setValue(width);
            this.value = width;
            this.notify();
        }
    }

    void setup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            LineWidthAdjuster lineWidthAdjuster = this;
            synchronized (lineWidthAdjuster) {
                Roi roi;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.done) {
                    return;
                }
                Line.setWidth(this.value);
                if (this.setText) {
                    this.tf.setText("" + this.value);
                }
                this.setText = false;
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null && (roi = imp.getRoi()) != null) {
                    imp.draw();
                }
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        LineWidthAdjuster lineWidthAdjuster = this;
        synchronized (lineWidthAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
    }
}

