/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.test;

import nom.tam.util.ArrayFuncs;
import org.junit.Assert;
import org.junit.Test;

public class ArrayFuncsTester {
    @Test
    public void test() {
        int[][][] test1 = new int[10][9][8];
        boolean[][] test2 = new boolean[][]{new boolean[5], new boolean[4], new boolean[3], new boolean[2]};
        double[][] test3 = new double[10][20];
        StringBuffer[][] test4 = new StringBuffer[3][2];
        Assert.assertEquals((String)"getBaseClass()", Integer.TYPE, (Object)ArrayFuncs.getBaseClass(test1));
        Assert.assertEquals((String)"getBaseLength()", (Object)4, (Object)ArrayFuncs.getBaseLength(test1));
        Assert.assertEquals((String)"computeSize()", (Object)2880, (Object)ArrayFuncs.computeSize(test1));
        Assert.assertEquals((String)"computeLSize()", (Object)2880L, (Object)ArrayFuncs.computeLSize(test1));
        Assert.assertEquals((String)"getBaseClass(boolean)", Boolean.TYPE, (Object)ArrayFuncs.getBaseClass(test2));
        Assert.assertEquals((String)"getBaseLength(boolean)", (Object)1, (Object)ArrayFuncs.getBaseLength(test2));
        Assert.assertEquals((String)"computeSize() not rect", (Object)14, (Object)ArrayFuncs.computeSize(test2));
        Assert.assertEquals((String)"computeLSize() not rect", (Object)14L, (Object)ArrayFuncs.computeLSize(test2));
        Assert.assertEquals((String)"getBaseClass(double)", Double.TYPE, (Object)ArrayFuncs.getBaseClass(test3));
        Assert.assertEquals((String)"getBaseLength(double)", (Object)8, (Object)ArrayFuncs.getBaseLength(test3));
        Assert.assertEquals((String)"computeSize(double)", (Object)1600, (Object)ArrayFuncs.computeSize(test3));
        Assert.assertEquals((String)"computeLSize(double)", (Object)1600L, (Object)ArrayFuncs.computeLSize(test3));
        Assert.assertEquals((String)"getBaseClass(StrBuf)", StringBuffer.class, (Object)ArrayFuncs.getBaseClass(test4));
        Assert.assertEquals((String)"getBaseLength(StrBuf)", (Object)-1, (Object)ArrayFuncs.getBaseLength(test4));
        Assert.assertEquals((String)"computeSize(StrBuf)", (Object)0, (Object)ArrayFuncs.computeSize(test4));
        Assert.assertEquals((String)"computeLSize(StrBuf)", (Object)0L, (Object)ArrayFuncs.computeLSize(test4));
        Object[] agg = new Object[]{test1, test2, test3, test4};
        Assert.assertEquals((String)"getBaseClass(Object[])", Object.class, (Object)ArrayFuncs.getBaseClass(agg));
        Assert.assertEquals((String)"getBaseLength(Object[])", (Object)-1, (Object)ArrayFuncs.getBaseLength(agg));
        Assert.assertEquals((String)"computeSize(Object[])", (Object)4494, (Object)ArrayFuncs.computeSize(agg));
        Assert.assertEquals((String)"computeLSize(Object[])", (Object)4494L, (Object)ArrayFuncs.computeLSize(agg));
        try {
            float[][] data = new float[10000][30000];
            long expect = 1200000000L;
            Assert.assertEquals((String)"computLSize(big)", (Object)ArrayFuncs.computeLSize(data), (Object)expect);
        }
        catch (Error e) {
            System.out.println("Unable to allocate large array. Test skipped");
        }
        for (int i = 0; i < test1.length; ++i) {
            for (int j = 0; j < test1[i].length; ++j) {
                for (int k = 0; k < test1[i][j].length; ++k) {
                    test1[i][j][k] = i + j + k;
                }
            }
        }
        int[][][] test5 = (int[][][])ArrayFuncs.deepClone(test1);
        Assert.assertEquals((String)"deepClone()", (Object)true, (Object)ArrayFuncs.arrayEquals(test1, test5));
        test5[1][1][1] = -3;
        Assert.assertEquals((String)"arrayEquals()", (Object)false, (Object)ArrayFuncs.arrayEquals(test1, test5));
        int[] dimsOrig = ArrayFuncs.getDimensions(test1);
        int[] test6 = (int[])ArrayFuncs.flatten(test1);
        int[] dims = ArrayFuncs.getDimensions(test6);
        Assert.assertEquals((String)"getDimensions()", (Object)3, (Object)dimsOrig.length);
        Assert.assertEquals((String)"getDimensions()", (Object)10, (Object)dimsOrig[0]);
        Assert.assertEquals((String)"getDimensions()", (Object)9, (Object)dimsOrig[1]);
        Assert.assertEquals((String)"getDimensions()", (Object)8, (Object)dimsOrig[2]);
        Assert.assertEquals((String)"flatten()", (Object)1, (Object)dims.length);
        int[] newdims = new int[]{8, 9, 10};
        int[][][] test7 = (int[][][])ArrayFuncs.curl(test6, newdims);
        int[] dimsAfter = ArrayFuncs.getDimensions(test7);
        Assert.assertEquals((String)"curl()", (Object)3, (Object)dimsAfter.length);
        Assert.assertEquals((String)"getDimensions()", (Object)8, (Object)dimsAfter[0]);
        Assert.assertEquals((String)"getDimensions()", (Object)9, (Object)dimsAfter[1]);
        Assert.assertEquals((String)"getDimensions()", (Object)10, (Object)dimsAfter[2]);
        byte[][][] xtest1 = (byte[][][])ArrayFuncs.convertArray(test1, Byte.TYPE);
        Assert.assertEquals((String)"convertArray(toByte)", Byte.TYPE, (Object)ArrayFuncs.getBaseClass(xtest1));
        Assert.assertEquals((String)"convertArray(tobyte)", (Object)test1[3][3][3], (Object)xtest1[3][3][3]);
        double[][][] xtest2 = (double[][][])ArrayFuncs.convertArray(test1, Double.TYPE);
        Assert.assertEquals((String)"convertArray(toByte)", Double.TYPE, (Object)ArrayFuncs.getBaseClass(xtest2));
        Assert.assertEquals((String)"convertArray(tobyte)", (Object)test1[3][3][3], (Object)((int)xtest2[3][3][3]));
        int[] xtest3 = (int[])ArrayFuncs.newInstance(Integer.TYPE, 20);
        int[] xtd = ArrayFuncs.getDimensions(xtest3);
        Assert.assertEquals((String)"newInstance(vector)", (Object)1, (Object)xtd.length);
        Assert.assertEquals((String)"newInstance(vector)", (Object)20, (Object)xtd[0]);
        double[][][][] xtest4 = (double[][][][])ArrayFuncs.newInstance(Double.TYPE, new int[]{5, 4, 3, 2});
        xtd = ArrayFuncs.getDimensions(xtest4);
        Assert.assertEquals((String)"newInstance(tensor)", (Object)4, (Object)xtd.length);
        Assert.assertEquals((String)"newInstance(tensor)", (Object)5, (Object)xtd[0]);
        Assert.assertEquals((String)"newInstance(tensor)", (Object)4, (Object)xtd[1]);
        Assert.assertEquals((String)"newInstance(tensor)", (Object)3, (Object)xtd[2]);
        Assert.assertEquals((String)"newInstance(tensor)", (Object)2, (Object)xtd[3]);
        Assert.assertEquals((String)"nElements()", (Object)120, (Object)ArrayFuncs.nElements(xtest4));
        Assert.assertEquals((String)"nLElements()", (Object)120L, (Object)ArrayFuncs.nLElements(xtest4));
        ArrayFuncs.testPattern(xtest4, (byte)-1);
        Assert.assertEquals((String)"testPattern()", (Object)-1.0, (Object)xtest4[0][0][0][0]);
        Assert.assertEquals((String)"testPattern()", (Object)118.0, (Object)xtest4[4][3][2][1]);
        double[] xtest4x = (double[])ArrayFuncs.getBaseArray(xtest4);
        Assert.assertEquals((String)"getBaseArray()", (Object)2, (Object)xtest4x.length);
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] y = new double[x.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = x[i] + 1.0E-10;
        }
        Assert.assertEquals((String)"eqTest", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y));
        Assert.assertEquals((String)"eqTest2", (Object)true, (Object)ArrayFuncs.arrayEquals(x, y, 0.0, 1.0E-9));
        Assert.assertEquals((String)"eqTest3", (Object)true, (Object)ArrayFuncs.arrayEquals(x, y, 1.0E-5, 1.0E-9));
        Assert.assertEquals((String)"eqTest4", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y, 0.0, 1.0E-11));
        Assert.assertEquals((String)"eqTest5", (Object)false, (Object)ArrayFuncs.arrayEquals(x, y, 1.0E-5, 0.0));
        float[] fx = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        float[] fy = new float[fx.length];
        for (int i = 0; i < fy.length; ++i) {
            fy[i] = fx[i] + 1.0E-5f;
        }
        Assert.assertEquals((String)"eqTest6", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy));
        Assert.assertEquals((String)"eqTest7", (Object)true, (Object)ArrayFuncs.arrayEquals(fx, fy, 1.0E-4, 0.0));
        Assert.assertEquals((String)"eqTest8", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 1.0E-6, 0.0));
        Assert.assertEquals((String)"eqTest9", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 0.0, 0.0));
        Assert.assertEquals((String)"eqTest10", (Object)false, (Object)ArrayFuncs.arrayEquals(fx, fy, 0.0, 1.0E-4));
    }
}

