/*
 * Decompiled with CFR 0.152.
 */
package skyview.executive;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.xmlrpc.StandardClientProfile;
import skyview.executive.Imager;
import skyview.executive.Settings;

public class Samp {
    private static HubConnection hc;

    public static void notifyFile() {
        try {
            HashMap<String, String> hm = new HashMap<String, String>();
            String uri = new File(Settings.get("output_fits")).toURI().toString();
            hm.put("url", uri);
            hm.put("name", "SkV:" + Settings.get("_currentSurvey"));
            hm.put("image-id", "SkV:" + Settings.get("_currentSurvey"));
            Message msg = new Message("image.load.fits", hm);
            if (hc == null) {
                StandardClientProfile scp = StandardClientProfile.getInstance();
                if (scp != null) {
                    hc = scp.register();
                    if (hc != null) {
                        HashMap<String, String> meta = new HashMap<String, String>();
                        meta.put("samp.name", "SkyView " + Imager.getVersion());
                        meta.put("samp.description.text", "SkyView Image Generation Service");
                        meta.put("samp.documentation.url", "http://skyview.gsfc.nasa.gov/help/help.html");
                        hc.declareMetadata(meta);
                    } else {
                        System.err.println("  Unable to get HubConnection.  No hub?");
                    }
                } else {
                    System.err.println("  Unable to get SAMP standard profile");
                }
            }
            if (hc != null) {
                hc.notifyAll((Map)msg);
            }
        }
        catch (Exception e) {
            System.err.println("  Unable to send SAMP notification. Error: " + e);
        }
    }
}

