/*
 * Decompiled with CFR 0.152.
 */
package skyview.executive;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Pattern;
import skyview.survey.Util;

public class Settings {
    private static HashMap<String, String> single = new HashMap();
    private static Stack<HashMap<String, String>> backup = new Stack();
    private static Pattern comma = Pattern.compile(",");
    private static Pattern equal = Pattern.compile("=");

    static void initializeSettings() {
        String settingsFile = System.getenv("SKYVIEW_SETTINGS");
        if (settingsFile == null) {
            settingsFile = "skyview.settings";
        }
        Settings.updateFromFile(settingsFile);
    }

    public static void updateFromFile(String settingsFile) {
        BufferedReader ir = null;
        try {
            InputStream is = Util.getResourceOrFile(settingsFile);
            if (is != null) {
                ir = new BufferedReader(new InputStreamReader(is));
            }
        }
        catch (Exception e) {
            System.err.println("Exception noted when attempting to open settings file/resource:" + settingsFile + "\n" + e);
            ir = null;
        }
        if (ir != null) {
            Settings.readFile(ir);
        } else {
            System.err.println("Unable to find settings. Continuing with defaults.");
        }
    }

    static void readFile(BufferedReader ir) {
        try {
            String line;
            Pattern eq = Pattern.compile("=");
            while ((line = ir.readLine()) != null) {
                char first;
                if ((line = line.trim()).length() < 2 || line.charAt(0) == '#') continue;
                String[] parse = eq.split(line, 2);
                if (parse.length > 2) {
                    System.err.println("Unparseable line in input settings:\n   " + line);
                    continue;
                }
                String val = "1";
                if (parse.length == 2) {
                    val = parse[1];
                }
                if ((first = val.charAt(0)) == '$' && (val = System.getenv(val.substring(1))) == null) continue;
                Settings.put(parse[0], val);
            }
        }
        catch (Exception e) {
            System.err.println("Exception caught parsing settings:\n" + e);
        }
    }

    public static void addArgs(String[] args) {
        for (String arg : args) {
            String[] tokens;
            if (arg.charAt(arg.length() - 1) == '\r') {
                arg = arg.substring(0, arg.length() - 1);
            }
            if ((tokens = equal.split(arg, 2)).length == 2) {
                String key = tokens[0];
                Settings.put(key, tokens[1]);
                continue;
            }
            Settings.put(arg, "1");
        }
    }

    private Settings() {
    }

    public static String get(String key) {
        if (key == null) {
            return null;
        }
        return single.get(key.toLowerCase());
    }

    public static String get(String key, String dft) {
        String gt = Settings.get(key);
        if (gt == null) {
            return dft;
        }
        return gt;
    }

    public static String[] getArray(String key) {
        String gt = Settings.get(key);
        if (gt == null) {
            return new String[0];
        }
        return comma.split(gt);
    }

    public static void suggest(String key, String value) {
        if (Settings.has(key)) {
            return;
        }
        if (Settings.has("_nullvalues")) {
            String[] keys;
            key = key.toLowerCase();
            for (String nullKey : keys = Settings.getArray("_nullvalues")) {
                if (!nullKey.equals(key)) continue;
                return;
            }
        }
        Settings.put(key, value);
    }

    public static void put(String key, String value) {
        key = key.toLowerCase();
        if (value == null) {
            value = "1";
        }
        if (value.equals("null")) {
            Settings.add("_nullvalues", key);
            single.remove(key);
            return;
        }
        if (value.length() > 1 && (value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
            char last = value.charAt(value.length() - 1);
            if (value.charAt(0) == last) {
                value = value.substring(1, value.length() - 1);
            }
        }
        single.put(key, value);
    }

    public static void save() {
        backup.push(single);
        single = (HashMap)single.clone();
    }

    public static void add(String key, String value) {
        if (value == null) {
            if (!Settings.has(key)) {
                Settings.put(key, value);
            }
            return;
        }
        String[] oldVals = Settings.getArray(key);
        if (oldVals.length == 1 && oldVals[0].equals("null")) {
            Settings.put(key, value);
            return;
        }
        String newValue = "";
        String comma = "";
        for (int i = 0; i < oldVals.length; ++i) {
            if (oldVals[i].equals(value)) {
                return;
            }
            newValue = newValue + comma + oldVals[i];
            comma = ",";
        }
        newValue = newValue + comma + value;
        Settings.put(key, newValue);
    }

    public static boolean has(String key) {
        return single.containsKey(key.toLowerCase());
    }

    public static String[] getKeys() {
        return single.keySet().toArray(new String[0]);
    }

    public static void restore() {
        if (!backup.empty()) {
            single = backup.pop();
        } else {
            System.err.println("Attempt to restore Settings ignored: No previous state saved.");
        }
    }

    public static HashMap<String, String> pop() {
        if (backup.size() > 0) {
            HashMap<String, String> curr = single;
            Settings.restore();
            return curr;
        }
        System.err.println("Error: Attempt to pop Settings, but stack is empty");
        return single;
    }

    public static void push(HashMap<String, String> top) {
        Settings.save();
        single = top;
    }

    static {
        Settings.initializeSettings();
    }
}

