/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.Util;
import skyview.geometry.projecter.AitStraddle;
import skyview.geometry.projecter.Straddle;

public class Ait
extends Projecter {
    private Straddle myStraddler = new AitStraddle(this);

    @Override
    public String getName() {
        return "Ait";
    }

    @Override
    public String getDescription() {
        return "Project to an Hammer-Aitoff projection (often used for all sky data)";
    }

    @Override
    public Deprojecter inverse() {
        return new AitDeproj();
    }

    @Override
    public boolean isInverse(Transformer trans) {
        return trans.getName().equals("AitDeproj");
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            Ait.forwardTransform(sphere, plane);
        }
    }

    public static void forwardTransform(double[] sphere, double[] plane) {
        double cos_l2;
        double cos_b = Math.sqrt(1.0 - sphere[2] * sphere[2]);
        double cos_l = 0.0;
        if (1.0 - Math.abs(sphere[2]) > 1.0E-10) {
            cos_l = sphere[0] / cos_b;
        }
        cos_l2 = (cos_l2 = 0.5 * (1.0 + cos_l)) > 0.0 ? Math.sqrt(cos_l2) : 0.0;
        double sin_l2 = 0.5 * (1.0 - cos_l);
        sin_l2 = sin_l2 > 0.0 ? Math.sqrt(sin_l2) : 0.0;
        if (sphere[1] < 0.0) {
            sin_l2 = -sin_l2;
        }
        double gamma = Math.sqrt(2.0 / (1.0 + cos_b * cos_l2));
        plane[0] = 2.0 * gamma * cos_b * sin_l2;
        plane[1] = gamma * sphere[2];
    }

    public static void reverseTransform(double[] plane, double[] sphere) {
        double z = 1.0 - plane[0] * plane[0] / 16.0 - plane[1] * plane[1] / 4.0;
        z = z > 0.0 ? Math.sqrt(z) : 0.0;
        sphere[2] = plane[1] * z;
        double cos_b = Math.sqrt(1.0 - sphere[2] * sphere[2]);
        if (Math.abs(cos_b) > 1.0E-12) {
            double sl2 = z * plane[0] / (2.0 * cos_b);
            double cl2 = (2.0 * z * z - 1.0) / cos_b;
            double cl = 2.0 * cl2 * cl2 - 1.0;
            double sl = 2.0 * sl2 * cl2;
            sphere[0] = cl * cos_b;
            sphere[1] = sl * cos_b;
        } else {
            sphere[0] = 0.0;
            sphere[1] = 0.0;
        }
    }

    @Override
    public boolean validPosition(double[] plane) {
        return super.validPosition(plane) && plane[0] * plane[0] / 8.0 + plane[1] * plane[1] / 2.0 <= 1.0;
    }

    @Override
    public boolean straddleable() {
        return true;
    }

    @Override
    public boolean straddle(double[][] pnts) {
        return this.myStraddler.straddle(pnts);
    }

    @Override
    public double[] shadowPoint(double x, double y) {
        double[] xx = new double[]{x, y};
        double[] pnt = new double[3];
        Ait.reverseTransform(xx, pnt);
        double slat = pnt[2];
        double clat = 1.0 - slat * slat;
        if (clat < 0.0) {
            clat = 0.0;
        }
        clat = Math.sqrt(clat);
        double lon = Math.atan2(pnt[1], pnt[0]);
        lon = lon <= 0.0 ? (lon += Math.PI * 2) : (lon -= Math.PI * 2);
        double gamma = 1.0 + clat * Math.cos(lon / 2.0);
        gamma = gamma > 0.0 ? Math.sqrt(2.0 / gamma) : 0.0;
        double[] res = new double[]{2.0 * gamma * clat * Math.sin(lon / 2.0), gamma * slat};
        if (x > 0.0 && res[0] > 0.0 || x < 0.0 && res[0] < 0.0) {
            res[0] = -res[0];
        }
        return res;
    }

    @Override
    public double[][][] straddleComponents(double[][] input) {
        return this.myStraddler.straddleComponents(input);
    }

    public static void main(String[] args) {
        Ait p = new Ait();
        double ra = Double.parseDouble(args[0]);
        double dec = Double.parseDouble(args[1]);
        double rra = Math.toRadians(ra);
        double rdec = Math.toRadians(dec);
        double[] unit = Util.unit(rra, dec);
        double[] pnt = new double[2];
        p.transform(unit, pnt);
        double[] shadow = p.shadowPoint(pnt[0], pnt[1]);
        System.err.printf("Decimal degrees: %10.5f %10.5f\n", ra, dec);
        System.err.printf("Radians:         %10.5f %10.5f\n", rra, rdec);
        System.err.printf("Unit vector:     %10.5f %10.5f %10.5f\n", unit[0], unit[1], unit[2]);
        System.err.printf("Map position:    %10.5f %10.5f\n", pnt[0], pnt[1]);
        System.err.printf("Shadow position: %10.5f %10.5f\n", shadow[0], shadow[1]);
    }

    public class AitDeproj
    extends Deprojecter {
        @Override
        public String getName() {
            return "AitDeproj";
        }

        @Override
        public String getDescription() {
            return "Deproject from a Hammer-Aitoff ellipse back to the sphere.";
        }

        @Override
        public Projecter inverse() {
            return Ait.this;
        }

        @Override
        public boolean isInverse(Transformer trans) {
            return trans.getName().equals("Ait");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (!Ait.this.validPosition(plane)) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                Ait.reverseTransform(plane, sphere);
            }
        }
    }
}

