/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class Tan
extends Projecter {
    @Override
    public String getName() {
        return "Tan";
    }

    @Override
    public String getDescription() {
        return "Project to a tangent plane touching the sphere";
    }

    @Override
    public boolean allValid() {
        return true;
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2]) || sphere[2] < 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double fac = 1.0 / sphere[2];
            plane[0] = fac * sphere[0];
            plane[1] = fac * sphere[1];
        }
    }

    @Override
    public Deprojecter inverse() {
        return new TanDeproj();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("TanDeproj");
    }

    public class TanDeproj
    extends Deprojecter {
        @Override
        public String getName() {
            return "TanDeproj";
        }

        @Override
        public String getDescription() {
            return "Transform from the tangent plane to the sphere";
        }

        @Override
        public Projecter inverse() {
            return Tan.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("Tan");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double factor = 1.0 / Math.sqrt(plane[0] * plane[0] + plane[1] * plane[1] + 1.0);
                sphere[0] = factor * plane[0];
                sphere[1] = factor * plane[1];
                sphere[2] = factor;
            }
        }
    }
}

