/*
 * Decompiled with CFR 0.152.
 */
package skyview.process.imagefinder;

import java.util.ArrayList;
import nom.tam.fits.Header;
import skyview.geometry.Util;
import skyview.process.imagefinder.MaxExposure;
import skyview.survey.FitsImage;
import skyview.survey.Image;
import skyview.survey.ProxyImage;

public class GalexExposure
extends MaxExposure {
    private ArrayList<double[]> centers = new ArrayList();

    @Override
    protected double radiusSquared(double tx, double ty, double nx, double ny, int index, Image input) {
        double[] center = null;
        if (index < this.centers.size()) {
            center = this.centers.get(index);
        } else {
            for (int i = this.centers.size(); i <= index; ++i) {
                this.centers.add(null);
            }
        }
        if (center == null) {
            FitsImage img;
            if (!input.valid()) {
                input.validate();
            }
            if (input instanceof FitsImage) {
                img = (FitsImage)input;
            } else if (input instanceof ProxyImage) {
                img = (FitsImage)((ProxyImage)input).getBaseImage();
            } else {
                System.err.println("  Invalid image type for GALEX image");
                this.centers.set(index, new double[]{Double.NaN, Double.NaN});
                return Double.NaN;
            }
            Header hdr = img.getHeader();
            double actRA = Math.toRadians(hdr.getDoubleValue("AVASPRA"));
            double actDec = Math.toRadians(hdr.getDoubleValue("AVASPDEC"));
            double[] pixelCenter = this.getImage(input, Util.unit(actRA, actDec));
            center = (double[])pixelCenter.clone();
            this.centers.set(index, center);
        }
        return (tx - center[0]) * (tx - center[0]) + (ty - center[1]) * (ty - center[1]);
    }
}

