<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!--Two significant sets of changes, plus some minor ones.
    Major 1: Change to schemaversioning, modify the top level and the entity
    Major 2: Significant structural changes to the SpectralSpec item for total power work
    Minors: Add uniDirectionalScan to HolographyParameters
-->

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<!-- This forms the basis of the project document transform, ensuring that the information is copied.
     All other templates will override this to do something else -->

<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
 
<!-- All unit attributes with certain values need changing -->
   <xsl:template match="@unit">
      <xsl:choose>
         <xsl:when test="current()='sec'">
            <xsl:attribute name="unit">s</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='min'">
            <xsl:attribute name="unit">m</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='hrs'">
            <xsl:attribute name="unit">h</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='degrees'">
            <xsl:attribute name="unit">deg</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='radians'">
            <xsl:attribute name="unit">rad</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='micsec'">
            <xsl:attribute name="unit">us</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='msec'">
            <xsl:attribute name="unit">ms</xsl:attribute>
         </xsl:when>
         <xsl:when test="current()='nsec'">
            <xsl:attribute name="unit">ns</xsl:attribute>
         </xsl:when>
         <xsl:otherwise>
            <xsl:copy-of select="."/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

<!-- Remove TotalPowerMeasurement - no longer needed -->
   <xsl:template match="id:TotalPowerMeasurement"></xsl:template>
   
<xsl:template match="id:SchedBlock">
<SchedBlock xmlns="Alma/ObsPrep/SchedBlock">
  <xsl:attribute name="schemaVersion">7</xsl:attribute>
  <xsl:attribute name="revision"><xsl:value-of select="id:SchedBlockEntity/@datamodelVersion"/></xsl:attribute>
  <xsl:attribute name="xsi:type">SchedBlock</xsl:attribute>
  <xsl:apply-templates select="node()"/> 
  <xsl:comment>Converted to V7 by SchedBlock60-7.xslt</xsl:comment>
</SchedBlock>
</xsl:template>

<xsl:template match="id:SchedBlockEntity">
<SchedBlockEntity>
<xsl:attribute name="entityId"><xsl:value-of select="@entityId"/></xsl:attribute>
<xsl:attribute name="entityIdEncrypted"><xsl:value-of select="@entityIdEncrypted"/></xsl:attribute>
<xsl:attribute name="entityTypeName"><xsl:value-of select="@entityTypeName"/></xsl:attribute>
<xsl:attribute name="schemaVersion">7</xsl:attribute>
</SchedBlockEntity>
</xsl:template>


<!-- Change the holography parameters, to add  uniDirectionalScan -->
<xsl:template match="id:HolographyParameters">
<HolographyParameters>
   <xsl:attribute name="entityPartId"><xsl:value-of select="./@entityPartId"/></xsl:attribute>
   <xsl:attribute name="towerName"><xsl:value-of select="./@towerName"/></xsl:attribute>
   <xsl:attribute name="scanDirection"><xsl:value-of select="./@scanDirection"/></xsl:attribute>
   <xsl:attribute name="calMode"><xsl:value-of select="./@calMode"/></xsl:attribute>

<!-- Add uniDirectionalScan -->
   <uniDirectionalScan>false</uniDirectionalScan>

<!-- Simply copy most things -->
   <xsl:apply-templates select="./id:nRows"/>
   <xsl:apply-templates select="./id:rowSize"/>
   <xsl:apply-templates select="./id:name"/>
   <xsl:apply-templates select="./id:frequency"/>
   <xsl:apply-templates select="./id:startFraction"/>
   <xsl:apply-templates select="./id:speed"/>
   <xsl:apply-templates select="./id:rowsCal"/>
   <xsl:apply-templates select="./id:calTime"/>
   
</HolographyParameters>
</xsl:template>

<!-- SpectralSpec: Major changes to baseband configs and creation of baseband spec etc -->

<xsl:template match="id:SpectralSpec">

<SpectralSpec>
<xsl:apply-templates select="./@entityPartId"></xsl:apply-templates>
   <xsl:choose>
      <xsl:when test="id:BLCorrelatorConfiguration">
         <xsl:if test="id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]">
            <xsl:attribute name="switchingType"><xsl:value-of select="id:BLCorrelatorConfiguration/id:BLBaseBandConfig/@switchingType"/></xsl:attribute>
         </xsl:if>
         <xsl:attribute name="receiverType"><xsl:value-of select="id:BLCorrelatorConfiguration/@receiverType"/></xsl:attribute>
         <xsl:apply-templates select="./id:name"/>
         <xsl:apply-templates select="./id:integrationTime"/>
         <xsl:apply-templates select="./id:dynamicRange"/>
         <subScanDuration>
            <xsl:apply-templates select="@unit"/>
            <xsl:value-of select="id:BLCorrelatorConfiguration/id:subScanDuration"/></subScanDuration>
         <!-- Switching - only if not NO_SWITCHING -->
         <xsl:choose>
             <xsl:when test="id:BLCorrelatorConfiguration/id:BLBaseBandConfig/@switchingType!=NO_SWITCHING">
             <SwitchingCycle>
                <numberOfPositions><xsl:value-of select="id:BLCorrelatorConfiguration/id:BLBaseBandConfig/id:numberOfPositions"/></numberOfPositions>
                <xsl:copy-of select="id:BLCorrelatorConfiguration/id:BLBaseBandConfig/id:dwellTime"/>
                <xsl:copy-of select="id:BLCorrelatorConfiguration/id:BLBaseBandConfig/id:deadTime"/>
             </SwitchingCycle>
             </xsl:when>
         </xsl:choose>
         <xsl:apply-templates select="./id:BLCorrelatorConfiguration"/>
      </xsl:when>
      <xsl:when test="id:ACACorrelatorConfiguration"> 
         <xsl:if test="id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]">
         <xsl:attribute name="switchingType"><xsl:value-of select="id:ACACorrelatorConfiguration/id:ACABaseBandConfig/@switchingType"/></xsl:attribute>
         </xsl:if>
         <xsl:attribute name="receiverType"><xsl:value-of select="id:ACACorrelatorConfiguration/@receiverType"/></xsl:attribute>
         <xsl:apply-templates select="./id:name"/>
         <xsl:apply-templates select="./id:integrationTime"/>
         <xsl:apply-templates select="./id:dynamicRange"/>
         <subScanDuration><xsl:value-of select="id:ACACorrelatorConfiguration/id:subScanDuration"/></subScanDuration>
         <!-- Switching - only if not NO_SWITCHING -->
         <xsl:choose>
            <xsl:when test="id:ACACorrelatorConfiguration/id:ACABaseBandConfig/@switchingType!=NO_SWITCHING">
               <SwitchingCycle>
                  <numberOfPositions><xsl:value-of select="id:ACACorrelatorConfiguration/id:ACABaseBandConfig/id:numberOfPositions"/></numberOfPositions>
                  <xsl:copy-of select="id:ACACorrelatorConfiguration/id:ACABaseBandConfig/id:dwellTime"/>
                  <xsl:copy-of select="id:ACACorrelatorConfiguration/id:ACABaseBandConfig/id:deadTime"/>
               </SwitchingCycle>
            </xsl:when>
         </xsl:choose>
         <xsl:apply-templates select="./id:ACACorrelatorConfiguration"/>
      </xsl:when>
   </xsl:choose>
   <xsl:apply-templates select="./id:FrequencySetup"/>
</SpectralSpec>
</xsl:template>

<xsl:template match="id:FrequencySetup">
<xsl:param name="sspec"><xsl:value-of select="../@entityPartId"/></xsl:param>
   
<FrequencySetup>
   
   <xsl:attribute name="transitionName"><xsl:value-of select="./id:transitionName"/></xsl:attribute>
   <xsl:attribute name="receiverBand"><xsl:value-of select="./@receiverBand"/></xsl:attribute>
   <xsl:apply-templates select="./id:restFrequency"/>
   <lO1Frequency>
      <xsl:attribute name="unit"><xsl:value-of select="../id:lO1Frequency/@unit"/></xsl:attribute>
      <xsl:value-of select="../id:lO1Frequency"/>
   </lO1Frequency>
   <xsl:choose>
      <xsl:when test="../id:BLCorrelatorConfiguration">
         <!-- Create a basebandspec for each BBC, up to max of 4 -->
         <xsl:if test="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]">
         <BaseBandSpecification>
            <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/@baseBandName"/></xsl:attribute>
            <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
            <xsl:attribute name="baseBandName"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/@baseBandName"/></xsl:attribute>
            <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/@sideBandSeparationMode"/></xsl:attribute>
            <centerFrequencyRest>
               <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/id:centerFrequency/@unit"/></xsl:attribute>
               <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/id:centerFrequency"/>
            </centerFrequencyRest>
            <lO2Frequency>
               <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/id:lO2Frequency/@unit"/></xsl:attribute>
               <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=1]/id:lO2Frequency"/>
            </lO2Frequency>
            <frequencySwitching>false</frequencySwitching>
         </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=2]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=3]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:BLCorrelatorConfiguration/id:BLBaseBandConfig[position()=4]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
      </xsl:when>
      <xsl:when test="../id:ACACorrelatorConfiguration">
         <xsl:if test="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]">
         <BaseBandSpecification>
            <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/@baseBandName"/></xsl:attribute>
            <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
            <xsl:attribute name="baseBandName"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/@baseBandName"/></xsl:attribute>
            <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/@sideBandSeparationMode"/></xsl:attribute>
            <centerFrequencyRest>
               <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/id:centerFrequency/@unit"/></xsl:attribute>
               <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/id:centerFrequency"/>
            </centerFrequencyRest>
            <lO2Frequency>
               <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/id:lO2Frequency/@unit"/></xsl:attribute>
               <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=1]/id:lO2Frequency"/>
            </lO2Frequency>
            <frequencySwitching>false</frequencySwitching>
         </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=2]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=3]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
         <xsl:if test="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]">
            <BaseBandSpecification>
               <xsl:attribute name="entityPartId"><xsl:value-of select="$sspec"/><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="almatype">APDM::BaseBandSpecification</xsl:attribute>
               <xsl:attribute name="baseBandName"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/@baseBandName"/></xsl:attribute>
               <xsl:attribute name="sideBandSeparationMode"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/@sideBandSeparationMode"/></xsl:attribute>
               <centerFrequencyRest>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/id:centerFrequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/id:centerFrequency"/>
               </centerFrequencyRest>
               <lO2Frequency>
                  <xsl:attribute name="unit"><xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/id:lO2Frequency/@unit"/></xsl:attribute>
                  <xsl:value-of select="../id:ACACorrelatorConfiguration/id:ACABaseBandConfig[position()=4]/id:lO2Frequency"/>
               </lO2Frequency>
               <frequencySwitching>false</frequencySwitching>
            </BaseBandSpecification>
         </xsl:if>
      </xsl:when>
      </xsl:choose>
</FrequencySetup>

</xsl:template>

<!-- BLCorrelatorConfiguration - need to remove subscanduration -->
 <xsl:template match="id:BLCorrelatorConfiguration">
 <BLCorrelatorConfiguration>
    <xsl:apply-templates select="./@aPCDataSets"></xsl:apply-templates>
    <xsl:apply-templates select="./@receiverType"></xsl:apply-templates>
    <xsl:apply-templates select="./id:integrationDuration"></xsl:apply-templates>
    <xsl:apply-templates select="./id:channelAverageDuration"></xsl:apply-templates>
    <xsl:apply-templates select="./id:dumpDuration"></xsl:apply-templates>
    <xsl:for-each select="./id:BLBaseBandConfig">
       <xsl:apply-templates select="."></xsl:apply-templates>
    </xsl:for-each>
 </BLCorrelatorConfiguration>     
 </xsl:template>
   
   <!-- ACACorrelatorConfiguration - need to remove subscanduration -->
   <xsl:template match="id:ACACorrelatorConfiguration">
      <ACACorrelatorConfiguration>
         <xsl:apply-templates select="./@aPCDataSets"></xsl:apply-templates>
         <xsl:apply-templates select="./@receiverType"></xsl:apply-templates>
         <xsl:apply-templates select="./id:integrationDuration"></xsl:apply-templates>
         <xsl:apply-templates select="./id:channelAverageDuration"></xsl:apply-templates>
         <xsl:apply-templates select="./id:ACAPhaseSwitchingConfiguration"/>
         <xsl:for-each select="./id:ACABaseBandConfig">
            <xsl:apply-templates select="."></xsl:apply-templates>
         </xsl:for-each>
      </ACACorrelatorConfiguration>     
   </xsl:template>
   
<!-- BLBaseBandCOnfig -->
<xsl:template match="id:BLBaseBandConfig">
<BLBaseBandConfig>
   <xsl:apply-templates select="./@cAM"/>
   <xsl:apply-templates select="./@dataProducts"/> 
   <xsl:apply-templates select="./@sideBandSeparationMode"/> 
   <!-- Add a BaseBandSpecificationRef -->
   <BaseBandSpecificationRef>
      <xsl:attribute name="entityId"><xsl:value-of select="../../../id:SchedBlockEntity/@entityId"/></xsl:attribute>
      <xsl:attribute name="partId"><xsl:value-of select="../../@entityPartId"/><xsl:value-of select="@baseBandName"/></xsl:attribute>
      <xsl:attribute name="entityTypeName">SchedBlock</xsl:attribute>
   </BaseBandSpecificationRef>
   <xsl:apply-templates select="id:BLSpectralWindow"/>
</BLBaseBandConfig>
</xsl:template>

<!-- ACABaseBandCOnfig -->
<xsl:template match="id:ACABaseBandConfig">
<ACABaseBandConfig>
   <xsl:apply-templates select="./@cAM"/>
   <xsl:apply-templates select="./@dataProducts"/> 
   <xsl:apply-templates select="./@sideBandSeparationMode"/> 
   <!-- Add a BaseBandSpecificationRef -->
   <BaseBandSpecificationRef>
      <xsl:attribute name="entityId"><xsl:value-of select="../../../id:SchedBlockEntity/@entityId"/></xsl:attribute>
      <xsl:attribute name="partId"><xsl:value-of select="../../@entityPartId"/><xsl:value-of select="@baseBandName"/></xsl:attribute>
      <xsl:attribute name="entityTypeName">SchedBlock</xsl:attribute>
   </BaseBandSpecificationRef>
   <xsl:apply-templates select="id:centerFreqOfResidualDelay"/>
   <xsl:apply-templates select="id:ACASpectralWindow"/>
</ACABaseBandConfig>
</xsl:template>
   
<!-- ACACorrelatorConfiguration -->
<xsl:template match="id:ACACorrelatorConfig">
<ACACorrelatorConfiguration>
   <xsl:attribute name="aPCDataSets"><xsl:value-of select="./@aPCDataSets"/></xsl:attribute>
   <xsl:apply-templates select="./id:integrationDuration"/>
   <xsl:apply-templates select="./id:channelAverageDuration"/>
  
</ACACorrelatorConfiguration>
</xsl:template>
   
   <!-- Need to add 2000MHz to the spectral window frequencies -->
   <xsl:template match="id:centerFrequency">
      <centerFrequency>
         <xsl:apply-templates select="./@unit"/>
         <xsl:choose>
            <xsl:when test="./@unit='MHz'">
               <xsl:value-of select="self::node()+2000.0"/>
            </xsl:when>
            <xsl:when test="./@unit='GHz'">
               <xsl:value-of select="self::node()+2.0"/>
            </xsl:when>
         </xsl:choose>
      </centerFrequency>
      
   </xsl:template>

<xsl:template match="id:Target">
   <Target>
      <xsl:apply-templates select="./@entityPartId"></xsl:apply-templates>
      <AbstractInstrumentSpecRef>
         <xsl:attribute name="enityId"><xsl:value-of select="../id:SchedBlockEntity/@entityId"/></xsl:attribute>
         <xsl:attribute name="partId"><xsl:value-of select="./id:abstractInstrumentSpecId"/></xsl:attribute>
         <xsl:attribute name="entityTypeName">SchedBlock</xsl:attribute>
      </AbstractInstrumentSpecRef>
      <FieldSourceRef>
         <xsl:attribute name="enityId"><xsl:value-of select="../id:SchedBlockEntity/@entityId"/></xsl:attribute>
         <xsl:attribute name="partId"><xsl:value-of select="./id:fieldSourceId"/></xsl:attribute>
         <xsl:attribute name="entityTypeName">SchedBlock</xsl:attribute>
      </FieldSourceRef>
      <xsl:for-each select="./id:observingParametersIdList">
      <ObservingParametersRef>
         <xsl:attribute name="enityId"><xsl:value-of select="../id:SchedBlockEntity/@entityId"/></xsl:attribute>
         <xsl:attribute name="partId"><xsl:value-of select="."/></xsl:attribute>
         <xsl:attribute name="entityTypeName">SchedBlock</xsl:attribute>
      </ObservingParametersRef>
       </xsl:for-each>
   </Target>
</xsl:template>

</xsl:stylesheet>
