<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- for every item element where cost is less than value -->
<xsl:template match="item[@cost &lt; @value]">
      <xsl:copy>
           <!-- copy everything EXCEPT the value attribute -->
           <xsl:copy-of  select="@*[name() != 'value']"/>
           <!-- create a new cost attribute.. -->
           <xsl:attribute name="value">
               <!-- ...and make it's contents the value times 0.92 (deprc.n) -->
               <xsl:value-of select="@cost * 0.95" />

           </xsl:attribute>
           <xsl:apply-templates/>
      </xsl:copy> 

</xsl:template>




<!-- Basic identitiy stylesheet - just copies everything -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>