/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Loader {
    private static Logger logger = Logger.getLogger("uk.ac.starlink.util");
    private static boolean propsLoaded = false;
    private static Set warnings = new HashSet();
    private static Boolean is64Bit;
    public static final String PROPERTIES_FILE = ".starjava.properties";

    public static File starjavaDirectory() {
        URL classURL = Loader.class.getResource("Loader.class");
        Matcher matcher = Pattern.compile("^jar:(file:.*?)!.*").matcher(classURL.toString());
        if (matcher.matches()) {
            URI jaruri;
            try {
                jaruri = new URI(matcher.group(1));
            }
            catch (URISyntaxException e) {
                logger.warning("Unexpected URI syntax exception + e");
                return null;
            }
            File jarfile = new File(jaruri);
            if (jarfile.exists()) {
                File sjfile;
                try {
                    sjfile = jarfile.getCanonicalFile().getParentFile().getParentFile().getParentFile();
                }
                catch (IOException e) {
                    return null;
                }
                catch (NullPointerException e) {
                    return null;
                }
                if (sjfile.exists()) {
                    return sjfile;
                }
            }
        } else {
            logger.warning("Loader.class location " + classURL + " unexpected");
        }
        return null;
    }

    public static void loadLibrary(String libname) throws SecurityException, UnsatisfiedLinkError {
        Throwable err1;
        try {
            System.loadLibrary(libname);
            return;
        }
        catch (SecurityException e) {
            err1 = e;
        }
        catch (LinkageError e) {
            err1 = e;
        }
        File libdir = new File(Loader.starjavaDirectory(), "lib");
        String arch = System.getProperty("os.arch");
        File archdir = new File(libdir, arch);
        String filename = System.mapLibraryName(libname);
        File libfile = new File(archdir, filename);
        try {
            System.load(libfile.getCanonicalPath());
        }
        catch (IOException e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("couldn't load library " + libname + ": " + e.getMessage()).initCause(err1);
        }
        catch (LinkageError e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("couldn't load library " + libname + ": " + e.getMessage()).initCause(err1);
        }
    }

    public static File getPropertiesFile() throws SecurityException {
        return new File(System.getProperty("user.home"), PROPERTIES_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadProperties() {
        if (propsLoaded) {
            return;
        }
        FileInputStream pstrm = null;
        File propfile = null;
        try {
            propfile = Loader.getPropertiesFile();
            pstrm = new FileInputStream(propfile);
            Properties starProps = new Properties();
            FileInputStream propIn = new FileInputStream(propfile);
            starProps.load(propIn);
            ((InputStream)propIn).close();
            Properties sysProps = System.getProperties();
            Iterator<Map.Entry<Object, Object>> it = starProps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> starProp = it.next();
                String key = (String)starProp.getKey();
                if (sysProps.containsKey(key)) continue;
                sysProps.put(key, starProp.getValue());
            }
            logger.config("Properties read from " + propfile);
        }
        catch (FileNotFoundException e) {
            logger.config("No properties file " + propfile + " found");
        }
        catch (IOException e) {
            logger.warning("Error reading properties from " + propfile + " " + e);
        }
        catch (SecurityException e) {
            logger.warning("Can't load properties " + e);
        }
        finally {
            if (pstrm != null) {
                try {
                    ((InputStream)pstrm).close();
                }
                catch (IOException e) {}
            }
            propsLoaded = true;
        }
    }

    public static Object getClassInstance(String className, Class type) {
        Class<?> clazz;
        if (className == null || className.trim().length() == 0) {
            return null;
        }
        try {
            new Object().getClass();
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Loader.warn("Class " + className + " not found");
            return null;
        }
        catch (ExceptionInInitializerError e) {
            Loader.warn(e.getCause() + " loading class " + className);
            return null;
        }
        catch (LinkageError e) {
            Loader.warn(e + " loading class " + className);
            return null;
        }
        if (!type.isAssignableFrom(clazz)) {
            Loader.warn("Class " + clazz.getName() + " is not a " + type.getName());
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            Loader.warn(e.getCause() + " loading class " + className);
            return null;
        }
        catch (Throwable th) {
            Loader.warn(th + " instantiating " + clazz.getName());
            return null;
        }
    }

    public static List getClassInstances(String propertyName, Class type) {
        String propVal;
        ArrayList<Object> instances = new ArrayList<Object>();
        try {
            propVal = System.getProperty(propertyName);
        }
        catch (SecurityException e) {
            return instances;
        }
        if (propVal == null || propVal.trim().length() == 0) {
            return instances;
        }
        StringTokenizer stok = new StringTokenizer(propVal, ":");
        while (stok.hasMoreElements()) {
            String cname = stok.nextToken().trim();
            Object inst = Loader.getClassInstance(cname, type);
            if (inst == null) continue;
            instances.add(inst);
        }
        return instances;
    }

    public static List getClassInstances(String[] defaultNames, String propertyName, Class type) {
        Loader.loadProperties();
        ArrayList<Object> instances = new ArrayList<Object>();
        for (int i = 0; i < defaultNames.length; ++i) {
            Object instance = Loader.getClassInstance(defaultNames[i], type);
            if (instance == null) continue;
            instances.add(instance);
        }
        instances.addAll(Loader.getClassInstances(propertyName, type));
        return instances;
    }

    public static boolean is64Bit() {
        if (is64Bit == null) {
            boolean is64;
            Loader.loadProperties();
            try {
                String archdm = System.getProperty("sun.arch.data.model");
                if (archdm != null) {
                    is64 = "64".equals(archdm);
                    logger.config("sun.arch.data.model=" + archdm + ": assuming " + (is64 ? "64" : "32") + "-bit JVM");
                } else {
                    String arch = System.getProperty("os.arch", "unknown");
                    is64 = arch.indexOf("64") >= 0;
                    logger.config("os.arch=" + arch + ": assuming " + (is64 ? "64" : "32") + "-bit JVM");
                }
            }
            catch (SecurityException e) {
                logger.info("Can't determine os.arch (" + e + ") - assume 32-bit");
                is64 = false;
            }
            is64Bit = is64;
        }
        return is64Bit;
    }

    public static void tweakGuiForMac() {
        block5: {
            String menuProp = "apple.laf.useScreenMenuBar";
            try {
                String prop = System.getProperty(menuProp);
                if (prop != null && prop.trim().length() != 0) break block5;
                String version = System.getProperty("java.specification.version");
                try {
                    if (Double.parseDouble(version) >= 1.5) {
                        System.setProperty(menuProp, "true");
                    }
                }
                catch (RuntimeException e) {
                    Loader.warn("Non-numeric java.specification.version=\"" + version + "\"??");
                }
            }
            catch (SecurityException e) {
                Loader.warn("Security manager prevents setting of " + menuProp);
            }
        }
    }

    public static void setHttpAgent(String productTokens) {
        String agentProp = "http.agent";
        try {
            if (System.getProperty("http.agent") == null) {
                System.setProperty("http.agent", productTokens);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void checkJ2se() throws ClassNotFoundException {
        try {
            Class.forName("java.util.LinkedHashMap");
            Class.forName("org.w3c.dom.Node");
            Class.forName("javax.swing.table.DefaultTableModel");
        }
        catch (ClassNotFoundException e) {
            String msg = "\n" + "The runtime Java Runtime Environment (JRE) " + "is missing some compile-time classes.\n" + "The most likely reason is that you are " + "using an incomplete java such as GNU gcj.\n" + "The JVM you are using is " + System.getProperty("java.vm.name", "unknown") + " version " + System.getProperty("java.vm.version", "?") + ".\n" + "The recommended JRE is Sun's J2SE " + "version 1.4 or greater.\n";
            throw new ClassNotFoundException(msg, e);
        }
    }

    public static void checkJ2seVendor() {
        String[] vendorMsgs;
        Level vendorLevel;
        String vendorProp = "java.vendor";
        String vendor = System.getProperty(vendorProp);
        String recommendedDownload = "http://sun.java.com/javase/downloads/";
        if (vendor.matches("[Ss]un\\b.*") || vendor.matches("[Aa]pple\\b.*")) {
            vendorLevel = Level.CONFIG;
            vendorMsgs = new String[]{};
        } else if (vendor.matches(".*Free Software Foundation.*") || vendor.matches(".*\\bFSF\\b.*") || vendor.matches(".*\\bGNU\\b.*")) {
            vendorLevel = Level.WARNING;
            vendorMsgs = new String[]{"You appear to be running GNU/FSF Java", "At time of writing, this is an incomplete implementation", "The application may work incorrectly, or not at all", "You are advised to use Sun's Java implementation instead:", recommendedDownload};
        } else {
            vendorLevel = Level.WARNING;
            vendorMsgs = new String[]{"JRE is not Sun's - may or may not work properly"};
        }
        logger.log(vendorLevel, vendorProp + "=" + vendor);
        for (int i = 0; i < vendorMsgs.length; ++i) {
            logger.log(vendorLevel, vendorMsgs[i]);
        }
    }

    private static void warn(String message) {
        if (!warnings.contains(message)) {
            logger.warning(message);
            warnings.add(message);
        }
    }
}

