/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.components;

import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.container.archive.Range;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.ArchiveCommunicationException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.helpers.InternalCommunicationHelper;
import alma.archive.range.IdentifierRange;
import alma.archive.wrappers.Permissions;
import alma.xmlstore.IdentifierJ;
import alma.xmlstore.IdentifierPackage.NotAvailable;
import alma.xmlstore.IdentifierPackage.NotFound;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class IdentifierImpl
extends ComponentImplBase
implements IdentifierJ {
    private IdentifierManager imanager = null;
    private static Pattern p = DatabaseHelper.basicUidPattern;
    protected String myName;
    private AtomicLong documentid;
    private final long maxDocumentid = Long.MAX_VALUE;
    private Logger my_logger;
    private String globalid;
    private String archiveid;
    private volatile boolean connected = false;

    public static void main(String[] args) throws Exception {
        IdentifierImpl idImpl = new IdentifierImpl();
        for (int i = 0; i < 11; ++i) {
            System.out.println(idImpl.getNextID(Logger.getAnonymousLogger()));
        }
    }

    @Deprecated
    public IdentifierImpl() {
    }

    public IdentifierImpl(Logger logger) throws DatabaseException, NotAvailable {
        this.my_logger = logger;
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connect() throws DatabaseException, NotAvailable {
        if (this.my_logger.isLoggable(Level.FINEST)) {
            this.my_logger.finest("-> connect");
        }
        if (!this.connected) {
            block16: {
                if (this.imanager == null) {
                    this.my_logger.log(Level.INFO, "Connecting to the identifier manager");
                    try {
                        this.imanager = InternalIFFactory.getIdentifierManager((Logger)this.my_logger);
                    }
                    catch (ModuleCriticalException e) {
                        this.my_logger.log(Level.SEVERE, "Could not connect to the Identifer manager");
                        try {
                            InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.my_logger);
                            throw new DatabaseException(e.getCause());
                        }
                        catch (ArchiveCommunicationException e1) {
                            this.my_logger.warning("Can nont connect to Archive subsystem master");
                        }
                    }
                    this.my_logger.log(Level.INFO, "Connected to the identifier manager");
                }
                try {
                    this.archiveid = this.imanager.getArchiveId();
                }
                catch (ModuleCriticalException e) {
                    this.my_logger.log(Level.SEVERE, "Could not connect to the Identifer manager");
                    boolean error = false;
                    try {
                        InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.my_logger);
                    }
                    catch (ArchiveCommunicationException e1) {
                        this.my_logger.warning("Can nont connect to Archive subsystem master");
                    }
                    finally {
                        error = true;
                    }
                    if (!error) break block16;
                    throw new DatabaseException(e.getCause());
                }
            }
            String newUID = this.getIdNamespace();
            this.globalid = IdentifierImpl.extractGlobal(newUID);
            this.documentid = new AtomicLong(1L);
            this.connected = true;
        }
        if (this.my_logger.isLoggable(Level.FINEST)) {
            this.my_logger.finest("-> connect");
        }
    }

    private void close() {
        if (this.imanager != null) {
            try {
                this.imanager.close();
                this.my_logger.log(Level.INFO, "Disconnected from the identifier manager");
            }
            catch (DatabaseException e) {
                this.my_logger.log(Level.INFO, "Unable to disconnect from the identifier manager");
            }
        }
    }

    public String[] getUIDs(short number) throws NotAvailable {
        return this.syncGetUIDs(number);
    }

    public boolean checkUIDsyntax(String identifier) {
        Matcher m = p.matcher(identifier);
        return m.matches();
    }

    private synchronized String[] syncGetUIDs(short number) throws NotAvailable {
        String[] out = new String[number];
        for (int count = 0; count < number; ++count) {
            out[count] = this.getNextIDInternal();
        }
        return out;
    }

    private String getNextIDInternal() throws NotAvailable {
        if (this.my_logger.isLoggable(Level.FINER)) {
            this.my_logger.finer("-> getNextIDInternal");
        }
        long nextID = this.documentid.getAndIncrement();
        String uid = null;
        if (nextID <= Long.MAX_VALUE) {
            uid = IdentifierImpl.generateUID(this.archiveid, this.globalid, nextID);
        } else {
            if (this.my_logger.isLoggable(Level.FINER)) {
                this.my_logger.finer("nextId has exceeded max, rolling over");
            }
            String newUID = this.getIdNamespace();
            this.globalid = IdentifierImpl.extractGlobal(newUID);
            this.documentid.set(1L);
            uid = this.getNextIDInternal();
        }
        if (this.my_logger.isLoggable(Level.FINER)) {
            this.my_logger.finer("<- getNextIDInternal");
        }
        return uid;
    }

    @Deprecated
    public String getNextID(Logger logger) throws DatabaseException, NotAvailable {
        this.my_logger = logger;
        if (!this.connected) {
            this.connect();
        }
        return this.getNextIDInternal();
    }

    public String getNextId() throws NotAvailable {
        return this.getNextIDInternal();
    }

    private static String extractGlobal(String uid) {
        int start = uid.indexOf(47, 7) + 2;
        int end = uid.indexOf(47, start);
        return uid.substring(start, end);
    }

    protected static final String generateUID(String _archiveID, String _rangeID, long _localId) {
        String uid = "uid://" + _archiveID + "/X" + _rangeID + "/X" + Long.toHexString(_localId);
        return uid;
    }

    public String getIdNamespace() throws NotAvailable {
        try {
            if (this.imanager == null) {
                this.my_logger.log(Level.INFO, "Not connected to the identifier manager, connecting");
                this.connect();
            }
            return this.imanager.getIdNamespace().toASCIIString();
        }
        catch (DatabaseException e) {
            throw new NotAvailable(e.getMessage());
        }
        catch (ArchiveException e) {
            throw new NotAvailable(e.getMessage());
        }
        catch (ModuleCriticalException e) {
            try {
                InternalCommunicationHelper.notifyMaster(e, this.m_containerServices, this.myName, this.my_logger);
            }
            catch (ArchiveCommunicationException e1) {
                this.my_logger.warning("Can nont connect to Archive subsystem master");
            }
            throw new NotAvailable(e.getMessage());
        }
    }

    public IdentifierRange getNewRange() throws NotAvailable {
        try {
            return this.imanager.getNewRange();
        }
        catch (ArchiveException e) {
            throw new NotAvailable(e.getLocalizedMessage());
        }
        catch (ModuleCriticalException e) {
            throw new NotAvailable(e.getLocalizedMessage());
        }
    }

    public IdentifierRange getNewRestrictedRange(int number, String user) throws NotAvailable {
        try {
            IdentifierRange r = this.imanager.getNewRange(number);
            Range range = new Range(r);
            URI uri = range.rangeId();
            StringWriter writer = new StringWriter();
            r.setIsLocked(true);
            r.marshal((Writer)writer);
            InternalIF internal = InternalIFFactory.getInternalIF((Logger)this.my_logger);
            SchemaManager smanager = internal.getSchemaManager(user);
            String schemaName = "IdentifierRange";
            URI schemaUri = smanager.getSchemaURI(schemaName);
            internal.store(uri, writer.toString(), schemaUri, schemaName, user, new Permissions(), user, true);
            r.setIsLocked(false);
            return r;
        }
        catch (Throwable thr) {
            throw new NotAvailable(thr.toString());
        }
    }

    public IdentifierRange getExistingRange(String uri, String user) throws NotFound {
        try {
            InternalIF internal = InternalIFFactory.getInternalIF((Logger)this.my_logger);
            URI uid = new URI(uri);
            String rangexml = internal.get(uid, user);
            IdentifierRange range = IdentifierRange.unmarshalIdentifierRange((Reader)new StringReader(rangexml));
            return range;
        }
        catch (DatabaseException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
        catch (ModuleCriticalException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
        catch (ArchiveException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
        catch (ValidationException e) {
            throw new NotFound(e.getLocalizedMessage());
        }
    }

    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        super.initialize(containerServices);
        this.myName = containerServices.getName();
        this.my_logger = this.m_logger;
        try {
            this.connect();
        }
        catch (Exception e) {
            throw new ComponentLifecycleException(e.getMessage());
        }
    }

    public void cleanUp() {
        this.close();
    }
}

