/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.loader;

import alma.acs.component.client.AdvancedComponentClient;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.ContainerServices;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DALHelper;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class Loader {
    private ContainerServices m_services;
    private ORB m_orb;
    private DAL m_dal;
    private Logger m_logger;
    private InternalIF internal;
    private SchemaManager smanager;

    public Loader(ContainerServices services, ORB orb) throws Exception {
        this.m_services = services;
        this.m_orb = orb;
        this.m_logger = services.getLogger();
        this.internal = InternalIFFactory.getInternalIF((Logger)this.m_logger);
        this.smanager = this.internal.getSchemaManager("cdb");
    }

    private void disConnect() throws ModuleCriticalException {
        try {
            this.internal.close();
        }
        catch (DatabaseException e) {
            this.m_logger.severe("ERROR: Could not disconnect from the Archive Internal Interface");
        }
    }

    private void storeCurl(String curl, String xml) {
        try {
            URI uRI = new URI(curl);
        }
        catch (URISyntaxException e) {
            this.m_logger.severe("ERROR: Illegal curl: " + curl);
        }
    }

    public void run() throws Exception {
        this.getDAL();
        this.traverseNodes("");
        this.disConnect();
    }

    private void getDAL() throws UnknownHostException {
        this.m_logger.info("trying to get DAL reference...");
        String dalLoc = System.getProperty("ACS.DAL");
        if (dalLoc == null) {
            System.err.println("Property ACS.DAL not defined. Will try localhost, port 5000...");
            try {
                dalLoc = "corbaloc::" + InetAddress.getLocalHost().getHostName() + ":5000/DAL";
            }
            catch (UnknownHostException e) {
                System.err.println("Failed to build managerloc for localhost.");
                throw e;
            }
        }
        this.m_dal = DALHelper.narrow((Object)this.m_orb.string_to_object(dalLoc));
        this.m_logger.info("got DAL reference.");
    }

    private void traverseNodes(String parentNode) {
        String nodes = this.m_dal.list_nodes(parentNode);
        StringTokenizer tok = new StringTokenizer(nodes, " ");
        while (tok.hasMoreElements()) {
            String node = (String)tok.nextElement();
            if (node.indexOf(".xml") >= 0) continue;
            String nodePath = parentNode + "/" + node;
            this.getDalXml(nodePath);
            this.traverseNodes(nodePath);
        }
    }

    private void getDalXml(String nodePath) {
        this.m_logger.fine("will get DAL info for node: " + nodePath);
        try {
            String xml = this.m_dal.get_DAO(nodePath);
            this.m_logger.info(xml);
            this.storeXml(nodePath, xml);
        }
        catch (Exception e) {
            this.m_logger.fine("failed, hopefully because it was an illegal node.");
        }
        finally {
            this.m_logger.fine("--------------------");
        }
    }

    private void storeXml(String nodePath, String xml) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AdvancedComponentClient compClient = null;
        try {
            String managerLoc = System.getProperty("ACS.manager");
            if (managerLoc == null) {
                System.err.println("Property ACS.manager not defined. Will try localhost...");
                managerLoc = AcsManagerProxy.getLocalManagerCorbaloc();
            }
            compClient = new AdvancedComponentClient(null, managerLoc, "CDBDatabaseLoader");
            System.out.println("componentClient object created.");
            ContainerServices services = compClient.getContainerServices();
            ORB orb = compClient.getAcsCorba().getORB();
            Loader loader = new Loader(services, orb);
            loader.run();
        }
        catch (Exception e) {
            System.err.println("exception in main method of " + Loader.class.getName());
            e.printStackTrace(System.err);
        }
        finally {
            if (compClient != null) {
                try {
                    compClient.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

