/*
 * Decompiled with CFR 0.152.
 */
package alma.ssr.observingmodes;

import alma.ssr.observingmodes.Calibrations;
import alma.ssr.observingmodes.Groups;
import alma.ssr.observingmodes.ObservingScript;
import alma.ssr.observingmodes.Property;
import alma.ssr.observingmodes.types.ModeTypeEnum;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObservingMode
implements Serializable {
    private String _name;
    private ModeTypeEnum _type;
    private String _documentation;
    private boolean _standardMode = true;
    private boolean _has_standardMode;
    private boolean _runQuickLook = true;
    private boolean _has_runQuickLook;
    private Calibrations _calibrations;
    private Groups _groups;
    private ArrayList _propertyList = new ArrayList();
    private ObservingScript _observingScript;

    public void addProperty(Property property) throws IndexOutOfBoundsException {
        this._propertyList.add(property);
    }

    public void addProperty(int n, Property property) throws IndexOutOfBoundsException {
        this._propertyList.add(n, property);
    }

    public void clearProperty() {
        this._propertyList.clear();
    }

    public void deleteRunQuickLook() {
        this._has_runQuickLook = false;
    }

    public void deleteStandardMode() {
        this._has_standardMode = false;
    }

    public Enumeration enumerateProperty() {
        return new IteratorEnumeration(this._propertyList.iterator());
    }

    public Calibrations getCalibrations() {
        return this._calibrations;
    }

    public String getDocumentation() {
        return this._documentation;
    }

    public Groups getGroups() {
        return this._groups;
    }

    public String getName() {
        return this._name;
    }

    public ObservingScript getObservingScript() {
        return this._observingScript;
    }

    public Property getProperty(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._propertyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Property)this._propertyList.get(n);
    }

    public Property[] getProperty() {
        int n = this._propertyList.size();
        Property[] propertyArray = new Property[n];
        for (int i = 0; i < n; ++i) {
            propertyArray[i] = (Property)this._propertyList.get(i);
        }
        return propertyArray;
    }

    public int getPropertyCount() {
        return this._propertyList.size();
    }

    public boolean getRunQuickLook() {
        return this._runQuickLook;
    }

    public boolean getStandardMode() {
        return this._standardMode;
    }

    public ModeTypeEnum getType() {
        return this._type;
    }

    public boolean hasRunQuickLook() {
        return this._has_runQuickLook;
    }

    public boolean hasStandardMode() {
        return this._has_standardMode;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException validationException) {
            return false;
        }
        return true;
    }

    public void marshal(Writer writer) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)writer);
    }

    public void marshal(ContentHandler contentHandler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)contentHandler);
    }

    public boolean removeProperty(Property property) {
        boolean bl = this._propertyList.remove(property);
        return bl;
    }

    public void setCalibrations(Calibrations calibrations) {
        this._calibrations = calibrations;
    }

    public void setDocumentation(String string) {
        this._documentation = string;
    }

    public void setGroups(Groups groups) {
        this._groups = groups;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setObservingScript(ObservingScript observingScript) {
        this._observingScript = observingScript;
    }

    public void setProperty(int n, Property property) throws IndexOutOfBoundsException {
        if (n < 0 || n > this._propertyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._propertyList.set(n, property);
    }

    public void setProperty(Property[] propertyArray) {
        this._propertyList.clear();
        for (int i = 0; i < propertyArray.length; ++i) {
            this._propertyList.add(propertyArray[i]);
        }
    }

    public void setRunQuickLook(boolean bl) {
        this._runQuickLook = bl;
        this._has_runQuickLook = true;
    }

    public void setStandardMode(boolean bl) {
        this._standardMode = bl;
        this._has_standardMode = true;
    }

    public void setType(ModeTypeEnum modeTypeEnum) {
        this._type = modeTypeEnum;
    }

    public static ObservingMode unmarshalObservingMode(Reader reader) throws MarshalException, ValidationException {
        return (ObservingMode)Unmarshaller.unmarshal(ObservingMode.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

