/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.alarmsystem.source;

import alma.acs.alarmsystem.source.AlarmQueue;
import alma.acs.alarmsystem.source.AlarmSender;
import alma.acs.alarmsystem.source.AlarmSource;
import alma.acs.alarmsystem.source.AlarmsMap;
import alma.acs.concurrent.NamedThreadFactory;
import alma.acs.concurrent.ThreadLoopRunner;
import alma.acs.container.ContainerServicesBase;
import alma.acs.logging.AcsLogLevel;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlarmSourceImpl
implements AlarmSource {
    public static final int ALARM_OSCILLATION_TIME = 1;
    private final AlarmSender alarmSender;
    private final ContainerServicesBase containerServices;
    private final AlarmsMap alarms;
    private final AlarmQueue queue = new AlarmQueue();
    private volatile boolean queuing = false;
    private volatile boolean enabled = true;
    private final ThreadLoopRunner oscillationLoop;
    private final ConcurrentHashMap<String, Long> alarmsToClean = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduledExecutor;
    private ScheduledFuture<?> flusherFuture;

    public AlarmSourceImpl(ContainerServicesBase containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("Invalid null ContainerServicesBase");
        }
        this.containerServices = containerServices;
        this.alarms = new AlarmsMap(containerServices.getThreadFactory(), (Logger)containerServices.getLogger());
        this.alarmSender = new AlarmSender(containerServices);
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, containerServices.getThreadFactory());
        this.oscillationLoop = new ThreadLoopRunner((Runnable)((Object)new OscillationTask()), 1L, TimeUnit.SECONDS, containerServices.getThreadFactory(), (Logger)containerServices.getLogger(), "alarm_osci");
    }

    @Override
    public void raiseAlarm(String faultFamily, String faultMember, int faultCode) {
        this.raiseAlarm(faultFamily, faultMember, faultCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raiseAlarm(String faultFamily, String faultMember, int faultCode, Properties properties) {
        if (!this.enabled) {
            return;
        }
        if (this.queuing) {
            AlarmQueue alarmQueue = this.queue;
            synchronized (alarmQueue) {
                this.queue.add(faultFamily, faultMember, faultCode, properties, true);
            }
            return;
        }
        String id = this.buildAlarmID(faultFamily, faultMember, faultCode);
        this.alarmsToClean.remove(id);
        if (!this.alarms.raise(id)) {
            this.alarmSender.sendAlarm(faultFamily, faultMember, faultCode, properties, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAlarm(String faultFamily, String faultMember, int faultCode) {
        if (!this.enabled) {
            return;
        }
        if (this.queuing) {
            AlarmQueue alarmQueue = this.queue;
            synchronized (alarmQueue) {
                this.queue.add(faultFamily, faultMember, faultCode, null, false);
            }
            return;
        }
        String id = this.buildAlarmID(faultFamily, faultMember, faultCode);
        this.alarmsToClean.putIfAbsent(id, System.currentTimeMillis());
    }

    private void internalAlarmClear(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Invalid alarm ID received " + id);
        }
        String[] alarmMembers = id.split(":");
        if (alarmMembers.length != 3) {
            this.containerServices.getLogger().warning("Invalid alarm ID received " + id);
        }
        String faultFamily = alarmMembers[0];
        String faultMember = alarmMembers[1];
        String faultCode = alarmMembers[2];
        if (!this.alarms.clear(id)) {
            this.alarmSender.sendAlarm(faultFamily, faultMember, Integer.parseInt(faultCode), false);
        }
    }

    @Override
    public void setAlarm(String faultFamily, String faultMember, int faultCode, Properties alarmProps, boolean active) {
        if (active) {
            this.raiseAlarm(faultFamily, faultMember, faultCode, alarmProps);
        } else {
            this.clearAlarm(faultFamily, faultMember, faultCode);
        }
    }

    @Override
    public void setAlarm(String faultFamily, String faultMember, int faultCode, boolean active) {
        this.setAlarm(faultFamily, faultMember, faultCode, null, active);
    }

    @Override
    public void terminateAllAlarms() {
        Collection<String> alarmsToTerminate = this.alarms.getActiveAlarms();
        for (String ID : alarmsToTerminate) {
            String[] strs = ID.split(":");
            this.clearAlarm(strs[0], strs[1], Integer.parseInt(strs[2]));
        }
    }

    @Override
    public synchronized void queueAlarms(long delayTime, TimeUnit unit) {
        this.queuing = true;
        if (this.flusherFuture != null && !this.flusherFuture.isDone()) {
            this.flusherFuture.cancel(false);
        }
        this.flusherFuture = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                AlarmSourceImpl.this.flushAlarms();
            }
        }, delayTime, unit);
    }

    @Override
    public void queueAlarms() {
        this.queuing = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flushAlarms() {
        AlarmQueue.AlarmToQueue[] temp;
        this.queuing = false;
        if (this.flusherFuture != null) {
            this.flusherFuture.cancel(false);
        }
        AlarmQueue alarmQueue = this.queue;
        synchronized (alarmQueue) {
            if (this.queue.isEmpty()) {
                return;
            }
            temp = new AlarmQueue.AlarmToQueue[this.queue.size()];
            this.queue.values().toArray(temp);
            this.queue.clear();
        }
        NamedThreadFactory tf = new NamedThreadFactory(this.containerServices.getThreadFactory(), "AlarmQueueFlusher");
        tf.newThread(new QueueFlusherTask(temp)).start();
    }

    @Override
    public void disableAlarms() {
        this.enabled = false;
    }

    @Override
    public void enableAlarms() {
        this.enabled = true;
    }

    private String buildAlarmID(String faultFamily, String faultMember, int faultCode) {
        return faultFamily + ":" + faultMember + ":" + faultCode;
    }

    @Override
    public void start() {
        this.oscillationLoop.setDelayMode(ThreadLoopRunner.ScheduleDelayMode.FIXED_DELAY);
        this.oscillationLoop.runLoop();
        this.alarms.start();
    }

    @Override
    public void tearDown() {
        boolean oscillationLoopShutdownOK;
        this.enabled = false;
        this.scheduledExecutor.shutdown();
        this.flushAlarms();
        for (String key : this.alarmsToClean.keySet()) {
            this.internalAlarmClear(key);
        }
        this.alarmsToClean.clear();
        try {
            oscillationLoopShutdownOK = this.oscillationLoop.shutdown(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            oscillationLoopShutdownOK = false;
        }
        if (!oscillationLoopShutdownOK) {
            this.containerServices.getLogger().log((Level)AcsLogLevel.ERROR, "Error shutting down the oscillation timer task with a 2 s timeout.");
        }
        this.alarmSender.close();
        this.alarms.shutdown();
    }

    private class OscillationTask
    extends ThreadLoopRunner.CancelableRunnable {
        private OscillationTask() {
        }

        public void run() {
            for (String key : AlarmSourceImpl.this.alarmsToClean.keySet()) {
                if (this.shouldTerminate) {
                    return;
                }
                Long timestamp = (Long)AlarmSourceImpl.this.alarmsToClean.get(key);
                if (timestamp == null || System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(1L) <= timestamp) continue;
                AlarmSourceImpl.this.alarmsToClean.remove(key);
                AlarmSourceImpl.this.internalAlarmClear(key);
            }
        }
    }

    private class QueueFlusherTask
    implements Runnable {
        private final AlarmQueue.AlarmToQueue[] alarmsToFlush;

        public QueueFlusherTask(AlarmQueue.AlarmToQueue[] alarmsToFlush) {
            this.alarmsToFlush = alarmsToFlush;
        }

        @Override
        public void run() {
            for (AlarmQueue.AlarmToQueue alarm : this.alarmsToFlush) {
                AlarmSourceImpl.this.setAlarm(alarm.faultFamily, alarm.faultMember, alarm.faultCode, alarm.getProperties(), alarm.active);
            }
        }
    }
}

