/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.exceptions.general.DatabaseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.xdb.XMLType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class APDMQuery {
    static DatabaseConnectionPool ocpds;
    static Connection readConn;
    private static PrintStream writeFile;
    private static DBConfiguration dbConfig;
    static String basicXpath;
    static String namespaces;
    static String obsProjTab;
    static String execblockTab;
    static final List<String> paramsList;
    static final List<String> xPathList;
    private static final Logger m_logger;
    private static SAXBuilder builder;
    static String xmlFile;
    static PrintStream xmlStream;
    static List<String> xmlFileList;

    private APDMQuery() {
    }

    public static void main(String[] args) throws ParseException {
        int sep;
        String parVal;
        int i;
        m_logger.setLevel(Level.OFF);
        boolean detailedOut = false;
        boolean xmlOut = false;
        boolean caseIns = false;
        ArrayList<String> elementSearch = new ArrayList<String>();
        Options options = new Options();
        options.addOption("h", false, "display help");
        options.addOption("e", false, "display examples");
        options.addOption("c", false, "display DB configuration");
        options.addOption("w", true, "write output to file");
        options.addOption("d", false, "detailed output");
        options.addOption("x", false, "write XML files named after UID");
        options.addOption("xf", true, "write XML file with speicified file name");
        options.addOption("i", false, "case-insensitive value matching");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption("h")) {
            APDMQuery.displayHelp();
            return;
        }
        if (cmd.hasOption("e")) {
            APDMQuery.displayExamples();
            return;
        }
        if (cmd.hasOption("x") && cmd.hasOption("xf")) {
            System.out.println("ERROR: Options x and xf must not be used at the same time.");
            return;
        }
        try {
            dbConfig = APDMQuery.readDbConfig();
        }
        catch (DatabaseException e) {
            System.out.println("Problem in reading database configuration file:");
            e.printStackTrace();
            System.out.print("Problem in reading database configuration file.");
            if (dbConfig != null && APDMQuery.dbConfig.fileLocation != null) {
                System.out.println("Check " + APDMQuery.dbConfig.fileLocation);
            } else {
                System.out.println("Check ./dbConfig.properties or $ACSDATA/config/dbConfig.properties.");
            }
            return;
        }
        if (cmd.hasOption("c")) {
            APDMQuery.displayConfig();
            return;
        }
        if (cmd.hasOption("w")) {
            try {
                writeFile = new PrintStream(cmd.getOptionValue("w"));
            }
            catch (FileNotFoundException e) {
                System.out.println("Problem in creating file:");
                e.printStackTrace();
                System.out.println("Problem in creating file " + cmd.getOptionValue("w"));
                return;
            }
        }
        if (cmd.hasOption("x") || cmd.hasOption("xf")) {
            xmlOut = true;
        }
        if (cmd.hasOption("xf")) {
            xmlFile = cmd.getOptionValue("xf");
            xmlFileList.add(xmlFile);
            try {
                xmlStream = new PrintStream(xmlFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("Problem in creating file:");
                e.printStackTrace();
                System.out.println("Problem in creating file " + xmlFile);
                return;
            }
        }
        if (cmd.hasOption('d')) {
            detailedOut = true;
        }
        if (cmd.hasOption('i')) {
            caseIns = true;
        }
        args = cmd.getArgs();
        int argCount = 0;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        HashSet<String> genericSearches = new HashSet<String>();
        String xpath = basicXpath;
        String queryInfo = "Queried for ";
        for (i = argCount; i < args.length; ++i) {
            parVal = args[i];
            sep = parVal.indexOf(61);
            if (sep < 0) {
                genericSearches.add(parVal);
                continue;
            }
            if (!parVal.substring(0, sep).matches("\\w+")) {
                System.out.println("ERROR: parameter name contains special symbols: " + parVal.substring(0, sep));
                return;
            }
            parameterMap.put(parVal.substring(0, sep).toLowerCase(), parVal.substring(sep + 1));
        }
        for (i = argCount; i < args.length; ++i) {
            parVal = args[i];
            sep = parVal.indexOf(61);
            String preCaseInsString = caseIns ? "translate(" : "";
            String postCaseInsString = caseIns ? ",\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\",\"abcdefghijklmnopqrstuvwxyz\")" : "";
            String xpathExpr = null;
            if (sep < 0) {
                if (caseIns) {
                    parVal = parVal.toLowerCase();
                }
                xpathExpr = "[contains(" + preCaseInsString + "." + postCaseInsString + ", \"" + parVal + "\")]";
                queryInfo = queryInfo + parVal + " contained in doc, ";
                if (caseIns) {
                    System.out.println("ERROR: Case-insensitive full-text search not supported in the moment, due to bug in Oracle.");
                    return;
                }
            } else {
                String param = parVal.substring(0, sep).toLowerCase();
                String value = parVal.substring(sep + 1);
                if (caseIns) {
                    value = value.toLowerCase();
                }
                try {
                    xpathExpr = xPathList.get(paramsList.indexOf(param));
                    if (value.charAt(0) == '=') {
                        xpathExpr = "[" + preCaseInsString + xpathExpr + postCaseInsString + " =\"" + value.substring(1) + "\"]";
                        queryInfo = queryInfo + "pre-defined parameter " + param + " with exact content " + value.substring(1) + ", ";
                    } else {
                        xpathExpr = "[" + xpathExpr + "[contains(" + preCaseInsString + "." + postCaseInsString + ", \"" + value + "\")]]";
                        queryInfo = queryInfo + "pre-defined parameter " + param + " containing " + value + ", ";
                    }
                }
                catch (Exception e) {
                    if (value.equals("")) {
                        try {
                            xpathExpr = xPathList.get(paramsList.indexOf(param));
                            xpathExpr = "[" + xpathExpr + "]";
                            queryInfo = queryInfo + "pre-defined parameter " + param + " occurring in doc, ";
                        }
                        catch (Exception e1) {
                            xpathExpr = parVal.substring(0, sep).equals("ObsProject") ? "" : "[.//prj:" + parVal.substring(0, sep) + "]";
                            queryInfo = queryInfo + "XML element " + parVal.substring(0, sep) + " occurring in doc, ";
                            elementSearch.add(parVal.substring(0, sep));
                        }
                    }
                    if (value.charAt(0) == '=') {
                        xpathExpr = "[" + preCaseInsString + ".//prj:" + parVal.substring(0, sep) + postCaseInsString + "=\"" + value.substring(1) + "\"]";
                        queryInfo = queryInfo + "XML element " + parVal.substring(0, sep) + " with exact content " + value.substring(1) + ", ";
                        elementSearch.add(parVal.substring(0, sep));
                    }
                    xpathExpr = "[.//prj:" + parVal.substring(0, sep) + "[contains(" + preCaseInsString + "." + postCaseInsString + ", \"" + value + "\")]]";
                    queryInfo = queryInfo + "XML element " + parVal.substring(0, sep) + " containing " + value + ", ";
                    elementSearch.add(parVal.substring(0, sep));
                }
            }
            xpath = xpath + xpathExpr;
        }
        xpath = xpath.replaceAll("'", "''");
        String sql = "SELECT value(xmlres) xml, archive_uid FROM " + obsProjTab + ", table(xmlsequence(extract(xml, '" + xpath + "','xmlns:prj=\"Alma/ObsPrep/ObsProject\"'))) xmlres WHERE deleted=0 AND hidden=0 AND dirty=0";
        Namespace ns = Namespace.getNamespace((String)"prj", (String)"Alma/ObsPrep/ObsProject");
        try {
            ocpds = new DatabaseConnectionPool(m_logger);
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            e.printStackTrace();
            System.out.println("Problem in creating database connection. Check Oracle system and " + APDMQuery.dbConfig.fileLocation + ".");
            return;
        }
        try {
            readConn = ocpds.getConnection();
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            e.printStackTrace();
            System.out.println("Problem in creating database connection. Check Oracle system and " + APDMQuery.dbConfig.fileLocation + ".");
            return;
        }
        Statement stmt = null;
        try {
            stmt = readConn.createStatement();
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            e.printStackTrace();
            System.out.println("Problem in creating database connection. Check Oracle system and " + APDMQuery.dbConfig.fileLocation + ".");
            try {
                stmt.close();
                ocpds.close(readConn);
            }
            catch (Exception postCaseInsString) {
                // empty catch block
            }
            return;
        }
        ResultSet curs = null;
        try {
            curs = stmt.executeQuery(sql);
        }
        catch (Exception e) {
            System.out.println("Problem in executing database query: ");
            e.printStackTrace();
            System.out.println("Executed query: " + sql);
            System.out.println("Problem in executing database query.");
            try {
                curs.close();
                stmt.close();
                ocpds.close(readConn);
            }
            catch (Exception xpathExpr) {
                // empty catch block
            }
            return;
        }
        int i2 = 0;
        System.out.println();
        try {
            while (curs.next()) {
                Iterator<String> it1;
                Iterator it;
                Document doc = builder.build((Reader)new StringReader(((XMLType)curs.getObject(1)).getStringVal()));
                Element root = doc.getRootElement();
                String projName = root.getChildTextNormalize("projectName", ns);
                String pi = root.getChildTextNormalize("pI", ns);
                String version = root.getChildTextNormalize("version", ns);
                String uid = curs.getString(2);
                List<String> asdms = APDMQuery.getASDMs(uid);
                String projCode = root.getChildTextNormalize("code");
                if (projCode == null) {
                    projCode = "";
                }
                String lineSpecies = (it = root.getDescendants((Filter)new ElementFilter("transitionName"))).hasNext() ? ((Element)it.next()).getText() : "";
                it = root.getDescendants((Filter)new ElementFilter("sourceName"));
                String source = "";
                while (it.hasNext()) {
                    source = source + "  " + ((Element)it.next()).getText();
                }
                it = root.getDescendants((Filter)new ElementFilter("polarisation"));
                String polar = it.hasNext() ? ((Element)it.next()).getText() : "";
                it = root.getDescendants((Filter)new ElementFilter("filename"));
                String projFilename = it.hasNext() ? ((Element)it.next()).getText() : "";
                System.out.println(++i2 + ": Proj: " + projName);
                System.out.println("PI: " + pi);
                System.out.println("version: " + version);
                System.out.println(uid);
                if (asdms.isEmpty()) {
                    System.out.println("ASDMs: None");
                } else {
                    System.out.print("ASDMs:");
                    it1 = asdms.iterator();
                    while (it1.hasNext()) {
                        System.out.print(" " + it1.next());
                    }
                    System.out.println();
                }
                if (detailedOut) {
                    System.out.println("Project Code: " + projCode);
                    System.out.println(lineSpecies);
                    System.out.println("Source:" + source);
                    System.out.println("Polarization: " + polar);
                    System.out.println("Project filename: " + projFilename);
                }
                System.out.println("");
                if (xmlOut) {
                    if (xmlFile == null) {
                        String fn = uid.substring(6).replace('/', ':') + ".xml";
                        try {
                            xmlStream = new PrintStream(fn);
                            xmlFileList.add(fn);
                        }
                        catch (FileNotFoundException e) {
                            System.out.println("Problem in creating file:");
                            System.out.println(e.toString());
                            System.out.println("Problem in creating file " + fn);
                            return;
                        }
                    }
                    xmlStream.println(new XMLOutputter(Format.getPrettyFormat()).outputString(root));
                    if (xmlFile == null) {
                        xmlStream.close();
                    }
                }
                if (writeFile == null) continue;
                writeFile.println(i2 + ": Proj: " + projName);
                writeFile.println("PI: " + pi);
                writeFile.println("version: " + version);
                writeFile.println(uid);
                if (asdms.isEmpty()) {
                    writeFile.println("ASDMs: None");
                } else {
                    writeFile.print("ASDMs:");
                    it1 = asdms.iterator();
                    while (it1.hasNext()) {
                        writeFile.print(" " + it1.next());
                    }
                    writeFile.println();
                }
                writeFile.println("Project Code: " + projCode);
                writeFile.println(lineSpecies);
                writeFile.println("Source:" + source);
                writeFile.println("Polarization: " + polar);
                writeFile.println("Project filename: " + projFilename);
                writeFile.println("");
            }
        }
        catch (SQLException e) {
            System.out.println("Problem in reading database result: ");
            e.printStackTrace();
            System.out.println("Executed query was: " + sql);
            System.out.println("Problem in reading database result.");
            try {
                curs.close();
                stmt.close();
                ocpds.close(readConn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (JDOMException e) {
            System.out.println("Problem in parsing database result: ");
            e.printStackTrace();
            System.out.println("Executed query was: " + sql);
            System.out.println("Problem in parsing database result.");
            try {
                curs.close();
                stmt.close();
                ocpds.close(readConn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        catch (IOException e) {
            System.out.println("Problem in writing to file:");
            e.printStackTrace();
            System.out.println("Problem in writing to file " + cmd.getOptionValue("w"));
            try {
                curs.close();
                stmt.close();
                ocpds.close(readConn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (i2 == 0 && !elementSearch.isEmpty()) {
            xpath = "/prj:ObsProject";
            Iterator it = elementSearch.iterator();
            while (it.hasNext()) {
                xpath = xpath + "[.//prj:" + (String)it.next() + "]";
            }
            sql = "SELECT value(xmlres) xml, archive_uid FROM " + obsProjTab + ", table(xmlsequence(extract(xml, '" + xpath + "','xmlns:prj=\"Alma/ObsPrep/ObsProject\"'))) xmlres WHERE deleted=0 AND hidden=0 AND dirty=0";
            try {
                curs = stmt.executeQuery(sql);
                if (!curs.next()) {
                    System.out.print("ERROR: Search returned 0 results. One of the following XML elements does not appear in ObsProjects (mind case-sensitivity): ");
                    it = elementSearch.iterator();
                    while (it.hasNext()) {
                        System.out.print((String)it.next() + " ");
                    }
                    System.out.println();
                }
            }
            catch (Exception e) {
                System.out.println("Internal problem: " + e.toString());
                e.printStackTrace();
            }
        }
        System.out.println(queryInfo + (caseIns ? "using case-insensitive text search." : "using case-sensitive text search."));
        System.out.println("Found " + i2 + " result(s). ");
        if (writeFile != null) {
            System.out.println("Output written to " + cmd.getOptionValue("w") + ".");
        }
        if (!xmlFileList.isEmpty()) {
            System.out.print("XML output written to: ");
            Iterator<String> it1 = xmlFileList.iterator();
            while (it1.hasNext()) {
                System.out.print(" " + it1.next());
            }
            System.out.println();
        }
        try {
            curs.close();
            stmt.close();
            ocpds.close(readConn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void displayConfig() {
        System.out.println("Database configuration read from " + APDMQuery.dbConfig.fileLocation + ":");
        System.out.println(dbConfig.toString());
    }

    private static List<String> getASDMs(String uid) throws SQLException, JDOMException, IOException {
        ArrayList<String> out = new ArrayList<String>();
        Statement stmt = readConn.createStatement();
        String xpath = "/*:ExecBlockTable[.//*:projectUID/*:EntityRef/attribute::entityId=\"" + uid + "\"]/*:ContainerEntity";
        String sql = "SELECT extractvalue(value(xmlres),'*:ContainerEntity/@entityId') xml FROM " + execblockTab + ", table(xmlsequence(extract(xml, '" + xpath + "','xmlns=\"Alma/XASDM/ExecBlockTable\"'))) xmlres WHERE deleted=0 AND hidden=0 AND dirty=0";
        ResultSet curs = stmt.executeQuery(sql);
        while (curs.next()) {
            out.add((String)curs.getObject(1));
        }
        return out;
    }

    private static DBConfiguration readDbConfig() throws DatabaseException {
        return DBConfiguration.instance(m_logger);
    }

    private static void displayExamples() {
        System.out.println("EXAMPLES for projectQuery");
        System.out.println();
        System.out.println("- Project name:");
        System.out.println("  projectQuery ProjName=Protoplaneta");
        System.out.println("- PI:");
        System.out.println("  projectQuery -i pi=\"g. galilei\"");
        System.out.println("  (Case insensitive, blanks have to be enclosed in \".");
        System.out.println("- Project Code");
        System.out.println("  projectQuery projCode==LW001");
        System.out.println("  (Exact match, not containment)");
        System.out.println("- Continuum/Spectral line:");
        System.out.println("  projectQuery obsType=Cont");
        System.out.println("- Source name:");
        System.out.println("  projectQuery sourceName=L1527 sourceName=L1551");
        System.out.println("  (Both sources must be in project)");
        System.out.println("- Polarization: ");
        System.out.println("  projectQuery pol=4");
        System.out.println("  (Polarization value can be 1,2, or 4)");
        System.out.println("- Line Species:");
        System.out.println("  projectQuery lineSpecies=\"CO(3-2)\"");
        System.out.println("- Rest frequency:");
        System.out.println("  projectQuery restFreq=90");
        System.out.println("  (No intervals allowed yet, unit is GHz)");
        System.out.println("- Generic query:");
        System.out.println("  projectQuery searchterm");
        System.out.println("  (Returns projects that contain \"searchterm\" somewhere)");
        System.out.println("- Other APDM fields:");
        System.out.println("  projectQuery minIntegrationTime==2.0");
        System.out.println("  (minIntegrationTime is name of XML element in project, always case-sensitive!)");
        System.out.println("- File output:");
        System.out.println("  projectQuery -w fileOut.txt ProjName=Protoplaneta");
        System.out.println("  (writes (detailed) project summary to fileOut.txt)");
        System.out.println("  projectQuery -xf fileOut.xml ProjName=Protoplaneta");
        System.out.println("  (writes XML file to fileOut.xml)");
        System.out.println("  projectQuery -x ProjName=Protoplaneta");
        System.out.println("  (writes XML file to file named after UIDs, eg. X1b:Xa44:X1.xml)");
        System.out.println("- Conjunctive queries:");
        System.out.println("  projectQuery ProjName=Protoplaneta pi=galilei");
    }

    private static void displayHelp() {
        System.out.println("projectQuery [-h] [-e] [-c] [-w <filename>] [-d] [-x|-xf <filename>] [-i] <parameter>[=[=]<value>] [<parameter>[=[=]<value>]]");
        System.out.println();
        System.out.println("-h              show help page");
        System.out.println("-e              show examples");
        System.out.println("-c              show configuration (which database is used, with which user)");
        System.out.println("-w              write the summary output to file with name <filename> (works also with -d)");
        System.out.println("-d              detailed output");
        System.out.println("-xf             write ObsProject XML entities to file with name <filename>");
        System.out.println("-x              create one XML file for each matching entity with the UIDs as filenames.");
        System.out.println("-i              ignore case for value searches. (Does not work for full text search, only with parameter=value searches.)");
        System.out.println();
        System.out.println("The command line switches -w, -d, -x, -xf, -i must be specofoed in the above order, if multiple of them are used. -x and -xf cannot be used at the same time.");
        System.out.println();
        System.out.println("<parameter> is either one of the real element names of the ObsProject schema or one of \"projname\", \"pi\", \"projcode\", \"obstype\", \"sourcename\", \"linespecies\",\"pol\", \"restfreq\" where the element names are case sensitive while the aliases in the list are not.");
        System.out.println();
        System.out.println("<value>     if specified should contain a valid ASCII string, if -i is specified as well the search will be case in-sensitive. ");
        System.out.println("            If no value is specified, but still the '=' sign then the program will just check for the existence of the element and return the entities containing the element.");
        System.out.println("            For example ");
        System.out.println("                          projectQuery projName=");
        System.out.println("            will return all projects in the archive.");
        System.out.println("            If two consecutive equal signs ('==') are given between the parameter name and the value the program will search for the value string exactly, with one equal sign ('=') it will execute a containment query, i.e. it will match all entities where the paramter value contains the given string.");
        System.out.println("            *NOTE*: If reserved characters of the unix shell are used in the value string they have to be properly escaped. If the search value contains a space the whole value has to be enclosed in double quotes, like 'parameter=\"My value\"'");
        System.out.println("            If no '=' sign is specified than the string is matched against all elements, i.e. if that string is contained in any element value (not element name) then the entity matches the query. ");
        System.out.println();
        System.out.println("            *NOTE*: There is no space allowed on either side of the '=' sign, i.e. 'parameter=value' works correctly but 'parameter = value' does not.");
        System.out.println();
        System.out.println("If more than one parameter=value pair is given they all have to match, i.e. it is effectively an AND query.");
    }

    static {
        writeFile = null;
        dbConfig = null;
        basicXpath = "/prj:ObsProject";
        namespaces = "xmlns:prj=\"Alma/ObsPrep/ObsProject\"";
        obsProjTab = "xml_obsproject_entities";
        execblockTab = "xml_execblocktable_entities";
        paramsList = Arrays.asList("projname", "pi", "projcode", "obstype", "sourcename", "linespecies", "pol", "restfreq");
        xPathList = Arrays.asList("./prj:projectName", "./prj:pI", "./prj:code", ".//prj:DataProcessingParameters/attribute::projectType", ".//prj:sourceName", ".//prj:transitionName", ".//prj:polarisation", ".//restFrequency");
        m_logger = Logger.getAnonymousLogger();
        builder = new SAXBuilder();
        xmlFile = null;
        xmlStream = null;
        xmlFileList = new ArrayList<String>();
    }
}

