/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.archive.database.oracle.DBConfig;
import alma.archive.database.oracle.DatabaseConnectionPool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Logger;

public final class ApplyTransforms {
    private static final Logger m_logger = Logger.getAnonymousLogger();

    private ApplyTransforms() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            DatabaseConnectionPool ocpds = ApplyTransforms.initConnectionPool();
            if (ocpds != null) {
                ApplyTransforms.listTransforms(ocpds);
            }
        } else if (args[0].equalsIgnoreCase("apply")) {
            DatabaseConnectionPool ocpds = ApplyTransforms.initConnectionPool();
            if (ocpds != null) {
                ApplyTransforms.applyTransforms(ocpds);
            }
        } else {
            ApplyTransforms.printHelp();
        }
    }

    private static DatabaseConnectionPool initConnectionPool() {
        DatabaseConnectionPool ocpds = null;
        try {
            ocpds = new DatabaseConnectionPool(m_logger);
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            System.out.println(e.toString());
            System.out.println("Problem in creating database connection. Check Oracle system and archiveConfig.properties.");
        }
        return ocpds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyTransforms(DatabaseConnectionPool ocpds) {
        Connection conn;
        try {
            conn = ocpds.getConnection();
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            System.out.println(e.toString());
            System.out.println("Problem in creating database connection. Check Oracle system and archiveConfig.properties.");
            return;
        }
        String sql = "SELECT schemaname from xml_stylesheets";
        try {
            Statement stmt = conn.createStatement();
            Statement stmt2 = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int i = 0;
            while (rs.next()) {
                ++i;
                String schemaname = rs.getString(1);
                System.out.println("Applying " + schemaname);
                String sql2 = "update " + DBConfig.schemaTabName(schemaname) + " set xml=xmltransform(xml,(select xml from xml_stylesheets where schemaname='" + schemaname + "'))";
                System.out.println(sql2);
                stmt2.executeUpdate(sql2);
                conn.commit();
            }
            System.out.println("Found " + i + " stylesheets in table xml_stylesheets");
        }
        catch (Exception e) {
            System.out.println("Problem in executing SQL: " + e.toString());
            System.out.println("SQL statement was: " + sql);
            System.out.println("");
        }
        finally {
            try {
                ocpds.close(conn);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listTransforms(DatabaseConnectionPool ocpds) {
        Connection readConn;
        try {
            readConn = ocpds.getConnection();
        }
        catch (Exception e) {
            System.out.println("Problem in creating database connection: ");
            System.out.println(e.toString());
            System.out.println("Problem in creating database connection. Check Oracle system and archiveConfig.properties.");
            return;
        }
        String sql = "SELECT schemaname from xml_stylesheets";
        try {
            Statement stmt = readConn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int i = 0;
            while (rs.next()) {
                ++i;
                System.out.println(rs.getString(1));
            }
            System.out.println("Found " + i + " stylesheets in table xml_stylesheets");
        }
        catch (Exception e) {
            System.out.println("Problem in executing SQL: " + e.toString());
            System.out.println("SQL statement was: " + sql);
            System.out.println("");
        }
        finally {
            try {
                ocpds.close(readConn);
            }
            catch (Exception exception) {}
        }
    }

    public static void printHelp() {
        System.out.println("USAGE: ");
        System.out.println("Without parameter, archiveXSLs will list the stylesheets stored in the database.");
        System.out.println("With parameter apply (archiveXSLs apply), these stylesheets will be applied to the respective documents.");
        System.out.println("In the present stage, this command does NOT deal with multiple versions of stylesheets. Make sure there is only one stylesheet per schema in the database.");
    }
}

