/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.client;

import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import java.util.logging.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XmldbDirectClient {
    private XmldbConnector connector = null;
    private Collection descriptor = null;
    private Collection latest = null;
    private Collection documents = null;
    private static Logger logger = Logger.getAnonymousLogger();

    public XmldbDirectClient(boolean testMode) throws DatabaseException, XMLDBException {
        this.connector = this.connector = XmldbConnector.instance(logger, testMode);
        this.descriptor = this.connector.getDescriptor();
        this.latest = this.connector.getLatest();
        this.documents = this.connector.getDocuments();
    }

    private String printres(Resource res) throws XMLDBException {
        if (res == null) {
            return "null";
        }
        return (String)res.getContent();
    }

    public void list() throws ArchiveException {
        try {
            String xml;
            String out;
            int x;
            String[] res = this.descriptor.listResources();
            for (x = 0; x < res.length; ++x) {
                out = res[x];
                xml = this.printres(this.descriptor.getResource(res[x]));
                out = "Descriptor:  " + out + "     " + xml;
                System.out.println(out);
            }
            res = this.latest.listResources();
            for (x = 0; x < res.length; ++x) {
                out = res[x];
                xml = this.printres(this.latest.getResource(res[x]));
                out = "Latest:   " + out + "     " + xml;
                System.out.println(out);
            }
            res = this.documents.listResources();
            for (x = 0; x < res.length; ++x) {
                out = res[x];
                xml = this.printres(this.documents.getResource(res[x]));
                out = "Documents:   " + out + "     " + xml;
                System.out.println(out);
            }
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    public void scruball() throws DatabaseException {
        this.connector.cleanCollections();
    }

    public void scrubtest() throws DatabaseException {
        this.connector.cleanTestCollections();
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                boolean testMode = true;
                if (args[1].equalsIgnoreCase("all")) {
                    testMode = false;
                }
                XmldbDirectClient client = new XmldbDirectClient(testMode);
                if (args[0].equalsIgnoreCase("view")) {
                    client.list();
                } else if (args[0].equalsIgnoreCase("scrub")) {
                    if (testMode) {
                        client.scrubtest();
                    } else {
                        client.scruball();
                    }
                    System.out.println("Archive Cleaned");
                }
            }
        }
        catch (DatabaseException databaseException) {
        }
        catch (XMLDBException xMLDBException) {
        }
        catch (ArchiveException archiveException) {
            // empty catch block
        }
    }
}

