/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.exceptions.general.DatabaseException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

@Deprecated
public final class ArchiveConfigurationOld
extends DBConfiguration {
    public static String defaultConfigFileName = "dbConfig.properties";
    private Properties props = new Properties();

    protected ArchiveConfigurationOld(Logger logger) throws DatabaseException {
        logger.info("Constructing Archive configuration file as instance of ArchiveConfigurationOld (ie. deprecated implementation).");
        this.reinit(logger);
    }

    @Override
    public void reinit(Logger logger) throws DatabaseException {
        Enumeration<Object> propIt = this.props.keys();
        while (propIt.hasMoreElements()) {
            String key = (String)propIt.nextElement();
            if (!key.startsWith("archive.")) continue;
            System.clearProperty(key);
        }
        try {
            this.readConfig(logger);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problems while reading " + defaultConfigFileName, e);
        }
        this.createConfig(logger);
        logger.info(this.toString());
    }

    private void readConfig(Logger logger) throws IOException {
        this.props = new Properties();
        try {
            FileInputStream propIn = new FileInputStream(defaultConfigFileName);
            logger.info("----------- Loading " + defaultConfigFileName + " from current working directory: " + System.getProperty("user.dir"));
            this.fileLocation = System.getProperty("user.dir") + "/" + defaultConfigFileName;
            this.props = this.readProps(propIn);
            ((InputStream)propIn).close();
            this.storeProps(this.props, logger);
            return;
        }
        catch (FileNotFoundException e) {
            ClassLoader loader;
            URL propsFile;
            logger.info("No properties file " + defaultConfigFileName + " in current working directory.  Now looking in $ACSDATA (defined by Java property ACS.data).");
            String acsdata = System.getProperty("ACS.data");
            if (acsdata != null) {
                acsdata = acsdata + "/config/";
                try {
                    FileInputStream propIn = new FileInputStream(acsdata + defaultConfigFileName);
                    this.fileLocation = acsdata + defaultConfigFileName;
                    logger.info("----------- Loading " + defaultConfigFileName + " from " + acsdata);
                    this.props = this.readProps(propIn);
                    ((InputStream)propIn).close();
                    this.storeProps(this.props, logger);
                    return;
                }
                catch (FileNotFoundException e2) {
                    logger.info("No properties file " + defaultConfigFileName + " " + acsdata + ".  Now looking in classpath.");
                }
            }
            if ((propsFile = (loader = DBConfiguration.class.getClassLoader()).getResource(defaultConfigFileName)) == null) {
                logger.warning("No file " + defaultConfigFileName + " found in classpath.");
            } else {
                logger.info("-------- Loading " + propsFile);
                this.fileLocation = propsFile.toString();
                InputStream propIn = propsFile.openStream();
                this.props = this.readProps(propIn);
                propIn.close();
                this.storeProps(this.props, logger);
            }
            return;
        }
    }

    private void storeProps(Properties props, Logger logger) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (System.getProperty(key) == null) {
                System.setProperty(key, props.getProperty(key));
                logger.finest("Added property: " + key + " = " + props.getProperty(key));
                continue;
            }
            logger.finest("Property " + key + " already defined, ignoring.");
        }
    }

    private Properties readProps(InputStream propIn) throws IOException {
        Properties props = new Properties();
        props.load(propIn);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = props.getProperty(key);
            val = ArchiveConfigurationOld.expand(val);
            if (key.equalsIgnoreCase("archive.ngast.clientParams") && !val.startsWith("ngamsArchiveClient")) {
                val = "ngamsArchiveClient " + val;
            }
            props.setProperty(key, val);
        }
        return props;
    }

    static String expand(String s) {
        int markerPos = s.indexOf("${");
        if (markerPos == -1) {
            return s;
        }
        int markerEnd = s.indexOf("}", markerPos);
        if (markerEnd == -1) {
            return s;
        }
        String preVarName = s.substring(0, markerPos);
        String embeddedVarName = s.substring(markerPos + 2, markerEnd);
        String postVarName = s.substring(markerEnd + 1);
        String embeddedVarValue = System.getProperty(embeddedVarName, "");
        s = preVarName + embeddedVarValue + postVarName;
        return ArchiveConfigurationOld.expand(s);
    }

    private void createConfig(Logger logger) throws DatabaseException {
        this.configParams = new HashMap();
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("archive.")) continue;
            this.configParams.put(key, System.getProperty(key));
        }
        this.dbBackend = this.get("archive.db.backend");
        if (this.dbBackend == null) {
            logger.severe("Property archive.db.backend undefined! Check dbConfig.properties in classpath and working directory.");
            throw new DatabaseException("No Database backend specified (property archive.db.backend undefined).");
        }
        if ("test".equals(this.get("archive.db.mode"))) {
            this.testMode = true;
        }
        if (this.dbBackend.equals("oracle") && this.testMode && this.get("archive.oracle.user").equals("alma")) {
            logger.severe("When running in test mode, user must be almatest. Check dbConfig file.");
            throw new DatabaseException("Permission denied: only user almatest can run in test mode");
        }
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer("Database configuration: ");
        for (String name : this.configParams.keySet()) {
            out.append(name + "=" + (String)this.configParams.get(name) + ",  ");
        }
        return out.toString();
    }

    @Override
    public Element toElement() {
        Element root = new Element("dbconfiguration");
        Iterator iter = this.configParams.keySet().iterator();
        while (iter.hasNext()) {
            Element config = new Element("config");
            String name = (String)iter.next();
            config.setAttribute("name", name);
            config.setAttribute("value", (String)this.configParams.get(name));
            root.addContent((Content)config);
        }
        return root;
    }

    @Override
    public String toXmlString() {
        Element element = this.toElement();
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        String xml = out.outputString(element);
        return xml;
    }

    @Override
    public String get(String paramName) {
        return (String)this.configParams.get(paramName);
    }

    @Override
    public String getConnectionURL(String propertyName) {
        return "";
    }
}

