/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ArchiveResolver
implements URIResolver {
    InternalIF internal = null;
    String user = "";

    public ArchiveResolver(InternalIF internal, String user) {
        this.internal = internal;
        this.user = user;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        URI uri = null;
        try {
            uri = new URI(href);
        }
        catch (URISyntaxException e) {
            throw new TransformerException(e);
        }
        if (uri.getScheme().equalsIgnoreCase("uid")) {
            try {
                String xml = this.internal.get(uri, this.user);
                return new StreamSource(new StringReader(xml));
            }
            catch (ArchiveException e) {
                throw new TransformerException(e);
            }
            catch (ModuleCriticalException e) {
                throw new TransformerException(e.getCause());
            }
        }
        if (uri.getScheme().equalsIgnoreCase("sql")) {
            return null;
        }
        if (uri.getScheme().equalsIgnoreCase("ngast")) {
            return null;
        }
        return null;
    }
}

