/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.helpers;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class Hierarchy {
    private URI start = null;
    private String user = null;
    private InternalIF internal = null;

    public Hierarchy(URI uid, String user) throws ArchiveException, ModuleCriticalException {
        this.start = uid;
        this.user = user;
        this.internal = InternalIFFactory.getInternalIF(Logger.getAnonymousLogger());
    }

    public Reader generate() throws ModuleCriticalException, ArchiveException {
        Element entityGroup = new Element("EntityGroup");
        Element child = this.children(this.start, "");
        entityGroup.addContent((Content)child);
        XMLOutputter out = new XMLOutputter();
        StringReader sr = new StringReader(out.outputString(entityGroup));
        return sr;
    }

    private Element children(URI uid, String entityTypeName) throws ModuleCriticalException, ArchiveException {
        try {
            String xml = this.internal.get(uid, this.user);
            Element entity = new Element("Entity");
            entity.setAttribute("entityId", uid.toASCIIString());
            entity.setAttribute("exist", "True");
            entity.setAttribute("entityTypeName", entityTypeName);
            SAXBuilder builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(true);
            try {
                Document doc = builder.build((Reader)new StringReader(xml));
                Element root = doc.getRootElement();
                String _path = "//*[@entityId]";
                XPath path = XPath.newInstance((String)_path);
                List children = path.selectNodes((Object)root);
                for (Element child : children) {
                    URI childUri = new URI(child.getAttributeValue("entityId"));
                    String childEntityTypeName = child.getAttributeValue("entityTypeName");
                    if (!childUri.equals(uid)) {
                        Element childEntity = this.children(childUri, childEntityTypeName);
                        entity.addContent((Content)childEntity);
                        continue;
                    }
                    entity.setAttribute("entityTypeName", childEntityTypeName);
                }
                return entity;
            }
            catch (JDOMException e) {
                throw new ArchiveException("Problems parsing the document", e);
            }
            catch (IOException e) {
                throw new ArchiveException("Problems parsing the document", e);
            }
            catch (URISyntaxException e) {
                throw new ArchiveException("Problems parsing the document", e);
            }
        }
        catch (EntityDoesNotExistException e) {
            Element empty = new Element("Entity");
            empty.setAttribute("entityId", uid.toASCIIString());
            empty.setAttribute("exist", "False");
            empty.setAttribute("entityTypeName", entityTypeName);
            return empty;
        }
    }
}

