/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.interfaces;

import alma.archive.database.helpers.ArchiveConfiguration;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.oracle.InternalIfImpl;
import alma.archive.database.xmldb.XmldbIdentifierManager;
import alma.archive.database.xmldb.XmldbInternalIF;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class InternalIFFactory {
    public static DBConfiguration dbConfig;

    public static InternalIF getInternalIF(Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> getInternalIF");
        }
        boolean notifyConfig = InternalIFFactory.ensureConfigIsLoaded(logger);
        InternalIF internal = null;
        if (InternalIFFactory.dbConfig.dbBackend.equals("xmldb")) {
            internal = XmldbInternalIF.instance(logger);
        } else if (InternalIFFactory.dbConfig.dbBackend.equals("oracle")) {
            internal = InternalIfImpl.instance(logger);
        }
        if (internal != null) {
            if (notifyConfig) {
                internal.notifyConfigChange();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("<- getIntneralIF");
            }
            return internal;
        }
        logger.severe("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
        throw new DatabaseException("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
    }

    public static InternalIF getInternalIF(DataSource dataSource, Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> getInternalIF(DataSource)");
        }
        InternalIfImpl internal = InternalIfImpl.instance(dataSource, logger);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- getInternalIF");
        }
        return internal;
    }

    public static IdentifierManager getIdentifierManager(DataSource dataSource, Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> getIdentifierManager(DataSource)");
        }
        IdentifierManager imanager = InternalIfImpl.instance(dataSource, logger).getIdentifierManager();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- getIdentifierManager");
        }
        return imanager;
    }

    public static IdentifierManager getIdentifierManager(Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> getIdentifierManager");
        }
        InternalIFFactory.ensureConfigIsLoaded(logger);
        IdentifierManager imanager = null;
        if (InternalIFFactory.dbConfig.dbBackend.equals("xmldb")) {
            imanager = XmldbIdentifierManager.instance(logger);
        } else if (InternalIFFactory.dbConfig.dbBackend.equals("oracle")) {
            imanager = InternalIfImpl.instance(logger).getIdentifierManager();
        }
        if (imanager != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("<- getIdentifierManager");
            }
            return imanager;
        }
        logger.severe("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
        throw new DatabaseException("Unrecognized database " + InternalIFFactory.dbConfig.dbBackend + " specified in config file");
    }

    private static synchronized boolean ensureConfigIsLoaded(Logger logger) throws DatabaseException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> ensureConfigIsLoaded");
        }
        boolean isLoaded = false;
        if (dbConfig == null) {
            dbConfig = ArchiveConfiguration.instance(logger);
            isLoaded = true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- ensureConfigIsLoaded: " + isLoaded);
        }
        return isLoaded;
    }

    public static synchronized SchemaManager getSchemaManager(Logger logger) throws PermissionDeniedException, UserDoesNotExistException, DatabaseException, ModuleCriticalException, ArchiveException {
        return InternalIFFactory.getInternalIF(logger).getSchemaManager("not used anyway, so unimportant");
    }
}

