/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.interfaces;

import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.util.HashMap;
import java.util.List;

public interface SchemaManager {
    public void close() throws DatabaseException;

    public URI getSchemaURI(String var1) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException;

    public void refresh() throws ModuleCriticalException, DatabaseException;

    public URI getSchemaURI(String var1, int var2) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException;

    public String getSchemaName(URI var1) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, MalformedURIException;

    public int getSchemaVersion(URI var1) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, MalformedURIException;

    public HashMap<String, String> getSchemaNamespaces(URI var1) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException;

    public void registerNamespace(String var1, URI var2) throws ModuleCriticalException, NamespaceDefinedException, DatabaseException, ArchiveException, MalformedURIException;

    public void removeNamespace(String var1) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException;

    public void removeAll() throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException;

    public boolean namespaceExists(URI var1) throws ModuleCriticalException, ArchiveException;

    public void assignNamespace(String var1, URI var2) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException;

    public void withdrawNamespace(String var1, URI var2) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException;

    public HashMap<String, String> namespaces() throws ModuleCriticalException, DatabaseException, ArchiveException;

    public List<String> listSchema() throws ModuleCriticalException, DatabaseException, ArchiveException;

    public void addSchema(String var1, String var2, String var3, URI var4, String var5, Permissions var6) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException;

    public void updateSchema(String var1, String var2, String var3, URI var4, URI var5, String var6, Permissions var7) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException;

    public void removeSchema(String var1) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, PermissionDeniedException;
}

