/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.lite;

import alma.archive.database.interfaces.DBCursor;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.cursor.CursorClosedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ResultStruct;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

public class LiteCursor
implements DBCursor {
    private final Map<URI, String> documents;
    private final Iterator<URI> uids;

    public LiteCursor(Map<URI, String> documents) {
        this.documents = documents;
        this.uids = documents.keySet().iterator();
    }

    @Override
    public boolean hasNext() throws DatabaseException, ArchiveException {
        return this.uids.hasNext();
    }

    @Override
    public ResultStruct next() throws CursorClosedException, DatabaseException, ArchiveException {
        URI next = this.uids.next();
        return new ResultStruct(next, this.documents.get(next));
    }

    @Override
    public ResultStruct[] nextBlock(int blockSize) throws CursorClosedException, DatabaseException, ArchiveException {
        return null;
    }

    @Override
    public void close() throws CursorClosedException, DatabaseException, ArchiveException {
    }
}

