/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.lite;

import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.exceptions.general.DatabaseException;
import org.jdom.Element;

public class LiteIdentifierManager
extends IdentifierManager {
    Element ids = new Element("ids");

    public LiteIdentifierManager() {
        this.ids.setAttribute("archvieid", "0");
        this.ids.setAttribute("rangeid", "0");
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void close() throws DatabaseException {
        this.ids = null;
    }

    @Override
    public String getArchiveId() throws DatabaseException {
        String archId = this.ids.getAttributeValue("archiveid");
        try {
            return String.valueOf(Long.parseLong(archId));
        }
        catch (NumberFormatException e) {
            return archId;
        }
    }

    @Override
    protected void setArchiveId(String archiveId) throws DatabaseException {
        this.ids.setAttribute("archiveid", archiveId);
    }

    @Override
    protected long getRangeId() throws DatabaseException {
        return Long.parseLong(this.ids.getAttributeValue("rangeid"));
    }

    @Override
    protected void setRangeId(long rangeId) throws DatabaseException {
        this.ids.setAttribute("rangeid", Long.toString(rangeId));
    }
}

