/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.lite;

import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.interfaces.UserManager;
import alma.archive.database.lite.LiteCursor;
import alma.archive.database.lite.LiteSchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityAlreadyDeletedException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.EntityUndeletedException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.NotImplementedException;
import alma.archive.exceptions.general.UndefinedNamespaceException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.IllegalHistoryNumberException;
import alma.archive.exceptions.syntax.MalformedPermissionsException;
import alma.archive.exceptions.syntax.MalformedQueryException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.syntax.MalformedXPointerException;
import alma.archive.exceptions.syntax.UnderspecifiedQueryException;
import alma.archive.exceptions.syntax.UnknownFlagException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class LiteInternalIF
implements InternalIF {
    private final Map<URI, String> documents = new HashMap<URI, String>();
    private final Map<URI, DocumentData> documentsData = new HashMap<URI, DocumentData>();
    private final Map<URI, String> deletedDocuments = new HashMap<URI, String>();
    private LiteSchemaManager smanager = null;

    @Override
    public void close() throws DatabaseException, ModuleCriticalException {
    }

    @Override
    public void init() throws DatabaseException, ModuleCriticalException {
    }

    @Override
    public String getSchemaOfUid(URI uid) throws DatabaseException, EntityDoesNotExistException, URISyntaxException, ModuleCriticalException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void store(URI uid, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean emitLogs) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, MalformedXMLException, EntityExistsException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException {
        if (this.documents.containsKey(uid)) {
            throw new EntityExistsException();
        }
        this.documents.put(uid, xml);
        DocumentData dd = new DocumentData(new ArchiveTimeStamp(), schema, owner, permissions, false, false, false, false, "");
        this.documentsData.put(uid, dd);
    }

    @Override
    public void store(String uid, String xml, String schemaName, boolean emitLogs) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, MalformedXMLException, EntityExistsException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException {
        try {
            this.store(new URI(uid), xml, this.smanager.getSchemaURI(schemaName), schemaName, "no owner specified", new Permissions(), "no user specified", emitLogs);
        }
        catch (URISyntaxException e) {
            throw new MalformedURIException(e);
        }
    }

    @Override
    public OracleConnection openConnection() throws DatabaseException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void store(URI uid, String xml, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, OracleConnection conn) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void storeAll(URI[] uid, String[] xml, String[] schemaName, String[] owner, Permissions[] permissions, String user, boolean[] newEntity) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void commit(OracleConnection conn) throws DatabaseException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, HistoryInconsistencyException, MalformedXMLException, EntityDoesNotExistException, UserDoesNotExistException, UnknownSchemaException {
        if (!this.documents.containsKey(uid)) {
            throw new EntityDoesNotExistException();
        }
        this.documents.put(uid, xml);
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user, OracleConnection conn) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, HistoryInconsistencyException, MalformedXMLException, EntityDoesNotExistException, UserDoesNotExistException, UnknownSchemaException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public String get(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        if (this.documents.containsKey(uid)) {
            return this.documents.get(uid);
        }
        throw new EntityDoesNotExistException();
    }

    @Override
    public String[] get(URI uid, String xpath, Map<String, String> namespaces, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, UndefinedNamespaceException {
        String[] result = null;
        result = (String[])this.documents.values().toArray(result);
        return null;
    }

    @Override
    public String getDirty(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        if (this.documents.containsKey(uid)) {
            return this.documents.get(uid);
        }
        throw new EntityDoesNotExistException();
    }

    @Override
    public void delete(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        if (!this.documents.containsKey(uid)) {
            throw new EntityDoesNotExistException();
        }
        this.deletedDocuments.put(uid, this.documents.remove(uid));
    }

    @Override
    public void undelete(URI uid, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        if (!this.deletedDocuments.containsKey(uid)) {
            throw new EntityDoesNotExistException();
        }
        this.documents.put(uid, this.deletedDocuments.remove(uid));
    }

    @Override
    public void dirty(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
    }

    @Override
    public void clean(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
    }

    @Override
    public void hidden(URI uid, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
    }

    @Override
    public void visible(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
    }

    @Override
    public void setVirtual(URI uid, String user, boolean virtual) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
    }

    @Override
    public DocumentData status(URI uid, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException {
        if (this.documentsData.containsKey(uid)) {
            return this.documentsData.get(uid);
        }
        throw new EntityDoesNotExistException();
    }

    @Override
    public ArrayList<String[]> querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String PiCoIfilter) throws DatabaseException, NotImplementedException {
        throw new NotImplementedException("querySubmissions() is not implemented for this database type.");
    }

    @Override
    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        throw new DatabaseException("queryRecent() is not implemented for this database type.");
    }

    @Override
    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String XPathQuery, String user) throws DatabaseException {
        throw new DatabaseException("queryInterval() is not implemented for this database type.");
    }

    @Override
    public DBCursor query(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return new LiteCursor(this.filter(query));
    }

    @Override
    public Collection<String> getLog(String timeFrom, String timeTo, int minType, int maxType, String routine, String source, String process, int maxRow) throws ArchiveException {
        throw new ArchiveException("queryLog only supported for Oracle database.");
    }

    @Override
    public DBCursor queryContent(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.query(query, schema, namespaces, dirtyRead, user);
    }

    @Override
    public URI[] queryIDs(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.filter(query).keySet().toArray(new URI[0]);
    }

    @Override
    public URI[] queryIDsAll(String query, String schema, Map<String, String> namespaces, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.filter(query).keySet().toArray(new URI[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<URI, String> filter(String query) throws MalformedQueryException, DatabaseException {
        HashMap<URI, String> results = new HashMap<URI, String>();
        try {
            XPath path = XPath.newInstance((String)query);
            SAXBuilder builder = new SAXBuilder();
            for (URI uri : this.documents.keySet()) {
                String content = this.documents.get(uri);
                try {
                    Document doc = builder.build((Reader)new StringReader(content));
                    Element root = doc.getRootElement();
                    if (path.selectSingleNode((Object)root) == null) continue;
                    results.put(uri, content);
                }
                catch (JDOMException e) {
                    throw new DatabaseException(e);
                }
                catch (IOException e) {
                    throw new DatabaseException(e);
                    return results;
                }
            }
        }
        catch (JDOMException e) {
            throw new MalformedQueryException(e);
        }
    }

    @Override
    public void setFlag(URI uid, String flagName, boolean flagValue, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
    }

    @Override
    public void changeOwner(URI uid, String newOwner, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
    }

    @Override
    public SchemaManager getSchemaManager(String user) throws ModuleCriticalException, ArchiveException, PermissionDeniedException, UserDoesNotExistException {
        if (this.smanager == null) {
            this.smanager = new LiteSchemaManager();
        }
        return this.smanager;
    }

    @Override
    public UserManager getUserManager(String user) throws ModuleCriticalException, ArchiveException, PermissionDeniedException, UserDoesNotExistException {
        return null;
    }

    @Override
    public void remove(URI uid, boolean keepHead, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException {
        if (!keepHead) {
            this.documents.remove(uid);
        }
    }

    @Override
    public void setPermission(URI uid, Permissions permissions, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException {
    }

    @Override
    public void cleanTestArea(String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, UserDoesNotExistException {
        this.documents.clear();
        this.deletedDocuments.clear();
    }

    @Override
    public void notifyConfigChange() throws ModuleCriticalException, DatabaseException {
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public void updateXML(URI uid, String schema, String newChild) throws DatabaseException, EntityDoesNotExistException, MalformedXMLException {
        if (!this.documents.containsKey(uid)) {
            throw new EntityDoesNotExistException(uid.toString());
        }
        String xml = this.documents.get(uid);
        xml = DatabaseHelper.addAsLastChild(xml, newChild);
        this.documents.put(uid, xml);
    }

    @Override
    public void addElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation addElement only supported for Oracle.");
    }

    @Override
    public void updateElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation updateElement only supported for Oracle.");
    }

    @Override
    public void deleteElement(URI uid, String schemaName, String xPath, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation deleteElement only supported for Oracle.");
    }

    @Override
    public void storeLog(String message, int level, String attributeValue, String attributeValue2, String attributeValue3, String attributeValue4, String attributeValue5, String attributeValue6, String attributeValue7, String attributeValue8, String attributeValue9, String attributeValue10, String attributeValue11, String attributeValue12, String attributeValue13, String attributeValue14, String attributeValue15, String[] dataStrings, String xml, boolean commit, String steEnv) {
    }

    @Override
    public String get(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.get(uid, user);
    }

    @Override
    public String[] get(URI uid, String schema, String xpath, Map<String, String> namespaces, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, UndefinedNamespaceException {
        return this.get(uid, xpath, namespaces, user);
    }

    @Override
    public String getDirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.getDirty(uid, user);
    }

    @Override
    public void dirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.dirty(uid, user);
    }

    @Override
    public void clean(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.clean(uid, user);
    }

    @Override
    public void hidden(URI uid, String schema, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.hidden(uid, user);
    }

    @Override
    public void visible(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.visible(uid, user);
    }

    @Override
    public void setFlag(URI uid, String schema, String flagName, boolean flagValue, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
        this.setFlag(uid, flagName, flagValue, user);
    }

    @Override
    public void remove(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException {
        this.remove(uid, false, user);
    }

    @Override
    public void setPermission(URI uid, String schema, Permissions permissions, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException {
        this.setPermission(uid, permissions, user);
    }

    @Override
    public void delete(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        this.delete(uid, user);
    }

    @Override
    public void undelete(URI uid, String schema, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.undelete(uid, user);
    }

    @Override
    public void setVirtual(URI uid, String schema, String user, boolean virtual) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.setVirtual(uid, user, virtual);
    }

    @Override
    public void changeOwner(URI uid, String schema, String newOwner, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.changeOwner(uid, newOwner, user);
    }

    @Override
    public DocumentData status(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException {
        return this.status(uid, user);
    }
}

