/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.lite;

import alma.archive.database.interfaces.SchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;

public class LiteSchemaManager
implements SchemaManager {
    private String _schemas = "archive://schemas";
    private String _namespaces = "archive://namespaces";
    private String _testns = "uid://test";
    private String _schemans = "http://www.w3.org/2001/XMLSchema";
    private String _schemauri = "uid://X0000000000000000/X00000000";
    private String schemaName = "SchemaName";
    private URI schemasUri;
    private URI namespacesUri;
    private URI testns;
    private URI schemans;
    private URI schemauri;
    private HashMap schemas = null;

    public LiteSchemaManager() throws DatabaseException {
        try {
            this.schemasUri = new URI(this._schemas);
            this.namespacesUri = new URI(this._namespaces);
            this.testns = new URI(this._testns);
            this.schemans = new URI(this._schemans);
            this.schemauri = new URI(this._schemauri);
            this.schemas = new HashMap();
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void close() throws DatabaseException {
    }

    @Override
    public URI getSchemaURI(String schemaName) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException {
        return this.schemauri;
    }

    @Override
    public void refresh() throws ModuleCriticalException, DatabaseException {
    }

    @Override
    public URI getSchemaURI(String schema, int version) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException {
        return this.schemauri;
    }

    @Override
    public String getSchemaName(URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, MalformedURIException {
        return (String)this.schemas.get(schemaUri);
    }

    @Override
    public int getSchemaVersion(URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, MalformedURIException {
        return 0;
    }

    public HashMap getSchemaNamespaces(URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException {
        return null;
    }

    @Override
    public void registerNamespace(String prefix, URI namespace) throws ModuleCriticalException, NamespaceDefinedException, DatabaseException, ArchiveException, MalformedURIException {
    }

    @Override
    public void removeNamespace(String prefix) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException {
    }

    @Override
    public void removeAll() throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException {
    }

    @Override
    public boolean namespaceExists(URI namespace) throws ModuleCriticalException, ArchiveException {
        return namespace.equals(this.testns);
    }

    @Override
    public void assignNamespace(String namespaceName, URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException {
    }

    @Override
    public void withdrawNamespace(String name, URI schemaUri) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException {
    }

    public HashMap namespaces() throws ModuleCriticalException, DatabaseException, ArchiveException {
        return null;
    }

    public List listSchema() throws ModuleCriticalException, DatabaseException, ArchiveException {
        return null;
    }

    @Override
    public void addSchema(String schemaName, String xml, String indexConfig, URI schemaURInew, String owner, Permissions permissions) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
        this.schemas.put(schemaURInew, schemaName);
    }

    @Override
    public void updateSchema(String schemaName, String xml, String indexConfig, URI schemaURIold, URI schemaURInew, String owner, Permissions permissions) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
    }

    @Override
    public void removeSchema(String schemaName) throws ModuleCriticalException, DatabaseException, ArchiveException, UnknownSchemaException, PermissionDeniedException {
    }
}

