/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.archive.database.helpers.ArchiveConfiguration;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.exceptions.general.DatabaseException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;

public class DatabaseConnectionPool
implements DataSource {
    private final Logger logger;
    private final DBConfiguration dbConf;
    private DataSource logSource;
    private DataSource source;

    public DatabaseConnectionPool(Logger logger) throws SQLException, DatabaseException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con1");
        }
        System.setProperty("java.security.egd", "file:///dev/urandom");
        this.logger = logger;
        this.dbConf = DBConfiguration.instance(logger);
        this.reinit();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con1");
        }
    }

    public DatabaseConnectionPool(DataSource dataSource, Logger logger) throws SQLException, DatabaseException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con2");
        }
        System.setProperty("java.security.egd", "file:///dev/urandom");
        this.logger = logger;
        this.dbConf = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("using the supplied DataSource, is _not_ being initialised from archiveConfig.properties");
        }
        this.source = dataSource;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("it is not possible to log to the DB using this DataSource");
        }
        this.logSource = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinit() throws SQLException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> reinit");
        }
        DatabaseConnectionPool databaseConnectionPool = this;
        synchronized (databaseConnectionPool) {
            if (this.source != null && !(this.source instanceof OracleDataSource)) {
                this.logger.warning("you passed in a DataSource object. Please don't try to re-intialise the DatabaseConnectionPool class. That attempts to create a new connection pool.");
            } else {
                this.close();
                this.initSource();
                this.initLogSource();
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- reinit");
        }
    }

    @Deprecated
    public Connection getConnection(String callInfo) throws SQLException {
        return this.getConnection(callInfo, true);
    }

    @Deprecated
    public Connection getConnection(String callInfo, boolean emitLogs) throws SQLException {
        Connection conn = this.getConnection();
        if (emitLogs && this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Obtained pool connection" + String.valueOf(conn));
        }
        return conn;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection c = null;
        try {
            c = this.source.getConnection();
        }
        catch (SQLException e) {
            this.logger.warning("the connection obtained from the pool was invalid. Replacing it with a new one.");
            c = this.source.getConnection();
        }
        if (c == null) {
            String[] cacheNames;
            this.logger.severe("no connections were available to be returned");
            this.logger.severe("You can set ConnectionWaitTimeout in archiveConfig.properties to tell the archive to wait N seconds for an available connection");
            OracleConnectionCacheManager occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            for (String nextCache : cacheNames = occm.getCacheNameList()) {
                this.logger.info("cache: " + nextCache + ": active = " + occm.getNumberOfActiveConnections(nextCache) + ", available = " + occm.getNumberOfAvailableConnections(nextCache));
            }
        }
        c.setAutoCommit(false);
        return c;
    }

    public void close(Connection conn) throws SQLException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> closeConnection");
        }
        this.close(conn, true);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- closeConnection");
        }
    }

    public void close(Connection conn, boolean emitLogs) throws SQLException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> closeConnection");
        }
        try {
            conn.commit();
        }
        finally {
            conn.close();
        }
        if (emitLogs) {
            String[] cacheNames;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Return pool connection: " + String.valueOf(conn));
            }
            OracleConnectionCacheManager occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            for (String nextCache : cacheNames = occm.getCacheNameList()) {
                this.logger.finer("cache: " + nextCache + ": active = " + occm.getNumberOfActiveConnections(nextCache) + ", available = " + occm.getNumberOfAvailableConnections(nextCache));
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- closeConnection");
        }
    }

    public Connection getLogConnection() throws DatabaseException, SQLException {
        Connection c = null;
        try {
            if (this.logSource != null) {
                c = this.logSource.getConnection();
            }
        }
        catch (SQLException e) {
            this.logger.warning("the connection obtained from the pool was invalid. Replacing it with a new one.");
            c = this.logSource.getConnection();
        }
        if (c == null) {
            String[] cacheNames;
            this.logger.severe("no connections were available for log-source");
            this.logger.severe("You can set ConnectionWaitTimeout in archiveConfig.properties to tell the archive to wait N seconds for an available connection");
            OracleConnectionCacheManager occm = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            for (String nextCache : cacheNames = occm.getCacheNameList()) {
                this.logger.info("cache: " + nextCache + ": active = " + occm.getNumberOfActiveConnections(nextCache) + ", available = " + occm.getNumberOfAvailableConnections(nextCache));
            }
        }
        return c;
    }

    private synchronized void initSource() throws SQLException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> initSource");
        }
        if (this.source != null) {
            this.logger.warning("attempt to create a new source cache when one already exists. Ignoring.");
            return;
        }
        OracleDataSource oracleDataSource = new OracleDataSource();
        if (this.dbConf instanceof ArchiveConfiguration) {
            String serviceAlias = this.dbConf.get("archive.db.connection");
            oracleDataSource.setURL(serviceAlias);
            oracleDataSource.setLoginTimeout(10);
            this.logger.info("Using connection URL: " + serviceAlias);
            oracleDataSource.setDriverType("thin");
            oracleDataSource.setUser(this.dbConf.get("archive.oracle.user"));
            oracleDataSource.setPassword(this.dbConf.get("archive.oracle.passwd"));
        } else {
            String url = this.dbConf.get("archive.oracle.connectionString");
            if (url == null || url.equals("")) {
                url = "jdbc:oracle:thin:@//" + this.dbConf.get("archive.oracle.location") + "/" + this.dbConf.get("archive.oracle.name");
            }
            this.logger.info("Using this URL for DB connection: " + url);
            oracleDataSource.setUser(this.dbConf.get("archive.oracle.user"));
            oracleDataSource.setPassword(this.dbConf.get("archive.oracle.passwd"));
            oracleDataSource.setURL(url);
        }
        oracleDataSource.setConnectionCachingEnabled(true);
        String cacheName = "cache_source_" + Thread.currentThread().getName() + "_" + String.valueOf(System.currentTimeMillis());
        this.logger.info("creating oracle connection cache: " + cacheName);
        oracleDataSource.setConnectionCacheName(cacheName);
        Properties prop = this.getConnectionPoolParameters();
        oracleDataSource.setConnectionCacheProperties(prop);
        this.source = oracleDataSource;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- initSource");
        }
    }

    private synchronized void initLogSource() throws SQLException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> initLogSource");
        }
        if (this.logSource != null) {
            this.logger.warning("attempt to create a new log source cache when one already exists. Ignoring.");
            return;
        }
        if (this.dbConf instanceof ArchiveConfiguration) {
            OracleDataSource oracleDataSource = new OracleDataSource();
            String serviceAlias = this.dbConf.get("archive.log.connection");
            oracleDataSource.setURL(serviceAlias);
            this.logger.info("Using connection URL for logs: " + serviceAlias);
            oracleDataSource.setDriverType("thin");
            oracleDataSource.setUser(this.dbConf.get("archive.log.user"));
            oracleDataSource.setPassword(this.dbConf.get("archive.log.passwd"));
            oracleDataSource.setConnectionCachingEnabled(true);
            String cacheName = "cache_logsource_" + Thread.currentThread().getName() + "_" + String.valueOf(System.currentTimeMillis());
            this.logger.info("creating oracle connection cache: " + cacheName);
            oracleDataSource.setConnectionCacheName(cacheName);
            Properties prop = this.getLoggingConnectionPoolParameters();
            oracleDataSource.setConnectionCacheProperties(prop);
            this.logger.info("Log connection pool initialized.");
            this.logSource = oracleDataSource;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- initLogSource");
        }
    }

    private synchronized void close() {
        OracleDataSource oracleDataSource;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> close");
        }
        if (this.source != null && this.source instanceof OracleDataSource) {
            oracleDataSource = (OracleDataSource)this.source;
            try {
                this.logger.info("closing the oracle data source");
                oracleDataSource.close();
            }
            catch (SQLException e) {
                this.logger.info("unimportant exception while closing the data source");
            }
            this.source = null;
        }
        if (this.logSource != null && this.logSource instanceof OracleDataSource) {
            oracleDataSource = (OracleDataSource)this.logSource;
            try {
                this.logger.info("closing the oracle log data source");
                oracleDataSource.close();
            }
            catch (SQLException e) {
                this.logger.info("unimportant exception while closing the log data source");
            }
            this.logSource = null;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- close");
        }
    }

    private Properties getConnectionPoolParameters() {
        String prefix = "archive.oracle";
        Properties properties = new Properties();
        this.setProperty(properties, "archive.oracle", "MinLimit", "3");
        this.setProperty(properties, "archive.oracle", "MaxLimit", System.getProperty("archive.connpool.maxsize", "15"));
        this.setProperty(properties, "archive.oracle", "InitialLimit", "3");
        this.setProperty(properties, "archive.oracle", "InactivityTimeout", "180");
        this.setProperty(properties, "archive.oracle", "MaxStatementsLimit", "10");
        this.setProperty(properties, "archive.oracle", "PropertyCheckInterval", "60");
        this.setProperty(properties, "archive.oracle", "ValidateConnection", "True");
        this.setProperty(properties, "archive.oracle", "ConnectionWaitTimeout", "0");
        this.logPoolParameters("archive.oracle", properties);
        return properties;
    }

    private Properties getLoggingConnectionPoolParameters() {
        String prefix = "archive.log";
        Properties properties = new Properties();
        this.setProperty(properties, "archive.log", "MinLimit", "0");
        this.setProperty(properties, "archive.log", "MaxLimit", System.getProperty("archive.logging.connpool.maxsize", "10"));
        this.setProperty(properties, "archive.log", "InitialLimit", "0");
        this.setProperty(properties, "archive.log", "InactivityTimeout", "180");
        this.setProperty(properties, "archive.log", "MaxStatementsLimit", "10");
        this.setProperty(properties, "archive.log", "PropertyCheckInterval", "60");
        this.setProperty(properties, "archive.log", "ValidateConnection", "True");
        this.logPoolParameters("archive.log", properties);
        return properties;
    }

    private void setProperty(Properties properties, String prefix, String propertyName, String defaultValue) {
        String qualifiedName = prefix + "." + propertyName;
        String value = this.dbConf.get(qualifiedName);
        this.logger.info("looking for property " + qualifiedName + ", value: " + String.valueOf(value));
        properties.put(propertyName, value == null ? defaultValue : value);
    }

    private void logPoolParameters(String poolName, Properties properties) {
        for (Object nextKey : properties.keySet()) {
            this.logger.info("connection pool \"" + poolName + "\", " + nextKey.toString() + " = " + properties.get(nextKey));
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }
}

