/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.oracle;

import alma.ArchiveIdentifierError.wrappers.AcsJArchiveIdentifierErrorEx;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.interfaces.UserManager;
import alma.archive.database.oracle.DatabaseCache;
import alma.archive.database.oracle.DatabaseConnectionPool;
import alma.archive.database.oracle.DatabaseReader;
import alma.archive.database.oracle.DatabaseWriter;
import alma.archive.database.oracle.IdentifierArchive;
import alma.archive.database.oracle.SchemaManagerImpl;
import alma.archive.database.oracle.UserManagerImpl;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ArchiveGeneralException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityAlreadyDeletedException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.EntityUndeletedException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.UndefinedNamespaceException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.IllegalHistoryNumberException;
import alma.archive.exceptions.syntax.MalformedPermissionsException;
import alma.archive.exceptions.syntax.MalformedQueryException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.syntax.MalformedXPointerException;
import alma.archive.exceptions.syntax.UnderspecifiedQueryException;
import alma.archive.exceptions.syntax.UnknownFlagException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;

public final class InternalIfImpl
implements InternalIF {
    protected static InternalIfImpl instance;
    private final Logger logger;
    private DBConfiguration config;
    private final DatabaseReader dbReader;
    private final DatabaseWriter dbWriter;
    private final DatabaseCache dbCache;
    private final DatabaseConnectionPool dbConnectionPool;
    private final IdentifierArchive identifierArchive;

    public static synchronized InternalIfImpl instance(Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> instance");
        }
        if (instance == null) {
            instance = new InternalIfImpl(logger);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- instance");
        }
        return instance;
    }

    public static synchronized InternalIfImpl instance(DataSource dataSource, Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> instance(DataSource)");
        }
        if (instance == null) {
            instance = new InternalIfImpl(dataSource, logger);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- instance(DataSource)");
        }
        return instance;
    }

    public InternalIfImpl(DataSource dataSource) throws DatabaseException, ModuleCriticalException {
        this(dataSource, Logger.getLogger("InternalIfImpl"));
    }

    public InternalIfImpl(DataSource dataSource, Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con2");
        }
        try {
            this.logger = logger;
            this.dbCache = new DatabaseCache();
            this.dbConnectionPool = new DatabaseConnectionPool(dataSource, logger);
            this.dbReader = new DatabaseReader(logger, this.dbConnectionPool, this.dbCache);
            this.dbWriter = new DatabaseWriter(logger, this.dbConnectionPool, this.dbReader, this.dbCache);
            this.identifierArchive = IdentifierArchive.instance(logger, this.dbReader, this.dbWriter);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con2");
        }
    }

    private InternalIfImpl(Logger logger) throws DatabaseException, ModuleCriticalException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-> con1");
        }
        this.logger = logger;
        try {
            Class.forName("oracle.xml.parser.v2.XMLParser");
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException("Could not load XMLParser from jar xmlparserv2.jar, is it on the classpath?");
        }
        this.dbCache = new DatabaseCache();
        try {
            this.dbConnectionPool = new DatabaseConnectionPool(logger);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        this.dbReader = new DatabaseReader(logger, this.dbConnectionPool, this.dbCache);
        this.dbWriter = new DatabaseWriter(logger, this.dbConnectionPool, this.dbReader, this.dbCache);
        this.identifierArchive = IdentifierArchive.instance(logger, this.dbReader, this.dbWriter);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("<- con1");
        }
    }

    @Override
    public void init() throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> init");
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- init");
        }
    }

    @Override
    public void close() throws DatabaseException, ModuleCriticalException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("-> close");
        }
        this.identifierArchive.close();
        this.dbWriter.close();
        this.dbReader.close();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("<- close");
        }
    }

    @Override
    public void store(URI uid, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean emitLogs) throws ArchiveException, MalformedURIException, MalformedXMLException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException, DatabaseException, EntityExistsException, ModuleCriticalException, MalformedURIException {
        this.dbWriter.put(uid, new ArchiveTimeStamp(), xml, schema, schemaName, owner, permissions, user, true, emitLogs);
    }

    @Override
    public void store(String uid, String xml, String schemaName, boolean emitLogs) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, MalformedXMLException, EntityExistsException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException {
        try {
            this.store(new URI(uid), xml, this.dbCache.getURI(schemaName), schemaName, "no owner specified", new Permissions(), "no user specified", emitLogs);
        }
        catch (URISyntaxException e) {
            throw new MalformedURIException(e);
        }
    }

    @Override
    public OracleConnection openConnection() throws DatabaseException {
        return this.dbWriter.openConnection();
    }

    @Override
    public void store(URI uid, String xml, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, OracleConnection conn) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException, MalformedURIException {
        this.dbWriter.put(uid, xml, schemaName, owner, permissions, user, newEntity, conn);
    }

    @Override
    public void storeAll(URI[] uid, String[] xml, String[] schemaName, String[] owner, Permissions[] permissions, String user, boolean[] newEntity) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException, MalformedURIException {
        this.dbWriter.putAll(uid, xml, schemaName, owner, permissions, user, newEntity);
    }

    @Override
    public void commit(OracleConnection conn) throws DatabaseException {
        this.dbWriter.commit(conn);
    }

    @Override
    public String getSchemaOfUid(URI uid) throws DatabaseException, EntityDoesNotExistException, URISyntaxException, ModuleCriticalException {
        try {
            return this.dbReader.getSchema(uid);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void storeLog(String message, int level, String timeStamp, String file, String line, String routine, String sourceObject, String host, String process, String context, String thread, String logId, String priority, String uri, String audience, String array, String antenna, String[] dataStrings, String xml, boolean commit, String steEnv) throws DatabaseException {
        this.dbWriter.storeLog(message, level, timeStamp, file, line, routine, sourceObject, host, process, context, thread, logId, priority, uri, audience, array, antenna, dataStrings, xml, commit, steEnv);
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user) throws PermissionDeniedException, ArchiveException, MalformedURIException, MalformedXMLException, UserDoesNotExistException, UnknownSchemaException, HistoryInconsistencyException, EntityDoesNotExistException, DatabaseException, ModuleCriticalException {
        String schemaName = this.URI2schemaString(schema);
        if (!force) {
            this.dbReader.checkTimestampConsistency(uid, schemaName, timeStamp);
        }
        this.dbWriter.put(uid, new ArchiveTimeStamp(), xml, schema, schemaName, null, null, user, false, true);
        if ("ObsProject".equalsIgnoreCase(schemaName)) {
            this.dirty(uid, "OBSPROJECT", user);
        }
    }

    @Override
    public void update(URI uid, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user, OracleConnection conn) throws PermissionDeniedException, ArchiveException, MalformedURIException, MalformedXMLException, UserDoesNotExistException, UnknownSchemaException, HistoryInconsistencyException, EntityDoesNotExistException, DatabaseException, ModuleCriticalException {
        String schemaName = this.URI2schemaString(schema);
        if (!force) {
            this.dbReader.checkTimestampConsistency(uid, schemaName, timeStamp);
        }
        this.dbWriter.put(uid, new ArchiveTimeStamp(), xml, schema, schemaName, null, null, user, false, true, conn);
        if ("ObsProject".equalsIgnoreCase(schemaName)) {
            this.dirty(uid, "OBSPROJECT", user, conn);
        }
    }

    @Override
    public void updateXML(URI uid, String schema, String newChild) throws DatabaseException, EntityDoesNotExistException, ModuleCriticalException {
        this.dbWriter.updateXML(uid, schema, newChild);
        if ("ObsProject".equalsIgnoreCase(schema)) {
            try {
                this.dirty(uid, "OBSPROJECT", "IRRELEVANT");
            }
            catch (ArchiveException e) {
                this.logger.log(Level.SEVERE, "dirty flag update failed: " + e.getMessage());
                throw new DatabaseException("Update XML of " + uid + " failed");
            }
        }
    }

    @Override
    public void addElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        this.dbWriter.addElement(uid, schemaName, xPath, xmlElement, user);
    }

    @Override
    public void updateElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        this.dbWriter.updateElement(uid, schemaName, xPath, xmlElement, user);
        if ("ObsProject".equalsIgnoreCase(schemaName)) {
            try {
                this.dirty(uid, "OBSPROJECT", "IRRELEVANT");
            }
            catch (ArchiveException e) {
                this.logger.log(Level.SEVERE, "dirty flag update failed: " + e.getMessage());
                throw new DatabaseException("Update XML of " + uid + " failed");
            }
        }
    }

    @Override
    public void deleteElement(URI uid, String schemaName, String xPath, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        this.dbWriter.deleteElement(uid, schemaName, xPath, user);
    }

    @Override
    @Deprecated
    public String get(URI uid, String user) throws ArchiveException, UserDoesNotExistException, MalformedURIException, PermissionDeniedException, EntityDirtyException, ArchiveGeneralException, ModuleCriticalException {
        try {
            return this.get(uid, this.dbReader.getSchema(uid), user);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public String get(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.dbReader.get(uid, schema, false, user);
    }

    @Override
    @Deprecated
    public String getDirty(URI uid, String user) throws ArchiveException, UserDoesNotExistException, MalformedURIException, PermissionDeniedException, EntityDirtyException, ArchiveGeneralException, ModuleCriticalException {
        try {
            return this.dbReader.get(uid, this.dbReader.getSchema(uid), true, user);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public String getDirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.dbReader.get(uid, schema, true, user);
    }

    @Override
    @Deprecated
    public String[] get(URI uid, String xpath, Map<String, String> namespaces, String user) throws EntityDirtyException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, PermissionDeniedException, MalformedXMLException, DatabaseException, MalformedQueryException, ArchiveGeneralException, ModuleCriticalException {
        try {
            return this.get(uid, this.dbReader.getSchema(uid), xpath, namespaces, user);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public String[] get(URI uid, String schema, String xpath, Map<String, String> namespaces, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, UndefinedNamespaceException {
        return this.dbReader.queryGet(uid, schema, xpath, namespaces, true, user);
    }

    @Override
    @Deprecated
    public void delete(URI uid, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        try {
            this.delete(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void delete(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        this.dbWriter.un_delete(uid, schema, user, true);
    }

    @Override
    @Deprecated
    public void undelete(URI uid, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        try {
            this.undelete(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void undelete(URI uid, String schema, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.dbWriter.un_delete(uid, schema, user, false);
    }

    @Override
    @Deprecated
    public DocumentData status(URI uid, String user) throws ArchiveException, ModuleCriticalException {
        try {
            return this.status(uid, this.dbReader.getSchema(uid), user);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public DocumentData status(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException {
        return this.dbReader.status(uid, schema, user);
    }

    @Override
    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.dbReader.queryRecent(timestamp, schema, user);
    }

    @Override
    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String XPathQuery, String user) throws ModuleCriticalException, ArchiveException {
        return this.dbReader.queryInterval(timeFrom, timeTo, schema, XPathQuery, user);
    }

    @Override
    public ArrayList<String[]> querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String PiCoIfilter) throws DatabaseException, ModuleCriticalException {
        return this.dbReader.querySubmissions(fieldID, searchString, caseSensitive, containsQuery, PiCoIfilter);
    }

    @Override
    public DBCursor query(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, ArchiveException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException, DatabaseException, MalformedQueryException, ModuleCriticalException {
        return this.dbReader.query(query, schema, namespaces, dirtyRead, user, null, null);
    }

    @Override
    public DBCursor queryContent(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, ArchiveException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException, DatabaseException, MalformedQueryException, ModuleCriticalException {
        return this.dbReader.queryContent(query, schema, namespaces, dirtyRead, user, null, null);
    }

    public DBCursor queryLog(String query, String schema, Map<String, String> namespaces, String user, String timeFrom, String timeTo) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.dbReader.queryContent(query, schema, namespaces, false, user, timeFrom, timeTo);
    }

    @Override
    public Collection<String> getLog(String timeFrom, String timeTo, int minType, int maxType, String routine, String source, String process, int maxRow) throws ArchiveException, ModuleCriticalException {
        return this.dbReader.queryLog(timeFrom, timeTo, minType, maxType, routine, source, process, maxRow);
    }

    @Override
    public URI[] queryIDs(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws ArchiveException, ModuleCriticalException {
        return this.dbReader.queryIDs(query, schema, namespaces, dirtyRead, false, user);
    }

    @Override
    @Deprecated
    public void setFlag(URI uid, String flagName, boolean flagValue, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
        try {
            this.setFlag(uid, this.dbReader.getSchema(uid), flagName, flagValue, user);
        }
        catch (ModuleCriticalException e) {
            throw new ArchiveException(e);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void setFlag(URI uid, String schema, String flagName, boolean flagValue, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
        this.dbWriter.setFlag(uid, schema, flagName, flagValue, user);
    }

    @Override
    public SchemaManager getSchemaManager(String user) throws ArchiveException, PermissionDeniedException, UserDoesNotExistException, DatabaseException, ModuleCriticalException {
        return new SchemaManagerImpl(this.dbWriter, this.dbReader, this.dbCache);
    }

    @Override
    public UserManager getUserManager(String user) throws ArchiveException, PermissionDeniedException, UserDoesNotExistException {
        return new UserManagerImpl(user, this.dbWriter);
    }

    @Override
    @Deprecated
    public void remove(URI uid, boolean keepHead, String user) throws ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        try {
            this.remove(uid, this.dbReader.getSchema(uid), user);
        }
        catch (SQLException e) {
            throw new ArchiveException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void remove(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException {
        this.dbWriter.remove(uid, schema, user);
    }

    @Override
    @Deprecated
    public void setPermission(URI uid, Permissions permissions, String user) throws ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException, EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        try {
            this.setPermission(uid, this.dbReader.getSchema(uid), permissions, user);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void setPermission(URI uid, String schema, Permissions permissions, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException {
        this.dbWriter.setPermission(uid, schema, permissions, user);
    }

    @Override
    public void notifyConfigChange() throws DatabaseException, ModuleCriticalException {
        this.config = InternalIFFactory.dbConfig;
        this.logger.info(this.config.toString());
    }

    @Override
    @Deprecated
    public void changeOwner(URI uid, String newOwner, String user) throws ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        try {
            this.changeOwner(uid, this.dbReader.getSchema(uid), newOwner, user);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void changeOwner(URI uid, String schema, String newOwner, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.dbWriter.changeOwner(uid, schema, newOwner, user);
    }

    @Override
    public void cleanTestArea(String user) throws PermissionDeniedException, DatabaseException, ArchiveException, UserDoesNotExistException, AcsJArchiveIdentifierErrorEx, ModuleCriticalException {
        this.dbWriter.cleanTestArea();
    }

    @Override
    @Deprecated
    public void dirty(URI uid, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        try {
            this.dirty(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void dirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.dbWriter.setFlag(uid, schema, "dirty", true, user);
    }

    @Override
    @Deprecated
    public void clean(URI uid, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        try {
            this.clean(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void clean(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.dbWriter.setFlag(uid, schema, "dirty", false, user);
    }

    @Override
    @Deprecated
    public void hidden(URI uid, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        try {
            this.hidden(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void hidden(URI uid, String schema, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.dbWriter.setFlag(uid, schema, "hidden", true, user);
    }

    @Override
    @Deprecated
    public void visible(URI uid, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        try {
            this.visible(uid, this.dbReader.getSchema(uid), user);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new ArchiveException(e);
        }
    }

    @Override
    public void visible(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.dbWriter.setFlag(uid, schema, "hidden", false, user);
    }

    @Override
    public URI[] queryIDsAll(String query, String schema, Map<String, String> namespaces, String user) throws ArchiveException, ModuleCriticalException {
        return this.dbReader.queryIDs(query, schema, namespaces, true, true, user);
    }

    @Override
    @Deprecated
    public void setVirtual(URI uid, String user, boolean virtual) throws ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        try {
            this.setVirtual(uid, this.dbReader.getSchema(uid), user, virtual);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setVirtual(URI uid, String schema, String user, boolean virtual) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.dbWriter.setVirtual(uid, schema, user, virtual);
    }

    @Override
    public boolean ping() {
        boolean success = false;
        try {
            success = this.dbReader.ping();
        }
        catch (Exception e) {
            this.logger.warning(DatabaseHelper.traceToString(e));
        }
        return success;
    }

    public IdentifierManager getIdentifierManager() {
        return this.identifierArchive;
    }

    private String URI2schemaString(URI schema) throws UnknownSchemaException, DatabaseException, ModuleCriticalException {
        return this.dbReader.getSchemaName(schema);
    }

    public DatabaseReader getReader() {
        return this.dbReader;
    }

    public DatabaseWriter getWriter() {
        return this.dbWriter;
    }

    public DatabaseCache getCache() {
        return this.dbCache;
    }

    public DatabaseConnectionPool getConnectionPool() {
        return this.dbConnectionPool;
    }

    public IdentifierArchive getIdentifierArchive() {
        return this.identifierArchive;
    }

    private void dirty(URI uid, String schema, String user, OracleConnection conn) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.dbWriter.setFlag(uid, schema, "dirty", true, user, (Connection)conn);
    }
}

