/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.vdoc;

import alma.archive.database.interfaces.InternalIF;
import alma.archive.exceptions.general.VDocException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;

public abstract class Definition {
    protected static Logger logger = null;
    private URI contextid = null;

    public static Definition instance(Element definition) throws VDocException {
        Definition _instance;
        String type = definition.getAttributeValue("type");
        String contextid = definition.getAttributeValue("contextid");
        try {
            _instance = Definition.instance(type, new URI(contextid));
        }
        catch (URISyntaxException e) {
            throw new VDocException(e);
        }
        List parameters = definition.getChildren("param");
        for (Element parameter : parameters) {
            String paramName = parameter.getAttributeValue("name");
            String paramValue = parameter.getAttributeValue("val");
            _instance.setParameter(paramName, paramValue);
        }
        return _instance;
    }

    public static Definition instance(String type, URI contextid) throws VDocException {
        String className = "alma.archive.database.vdoc." + type + "Definition";
        try {
            Definition _instance = (Definition)Class.forName(className).newInstance();
            _instance.setLogger();
            _instance.setContextid(contextid);
            return _instance;
        }
        catch (ClassNotFoundException e) {
            throw new VDocException("Unable to find the required class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new VDocException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new VDocException(e.getMessage());
        }
    }

    public static boolean isAvailable(String type) {
        try {
            String className = "alma.archive.database.vdoc." + type + "Definition";
            Class<?> clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public void setLogger() {
        if (logger == null) {
            logger = Logger.getAnonymousLogger();
        }
    }

    public void setLogger(Logger logr) {
        logger = logr;
    }

    private static Iterator listClasses(ClassLoader cl) throws VDocException {
        try {
            Class<?> cl_class;
            for (cl_class = cl.getClass(); cl_class != ClassLoader.class; cl_class = cl_class.getSuperclass()) {
            }
            Field classes_field = cl_class.getDeclaredField("classes");
            classes_field.setAccessible(true);
            Vector classes = (Vector)classes_field.get(cl);
            return classes.iterator();
        }
        catch (SecurityException e) {
            throw new VDocException(e);
        }
        catch (NoSuchFieldException e) {
            throw new VDocException(e);
        }
        catch (IllegalArgumentException e) {
            throw new VDocException(e);
        }
        catch (IllegalAccessException e) {
            throw new VDocException(e);
        }
    }

    private static ArrayList locateChildren(String parentClass, String packageName) throws VDocException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Iterator iter = Definition.listClasses(cl);
        ArrayList<String> results = new ArrayList<String>();
        while (iter.hasNext()) {
            Class cls = (Class)iter.next();
            Class sclass = cls.getSuperclass();
            if (sclass == null || !sclass.getName().equalsIgnoreCase(packageName + "." + parentClass)) continue;
            results.add(cls.getName());
        }
        return results;
    }

    private String getName() {
        String name = this.getClass().getName();
        int lastdot = name.lastIndexOf(".");
        name = name.substring(lastdot + 1);
        name = name.replaceAll("Definition", "");
        return name;
    }

    public Element getElement() throws VDocException {
        Element definition = new Element("definition");
        definition.setAttribute("type", this.getName());
        definition.setAttribute("contextid", this.contextid.toASCIIString());
        Field[] fields = this.getClass().getDeclaredFields();
        for (int x = 0; x < fields.length; ++x) {
            Field field = fields[x];
            String name = field.getName();
            if (name.indexOf("param") == -1) continue;
            try {
                Element parameter = new Element("parameter");
                name = name.replaceAll("param", "");
                parameter.setAttribute("name", name);
                parameter.setAttribute("type", field.getType().getName());
                parameter.setAttribute("val", field.get(this).toString());
                definition.addContent((Content)parameter);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new VDocException(e);
            }
        }
        return definition;
    }

    public void setParameter(String paramName, String paramValue) throws VDocException {
        block9: {
            Class<?> sourceDef = this.getClass();
            try {
                Field param = sourceDef.getField("param" + paramName);
                String type = param.getType().getName();
                if (type.equalsIgnoreCase("int")) {
                    param.setInt(this, Integer.parseInt(paramValue));
                    break block9;
                }
                if (type.equalsIgnoreCase("double")) {
                    param.setDouble(this, Double.parseDouble(paramValue));
                    break block9;
                }
                if (type.equalsIgnoreCase("long")) {
                    param.setLong(this, Long.parseLong(paramValue));
                    break block9;
                }
                if (type.equalsIgnoreCase("boolean")) {
                    param.setBoolean(this, Boolean.valueOf(paramValue));
                    break block9;
                }
                if (type.equalsIgnoreCase("java.lang.String")) {
                    param.set(this, paramValue);
                    break block9;
                }
                throw new VDocException(type + " Is not a supported type");
            }
            catch (SecurityException e) {
                throw new VDocException(e);
            }
            catch (NoSuchFieldException e) {
                throw new VDocException(e);
            }
            catch (IllegalAccessException e) {
                throw new VDocException(e);
            }
        }
    }

    public void setContextid(URI contextid) {
        this.contextid = contextid;
    }

    public URI getContextid() {
        return this.contextid;
    }

    public abstract Element createList(InternalIF var1) throws VDocException;
}

