/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.vdoc;

import alma.archive.database.helpers.ArchiveResolver;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.vdoc.Definition;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.VDocException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public final class VDoc {
    private URI contextid = null;
    private String description = "";
    private ArrayList dList = null;

    public VDoc(URI contextid) {
        this.contextid = contextid;
        this.dList = new ArrayList();
    }

    public VDoc(String xml) throws VDocException {
        this.dList = new ArrayList();
        this.construct(this.xmlToElement(xml));
    }

    public VDoc(Element element) throws VDocException {
        this.dList = new ArrayList();
        this.construct(element);
    }

    private void construct(Element element) throws VDocException {
        try {
            this.contextid = new URI(element.getAttributeValue("contextid"));
            Element description_e = element.getChild("description");
            this.description = description_e.getText();
            List definitionList = element.getChildren("definition");
            for (Element definition : definitionList) {
                Definition def = Definition.instance(definition);
                this.addDefinition(def);
            }
        }
        catch (URISyntaxException e) {
            throw new VDocException(e);
        }
    }

    private Element xmlToElement(String xml) throws VDocException {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            Document doc = builder.build((Reader)new StringReader(xml));
            return doc.getRootElement();
        }
        catch (JDOMException e) {
            throw new VDocException(e);
        }
        catch (IOException e) {
            throw new VDocException(e);
        }
    }

    public URI getContextid() {
        return this.contextid;
    }

    public void setContextid(URI contextid) {
        this.contextid = contextid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addDefinition(Definition definition) {
        this.dList.add(definition);
    }

    public Definition getDefinition(int location) {
        return (Definition)this.dList.get(location);
    }

    public void insertDefinition(Definition definition, int location) {
        this.dList.add(location, definition);
    }

    public void removeDefinition(int location) {
        this.dList.remove(location);
    }

    public void moveDefinition(int from, int too) {
        Definition def = (Definition)this.dList.remove(from);
        this.dList.add(too, def);
    }

    public Element getElement() throws VDocException {
        Element vdoc = new Element("vdoc");
        vdoc.setAttribute("contextid", this.contextid.toASCIIString());
        Element desc = new Element("description");
        desc.addContent(this.description);
        vdoc.addContent((Content)desc);
        for (Definition def : this.dList) {
            vdoc.addContent((Content)def.getElement());
        }
        return vdoc;
    }

    public String getXml() throws VDocException {
        Element vdoc = this.getElement();
        XMLOutputter out = new XMLOutputter(Format.getRawFormat());
        return out.outputString(vdoc);
    }

    private Element transform(InternalIF internal, String user, TransformerFactory factory, URI context, Source source) throws VDocException, ModuleCriticalException {
        try {
            String defContext = internal.get(context, user);
            Templates template = factory.newTemplates(new StreamSource(new StringReader(defContext)));
            JDOMResult result = new JDOMResult();
            Transformer transformer = template.newTransformer();
            transformer.setURIResolver(new ArchiveResolver(internal, user));
            transformer.transform(source, (Result)result);
            Document doc = result.getDocument();
            return doc.detachRootElement();
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new VDocException(e);
        }
        catch (TransformerException e) {
            throw new VDocException(e);
        }
    }

    public String process(InternalIF internal, String user) throws ModuleCriticalException, VDocException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory factory = TransformerFactory.newInstance();
        Element vdocElement = new Element("vdoc");
        for (Definition def : this.dList) {
            URI defContextid = def.getContextid();
            Element urilist = def.createList(internal);
            JDOMSource source = new JDOMSource(urilist);
            Element root = this.transform(internal, user, factory, defContextid, (Source)source);
            vdocElement.addContent((Content)root);
        }
        JDOMSource source = new JDOMSource(vdocElement);
        Element finalresult = this.transform(internal, user, factory, this.contextid, (Source)source);
        XMLOutputter out = new XMLOutputter(Format.getRawFormat());
        return out.outputString(finalresult);
    }
}

