/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.vdoc;

import alma.acs.container.archive.Range;
import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.vdoc.Definition;
import alma.archive.database.vdoc.VDoc;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.VDocException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public final class VDocManager {
    private static VDocManager _instance = null;
    private static int access_count = 0;
    private static final String _vdocmanager = "archive://vdocmanager";
    private URI vdocmanager = null;
    private InternalIF internal = null;
    private IdentifierManager identifier = null;
    private Logger logger = null;
    private Element definitions = null;
    private Element vdocContexts = null;
    private Element definitionContexts = null;
    private Element vdocs = null;
    private Element root = null;
    private Range range;

    public static VDocManager instance(InternalIF internal, IdentifierManager identifier, Logger logger) throws VDocException {
        if (_instance == null) {
            _instance = new VDocManager(internal, identifier, logger);
        }
        ++access_count;
        return _instance;
    }

    public void close() throws DatabaseException, ModuleCriticalException {
        if (--access_count == 0) {
            this.identifier.close();
            _instance = null;
        }
    }

    private VDocManager(InternalIF internal, IdentifierManager identifier, Logger logger) throws VDocException {
        this.internal = internal;
        this.identifier = identifier;
        this.logger = logger;
        try {
            this.range = new Range(identifier.getNewRange());
        }
        catch (Exception e) {
            throw new VDocException(e);
        }
        try {
            this.vdocmanager = new URI(_vdocmanager);
        }
        catch (URISyntaxException e) {
            throw new VDocException(e);
        }
        try {
            String xml = internal.get(this.vdocmanager, "VDocManager");
            this.root = this.createElement(xml);
            this.definitions = this.root.getChild("definitions");
            this.vdocContexts = this.root.getChild("vdocContexts");
            this.definitionContexts = this.root.getChild("definitionContexts");
            this.vdocs = this.root.getChild("vdocs");
        }
        catch (EntityDoesNotExistException e) {
            this.root = new Element("vdocmanager");
            this.definitions = new Element("definitions");
            this.vdocContexts = new Element("vdocContexts");
            this.definitionContexts = new Element("definitionContexts");
            this.vdocs = new Element("vdocs");
            this.root.addContent((Content)this.definitions);
            this.root.addContent((Content)this.vdocContexts);
            this.root.addContent((Content)this.definitionContexts);
            this.root.addContent((Content)this.vdocs);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
    }

    private Element createElement(String xml) throws VDocException {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            Document vdocdoc = builder.build((Reader)new StringReader(xml));
            Element root = vdocdoc.getRootElement();
            return root;
        }
        catch (JDOMException e) {
            throw new VDocException(e);
        }
        catch (IOException e) {
            throw new VDocException(e);
        }
    }

    private void save() {
    }

    public String toString() {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(this.root);
    }

    private URI getId() throws VDocException {
        try {
            return this.range.next();
        }
        catch (Exception e) {
            throw new VDocException(e);
        }
    }

    public void registerVDoc(URI uri, String user) throws VDocException {
        try {
            this.internal.setVirtual(uri, user, true);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public void unregisterVDoc(URI uri, String user) throws VDocException {
        try {
            this.internal.setVirtual(uri, user, false);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    private URI addContext(String name, String description, String xml, String user, String owner, Element parent, String type, URI contextSchema) throws VDocException {
        try {
            URI uid = this.getId();
            SchemaManager smanager = this.internal.getSchemaManager(user);
            String schemaName = smanager.getSchemaName(contextSchema);
            this.internal.store(uid, xml, contextSchema, schemaName, owner, new Permissions(), user, true);
            Element context = new Element(type);
            context.setAttribute("name", name);
            context.setAttribute("uri", uid.toASCIIString());
            context.setAttribute("user", user);
            context.setAttribute("owner", owner);
            context.setText(description);
            parent.addContent((Content)context);
            this.save();
            return uid;
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public URI addVDocContext(String name, String description, String xml, String user, String owner, URI contextSchema) throws VDocException {
        try {
            URI uri = this.addContext(name, description, xml, user, owner, this.vdocContexts, "vdocContext", contextSchema);
            this.logger.finest("Added vdocContext at: " + uri.toASCIIString());
            return uri;
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public void updateVDocContext(URI uri, String xml, String user) throws VDocException {
        try {
            DocumentData dd = this.internal.status(uri, user);
            ArchiveTimeStamp timeStamp = dd.getTimestamp();
            URI contextSchema = dd.getSchema();
            this.logger.finest("Updated  vdocContext at: " + uri.toASCIIString());
            this.internal.update(uri, timeStamp, xml, contextSchema, true, user);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public Element getVDocContexts() {
        return this.vdocContexts;
    }

    public URI addDefinitionContext(String name, String description, String xml, String user, String owner, URI contextSchema) throws VDocException {
        try {
            URI uri = this.addContext(name, description, xml, user, owner, this.definitionContexts, "definitionContext", contextSchema);
            this.logger.finest("Added definitionContext at: " + uri.toASCIIString());
            return uri;
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public void updateDefinitionsContext(URI uri, String xml, String user) throws VDocException {
        try {
            DocumentData dd = this.internal.status(uri, user);
            ArchiveTimeStamp timeStamp = dd.getTimestamp();
            URI contextSchema = dd.getSchema();
            this.logger.finest("Updated definitionContext at: " + uri.toASCIIString());
            this.internal.update(uri, timeStamp, xml, contextSchema, true, user);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public Element getDefinitionContexts() {
        return this.definitionContexts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerDefinitionType(String type) throws VDocException {
        if (Definition.isAvailable(type)) {
            try {
                String _path = "definitionType[.=\"" + type + "\"]";
                XPath path = XPath.newInstance((String)_path);
                if (path.selectSingleNode((Object)this.definitions) != null) return;
                Element definitionType = new Element("definitionType");
                definitionType.setText(type);
                this.definitions.addContent((Content)definitionType);
                this.save();
                return;
            }
            catch (JDOMException e) {
                throw new VDocException(e);
            }
        } else {
            String className = "alma.archive.database.vdoc." + type + "Definition";
            throw new VDocException("The class: " + className + "cannot be found");
        }
    }

    public void unregisterDefinitionType(String type) throws VDocException {
        try {
            String _path = "definitionType[.=\"" + type + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element definitionType = (Element)path.selectSingleNode((Object)this.definitions);
            if (definitionType != null) {
                definitionType.detach();
                this.save();
            }
        }
        catch (JDOMException e) {
            throw new VDocException(e);
        }
    }

    public Element getDefinitions() {
        return this.definitions;
    }

    public URI createVDoc(URI contextId, String user, String owner, URI vdocSchema) throws VDocException {
        try {
            VDoc vdoc = new VDoc(contextId);
            URI id = this.getId();
            SchemaManager smanager = this.internal.getSchemaManager(user);
            String schemaName = smanager.getSchemaName(vdocSchema);
            smanager.close();
            this.internal.store(id, vdoc.getXml(), vdocSchema, schemaName, owner, new Permissions(), user, true);
            Element desc = new Element("vdocDesc");
            desc.setAttribute("location", id.toASCIIString());
            this.vdocs.addContent((Content)desc);
            this.save();
            return id;
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public Element getVDocLocations() {
        return this.vdocs;
    }

    public VDoc getVDoc(URI uri, String user) throws VDocException {
        try {
            String xml = this.internal.get(uri, user);
            return new VDoc(xml);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }

    public void updateVDoc(URI uri, VDoc vdoc, String user) throws VDocException {
        try {
            DocumentData dd = this.internal.status(uri, user);
            URI vdocSchema = dd.getSchema();
            ArchiveTimeStamp timeStamp = dd.getTimestamp();
            this.logger.finest("Updated  VDoc at: " + uri.toASCIIString());
            this.internal.update(uri, timeStamp, vdoc.getXml(), vdocSchema, true, user);
        }
        catch (ModuleCriticalException e) {
            throw new VDocException(e);
        }
        catch (ArchiveException e) {
            throw new VDocException(e);
        }
    }
}

