/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class DocumentDataXml {
    private Document doc = null;
    private Element root = null;
    private Element perm = null;
    private Element admin = null;
    private Element history = null;
    private Element latest = null;

    public DocumentDataXml(URI uri, URI schema, String schemaName, String owner, Permissions permissions) {
        this.root = new Element("descriptor");
        this.root.setAttribute("uri", uri.toASCIIString());
        this.root.setAttribute("schemauri", schema.toASCIIString());
        this.root.setAttribute("schemaname", schemaName);
        this.root.setAttribute("owner", owner);
        this.root.setAttribute("deleted", "false");
        this.root.setAttribute("virtual", "false");
        this.perm = new Element("permissions");
        this.perm.setAttribute("read", permissions.getRead());
        this.perm.setAttribute("write", permissions.getWrite());
        this.admin = new Element("administration");
        this.admin.setAttribute("hidden", "false");
        this.admin.setAttribute("dirty", "false");
        this.history = new Element("history");
        this.latest = new Element("latest");
        this.latest.setAttribute("timestamp", this.getTimeStamp());
        this.history.addContent((Content)this.latest);
        this.root.addContent((Content)this.perm);
        this.root.addContent((Content)this.admin);
        this.root.addContent((Content)this.history);
        this.doc = new Document(this.root);
    }

    public DocumentDataXml(String xml) {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            this.doc = builder.build((Reader)new StringReader(xml));
            this.root = this.doc.getRootElement();
            this.perm = this.root.getChild("permissions");
            this.admin = this.root.getChild("administration");
            this.history = this.root.getChild("history");
            this.latest = this.history.getChild("latest");
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeHistory() {
        this.history.removeChildren("version");
    }

    public void addLatest() {
        if (this.history != null) {
            Element version = new Element("version");
            version.setAttribute("timestamp", this.latest.getAttributeValue("timestamp"));
            this.history.addContent((Content)version);
            this.latest.setAttribute("timestamp", this.getTimeStamp());
        }
    }

    private DocumentData getDocumentData(Element version) {
        try {
            ArchiveTimeStamp timestamp = new ArchiveTimeStamp(version.getAttributeValue("timestamp"));
            URI schema = new URI(this.root.getAttributeValue("schemauri"));
            String owner = this.root.getAttributeValue("owner");
            Permissions permissions = new Permissions(this.perm.getAttributeValue("read"), this.perm.getAttributeValue("write"));
            boolean hidden = this.isHidden();
            boolean dirty = this.isDirty();
            boolean deleted = this.isDeleted();
            boolean virtual = this.isVirtual();
            String admin = "";
            return new DocumentData(timestamp, schema, owner, permissions, hidden, dirty, deleted, virtual, admin);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public DocumentData getDocumentData() {
        return this.getDocumentData(this.latest);
    }

    public DocumentData getDocumentData(ArchiveTimeStamp timestamp) {
        try {
            String _path = "//version[@timestamp=\"" + timestamp.toISOString() + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.history);
            if (result == null) {
                return this.getDocumentData(this.latest);
            }
            return this.getDocumentData(result);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DocumentData[] getAllDocumentData() {
        List children = this.history.getChildren();
        DocumentData[] result = new DocumentData[children.size()];
        ListIterator iter = children.listIterator();
        while (iter.hasNext()) {
            result[iter.nextIndex()] = this.getDocumentData((Element)iter.next());
        }
        return result;
    }

    public URI getURI() {
        try {
            return new URI(this.root.getAttributeValue("uri"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI getSchemaURI() {
        try {
            return new URI(this.root.getAttributeValue("schemauri"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSchemaName() {
        String schemaName = this.root.getAttributeValue("schemaname");
        return schemaName;
    }

    public void setSchema(URI schemaUri, String schemaName) {
        this.root.setAttribute("schemauri", schemaUri.toASCIIString());
        this.root.setAttribute("schemaname", schemaName);
    }

    public ArchiveTimeStamp getLatestTimeStamp() {
        try {
            return new ArchiveTimeStamp(this.latest.getAttributeValue("timestamp"));
        }
        catch (DatabaseException e) {
            return null;
        }
    }

    public List getOtherTimeStamp() {
        List children = this.history.getChildren("version");
        Iterator iter = children.iterator();
        ArrayList<ArchiveTimeStamp> stamps = new ArrayList<ArchiveTimeStamp>();
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            try {
                ArchiveTimeStamp s = new ArchiveTimeStamp(e.getAttributeValue("timestamp"));
                stamps.add(s);
            }
            catch (DatabaseException databaseException) {}
        }
        return stamps;
    }

    public boolean isDirty() {
        String value = this.admin.getAttributeValue("dirty");
        return value.equalsIgnoreCase("true");
    }

    public void setDirty(boolean dirty) {
        this.admin.setAttribute("dirty", Boolean.toString(dirty));
    }

    public boolean isHidden() {
        String value = this.admin.getAttributeValue("hidden");
        return value.equalsIgnoreCase("true");
    }

    public void setHidden(boolean hidden) {
        this.admin.setAttribute("hidden", Boolean.toString(hidden));
    }

    public boolean isDeleted() {
        String value = this.root.getAttributeValue("deleted");
        return value.equalsIgnoreCase("true");
    }

    public void setDelete(boolean del) {
        this.root.setAttribute("deleted", Boolean.toString(del));
    }

    public boolean isVirtual() {
        String value = this.root.getAttributeValue("virtual");
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public void setVirtual(boolean vir) {
        this.root.setAttribute("virtual", Boolean.toString(vir));
    }

    public boolean checkReadPermision(String role) {
        return true;
    }

    public boolean checkWritePermision(String role) {
        return true;
    }

    public Permissions getPermissions() {
        return new Permissions(this.perm.getAttributeValue("read"), this.perm.getAttributeValue("write"));
    }

    public void setPermissions(Permissions permissions) {
        this.perm.setAttribute("read", permissions.getRead());
        this.perm.setAttribute("write", permissions.getWrite());
    }

    public String toXmlString() {
        XMLOutputter out = new XMLOutputter(Format.getRawFormat());
        return out.outputString(this.doc);
    }

    private String getTimeStamp() {
        ArchiveTimeStamp ts = new ArchiveTimeStamp();
        return ts.toISOString();
    }
}

