/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.exceptions.general.DatabaseException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exist.xmldb.RemoteXMLResource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XmldbConnector {
    public static DBConfiguration dbConfig;
    private Logger logger;
    private final String location;
    private final String name;
    private final String driver;
    private Database database = null;
    private boolean testMode;
    private static XmldbConnector _instance;
    private static int access_count;
    private final String _descriptor = "descriptor";
    private final String _latest = "latest";
    private final String _documents = "documents";

    public static XmldbConnector instance(Logger logger, boolean testMode) throws DatabaseException, XMLDBException {
        if (_instance == null) {
            _instance = new XmldbConnector(logger, testMode);
        }
        ++access_count;
        return _instance;
    }

    protected XmldbConnector(Logger logger, boolean testMode) throws XMLDBException, DatabaseException {
        this.logger = logger;
        this.testMode = testMode;
        if (testMode) {
            logger.info("***Archive running in test mode***");
        } else {
            logger.info("***Archive running in operational mode***");
        }
        dbConfig = DBConfiguration.instance(logger);
        this.location = dbConfig.get("archive.xmldb.location");
        logger.info("Archive location: " + this.location);
        if (this.location == null || this.location.equalsIgnoreCase("")) {
            throw new DatabaseException("The archive.xmldb.location has not been set");
        }
        this.name = dbConfig.get("archive.xmldb.name");
        logger.info("Archive name: " + this.name);
        if (this.name == null || this.name.equalsIgnoreCase("")) {
            throw new DatabaseException("The archive.xmldb.name config has not been set");
        }
        this.driver = dbConfig.get("archive.xmldb.driver");
        logger.info("Archive driver: " + this.driver);
        if (this.driver == null || this.driver.equalsIgnoreCase("")) {
            throw new DatabaseException("The archive.xmldb.driver config has not been set");
        }
        this.registerDB();
    }

    private void registerDB() throws XMLDBException, DatabaseException {
        if (this.database == null) {
            try {
                Class<?> c = Class.forName(this.driver);
                if (c == null) {
                    throw new DatabaseException("Could not find the driver: " + this.driver);
                }
                this.database = (Database)c.newInstance();
                this.database.setProperty("create-database", "true");
            }
            catch (Exception e) {
                throw new DatabaseException("Could not get driver " + this.driver + ":\n" + e);
            }
            DatabaseManager.registerDatabase((Database)this.database);
        }
    }

    private Collection getTopCollection() throws XMLDBException {
        try {
            Collection topCollection = DatabaseManager.getCollection((String)(this.location + "/" + this.name));
            if (topCollection != null) {
                return topCollection;
            }
            throw new XMLDBException();
        }
        catch (XMLDBException e) {
            this.logger.log(Level.SEVERE, "Could not find top level collection: " + this.location + "/" + this.name + "::" + e.errorCode);
            e.printStackTrace();
            throw new XMLDBException(201, "Could not find top level collection: " + this.location + "/" + this.name);
        }
    }

    private Collection getCollection(String cn) throws XMLDBException {
        Collection topCollection = this.getTopCollection();
        Collection collection = topCollection.getChildCollection(cn);
        if (collection == null) {
            CollectionManagementService service = (CollectionManagementService)topCollection.getService("CollectionManagementService", "1.0");
            return service.createCollection(cn);
        }
        return collection;
    }

    public Collection getDescriptor() throws XMLDBException {
        if (this.testMode) {
            return this.getCollection("descriptortest");
        }
        return this.getCollection("descriptor");
    }

    public Collection getLatest() throws XMLDBException {
        if (this.testMode) {
            return this.getCollection("latesttest");
        }
        return this.getCollection("latest");
    }

    public Collection getDocuments() throws XMLDBException {
        if (this.testMode) {
            return this.getCollection("documentstest");
        }
        return this.getCollection("documents");
    }

    public Collection getOther(String name) throws XMLDBException {
        if (this.testMode) {
            return this.getCollection(name + "test");
        }
        return this.getCollection(name);
    }

    public void cleanTestCollections() throws DatabaseException {
        try {
            Collection testDescriptor = this.getCollection("descriptortest");
            this.clean(testDescriptor);
            this.shutdownCollection(testDescriptor);
            Collection testLatest = this.getCollection("latesttest");
            this.clean(testLatest);
            this.shutdownCollection(testLatest);
            Collection testDocuments = this.getCollection("documentstest");
            this.clean(testDocuments);
            this.shutdownCollection(testDocuments);
        }
        catch (XMLDBException e) {
            throw new DatabaseException(e);
        }
    }

    public void cleanCollections() throws DatabaseException {
        try {
            this.logger.info("Cleaning collections! Mode=" + (this.testMode ? "test" : "operational"));
            Collection descriptor = this.getDescriptor();
            this.clean(descriptor);
            this.shutdownCollection(descriptor);
            Collection latest = this.getLatest();
            this.clean(latest);
            this.shutdownCollection(latest);
            Collection documents = this.getDocuments();
            this.clean(documents);
            this.shutdownCollection(documents);
            XmldbDatabase.instance(this.logger).refresh();
            Collection collection = this.getDescriptor();
        }
        catch (XMLDBException e) {
            throw new DatabaseException(e);
        }
    }

    private void clean(Collection col) throws XMLDBException {
        String[] res = col.listResources();
        for (int x = 0; x < res.length; ++x) {
            col.removeResource(col.getResource(res[x]));
        }
    }

    public void shutdownCollection(Collection col) throws DatabaseException {
    }

    public URI extractURI(Resource resource) throws DatabaseException {
        try {
            String xmldbDriver = dbConfig.get("archive.xmldb.driver");
            if (xmldbDriver.equals("org.exist.xmldb.DatabaseImpl")) {
                return this.extractExist(resource);
            }
            if (XmldbConnector.dbConfig.dbBackend.equalsIgnoreCase("exist")) {
                return this.extractExist(resource);
            }
            throw new DatabaseException("The XMLDB driver class: " + xmldbDriver + " is not recognised ");
        }
        catch (XMLDBException e) {
            throw new DatabaseException(e);
        }
    }

    private URI extractExist(Resource resource) throws XMLDBException, DatabaseException {
        try {
            RemoteXMLResource res = (RemoteXMLResource)resource;
            String id = res.getId();
            id = id.replaceAll("schemeSeperator", "://");
            id = id.replaceAll("slash", "/");
            id = id.replaceAll("hash", "#");
            int lastus = id.indexOf("_");
            if (lastus != -1) {
                id = id.substring(0, lastus);
            }
            return new URI(id);
        }
        catch (URISyntaxException e) {
            throw new DatabaseException(e);
        }
    }

    public String cleanResult(String str) throws DatabaseException {
        String dbdriver = dbConfig.get("archive.xmldb.driver");
        if (dbdriver.equals("org.exist.xmldb.DatabaseImpl")) {
            return this.cleanExist(str);
        }
        if (XmldbConnector.dbConfig.dbBackend.equalsIgnoreCase("exist")) {
            return this.cleanExist(str);
        }
        throw new DatabaseException("The XMLDB driver class: " + dbdriver + " is not recognised ");
    }

    private String cleanExist(String str) {
        return str;
    }

    static {
        _instance = null;
        access_count = 0;
    }
}

