/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.xmldb.DocumentDataXml;
import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.cursor.CursorClosedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ResultStruct;
import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class XmldbCursor
implements DBCursor {
    private DBConfiguration dbConfig;
    private XmldbConnector connector;
    private XmldbDatabase database;
    private String schema = "";
    private String user = "";
    private boolean dirtyRead;
    private Vector resourceList = null;
    private Vector uriList = null;
    private Iterator resourceIterator;

    public XmldbCursor(XmldbDatabase database, ResourceSet resourceset, String schema, boolean dirtyRead, boolean allRead, String user, Logger logger) throws XMLDBException, DatabaseException {
        this.schema = schema;
        this.database = database;
        this.user = user;
        this.dirtyRead = dirtyRead;
        if (this.dbConfig == null) {
            this.dbConfig = DBConfiguration.instance(logger);
        }
        this.connector = XmldbConnector.instance(logger, this.dbConfig.testMode);
        this.resourceList = new Vector();
        this.uriList = new Vector();
        ResourceIterator iter = resourceset.getIterator();
        while (iter.hasMoreResources()) {
            Resource current = iter.nextResource();
            URI currentUri = this.connector.extractURI(current);
            if (!this.filter(currentUri, allRead)) continue;
            this.resourceList.add(current);
            this.uriList.add(currentUri);
        }
        this.resourceIterator = this.resourceList.iterator();
    }

    private boolean filter(URI uri, boolean allRead) throws DatabaseException {
        if (this.database.descriptorExists(uri)) {
            DocumentDataXml documentData = this.database.getDescriptor(uri);
            if (!documentData.getSchemaName().equalsIgnoreCase(this.schema)) {
                return false;
            }
            if (!allRead) {
                if (documentData.isDeleted()) {
                    return false;
                }
                if (documentData.isDirty() && !this.dirtyRead) {
                    return false;
                }
                if (!documentData.checkReadPermision(this.user)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() throws DatabaseException, ArchiveException {
        if (this.resourceIterator == null) {
            return false;
        }
        return this.resourceIterator.hasNext();
    }

    @Override
    public ResultStruct next() throws CursorClosedException, DatabaseException, ArchiveException {
        if (this.resourceIterator == null) {
            throw new CursorClosedException("The cursor has been closed, or there are no more results");
        }
        if (this.resourceIterator.hasNext()) {
            try {
                Resource current = (Resource)this.resourceIterator.next();
                String content = (String)current.getContent();
                URI currentUri = this.connector.extractURI(current);
                content = this.connector.cleanResult(content);
                ResultStruct struct = new ResultStruct(currentUri, content);
                return struct;
            }
            catch (XMLDBException e) {
                throw new DatabaseException("Problems accessing the resource iterator", e);
            }
        }
        this.resourceIterator = null;
        throw new CursorClosedException("There are no more results in the Cursor");
    }

    @Override
    public ResultStruct[] nextBlock(int blockSize) throws CursorClosedException, DatabaseException, ArchiveException {
        ResultStruct[] res = new ResultStruct[blockSize];
        for (int x = 0; x < blockSize; ++x) {
            res[x] = this.hasNext() ? this.next() : null;
        }
        return res;
    }

    public URI[] uriList() {
        URI[] list = new URI[this.uriList.size()];
        list = this.uriList.toArray(list);
        return list;
    }

    @Override
    public void close() throws CursorClosedException, DatabaseException, ArchiveException {
        this.resourceIterator = null;
    }
}

