/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.xmldb.DocumentDataXml;
import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.database.xmldb.XmldbCursor;
import alma.archive.database.xmldb.XmldbSchemaManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XmldbDatabase {
    private Logger logger;
    private XmldbConnector connector = null;
    protected DBConfiguration dbConfig = null;
    private String _testns = "uid://test";
    private URI testns;
    private Collection descriptor = null;
    private Collection latest = null;
    private Collection documents = null;
    private static XmldbDatabase _instance = null;
    private static int access_count = 0;

    public static XmldbDatabase instance(Logger logger) throws DatabaseException, XMLDBException {
        if (_instance == null) {
            DBConfiguration config = DBConfiguration.instance(logger);
            boolean testMode = config.testMode;
            XmldbConnector conn = XmldbConnector.instance(logger, testMode);
            _instance = new XmldbDatabase(conn, logger);
        }
        ++access_count;
        return _instance;
    }

    public void close() throws DatabaseException {
        if (--access_count == 0) {
            if (this.descriptor != null) {
                this.connector.shutdownCollection(this.descriptor);
                this.descriptor = null;
            }
            if (this.latest != null) {
                this.connector.shutdownCollection(this.latest);
                this.latest = null;
            }
            if (this.documents != null) {
                this.connector.shutdownCollection(this.documents);
                this.documents = null;
            }
            _instance = null;
        }
    }

    protected XmldbDatabase(XmldbConnector conn, Logger logger) throws DatabaseException, XMLDBException {
        this.logger = logger;
        this.dbConfig = DBConfiguration.instance(logger);
        if (this.connector == null) {
            this.connector = conn;
        }
        try {
            this.testns = new URI(this._testns);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (this.dbConfig == null) {
            this.dbConfig = DBConfiguration.instance(logger);
        }
    }

    private void connect() throws DatabaseException {
        try {
            if (this.descriptor == null) {
                this.logger.info("ARCHIVE: Fetching descriptor Collection");
                this.descriptor = this.connector.getDescriptor();
            }
            if (this.latest == null) {
                this.logger.info("ARCHIVE: Fetching latest Collection");
                this.latest = this.connector.getLatest();
            }
            if (this.documents == null) {
                this.logger.info("ARCHIVE: Fetching documents Collection");
                this.documents = this.connector.getDocuments();
            }
        }
        catch (XMLDBException e) {
            throw new DatabaseException("Problems fetching collections from the Database", e);
        }
    }

    protected void refresh() throws DatabaseException {
        this.logger.info("Refreshing database info.");
        this.descriptor = null;
        this.latest = null;
        this.documents = null;
        this.connect();
    }

    public boolean exists(URI uri) throws DatabaseException {
        if (uri.equals(this.testns)) {
            return true;
        }
        this.connect();
        return this.inCollection(this.descriptor, uri) || this.inCollection(this.latest, uri);
    }

    public boolean descriptorExists(URI uri) throws DatabaseException {
        this.connect();
        return this.inCollection(this.descriptor, uri);
    }

    private boolean inCollection(Collection col, URI uri) throws DatabaseException {
        Collection collection = col;
        synchronized (collection) {
            try {
                String xmldbUri = this.URItoString(uri);
                Resource res = col.getResource(xmldbUri);
                if (res == null) {
                    return false;
                }
                return res.getContent() != null;
                {
                }
            }
            catch (XMLDBException e) {
                throw new DatabaseException("Problem when checking existance of: " + uri.toASCIIString() + " ", e);
            }
        }
    }

    public void put(Collection col, URI uri, String xml) throws DatabaseException {
        try {
            String xmldbUri = this.URItoString(uri);
            XMLResource newDocument = (XMLResource)col.createResource(xmldbUri, "XMLResource");
            newDocument.setContent((Object)xml);
            col.storeResource((Resource)newDocument);
        }
        catch (XMLDBException e) {
            throw new DatabaseException("Problem when puting: " + uri.toASCIIString() + " ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDescriptor(URI uri, String xml) throws DatabaseException {
        this.connect();
        Collection collection = this.descriptor;
        synchronized (collection) {
            this.put(this.descriptor, uri, xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLatest(URI uri, String xml) throws DatabaseException {
        this.connect();
        Collection collection = this.latest;
        synchronized (collection) {
            this.put(this.latest, uri, xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDocuments(URI uri, ArchiveTimeStamp ts, String xml) throws DatabaseException {
        this.connect();
        Collection collection = this.documents;
        synchronized (collection) {
            this.put(this.documents, this.URIAddTime(uri, ts), xml);
        }
    }

    private String get(Collection col, URI uri) throws DatabaseException {
        try {
            String xmldbUri = this.URItoString(uri);
            XMLResource document = (XMLResource)col.getResource(xmldbUri);
            if (document == null) {
                throw new DatabaseException("No content (Null XMLResource) was returned by the database URI: " + uri.toASCIIString() + " probably nothign there");
            }
            String xml = (String)document.getContent();
            if (xml == null) {
                throw new DatabaseException("No content (Null XML) was returned by the database URI: " + uri.toASCIIString() + " probably nothign there");
            }
            return xml;
        }
        catch (XMLDBException e) {
            throw new DatabaseException("Problem when geting: " + uri.toASCIIString() + " ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentDataXml getDescriptor(URI uri) throws DatabaseException {
        this.connect();
        Collection collection = this.descriptor;
        synchronized (collection) {
            String xml = null;
            xml = this.get(this.descriptor, uri);
            if (xml == null) {
                throw new DatabaseException("No content was returned by the database URI: " + uri.toASCIIString() + " from collection Descriptor " + "probably nothign there");
            }
            return new DocumentDataXml(xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getlatest(URI uri) throws DatabaseException {
        this.connect();
        Collection collection = this.latest;
        synchronized (collection) {
            String xml = null;
            xml = this.get(this.latest, uri);
            if (xml == null) {
                throw new DatabaseException("No content was returned by the database URI: " + uri.toASCIIString() + " from collection Latest " + "probably nothign there");
            }
            return xml;
        }
    }

    public void flushLatest(URI uri) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocuments(URI uri, ArchiveTimeStamp ts) throws DatabaseException {
        this.connect();
        Collection collection = this.documents;
        synchronized (collection) {
            String xml = this.get(this.documents, this.URIAddTime(uri, ts));
            if (xml == null) {
                throw new DatabaseException("No content was returned by the database URI: " + uri.toASCIIString() + " from collection Documents " + "probably nothign there");
            }
            return xml;
        }
    }

    private void del(Collection col, URI uri) throws DatabaseException {
        try {
            String xmldbUri = this.URItoString(uri);
            XMLResource document = (XMLResource)col.getResource(xmldbUri);
            if (document == null) {
                throw new DatabaseException("Unable to delete: " + uri.toString() + " The XMLResource returned by the database was Null");
            }
            col.removeResource((Resource)document);
        }
        catch (XMLDBException e) {
            throw new DatabaseException("Problem when geting: " + uri.toASCIIString() + " ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delDescriptor(URI uri) throws DatabaseException {
        this.connect();
        Collection collection = this.descriptor;
        synchronized (collection) {
            this.del(this.descriptor, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delLatest(URI uri) throws DatabaseException {
        this.connect();
        Collection collection = this.latest;
        synchronized (collection) {
            this.del(this.latest, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delDocuments(URI uri, ArchiveTimeStamp ts) throws DatabaseException {
        this.connect();
        Collection collection = this.documents;
        synchronized (collection) {
            this.del(this.documents, this.URIAddTime(uri, ts));
        }
    }

    private void registerNamespaces(XPathQueryService service, Map<String, String> namespaces) throws XMLDBException {
        if (namespaces == null) {
            this.logger.log(Level.INFO, "ARCHIVE: Namespaces not set for query");
        } else {
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                service.setNamespace(entry.getKey(), entry.getValue());
            }
        }
    }

    public XmldbCursor queryLatest(String query, Map<String, String> namespaces, String schema, boolean dirtyRead, boolean allRead, String user) throws DatabaseException {
        this.connect();
        Collection collection = this.latest;
        synchronized (collection) {
            try {
                XPathQueryService service = (XPathQueryService)this.latest.getService("XPathQueryService", "1.0");
                this.registerNamespaces(service, namespaces);
                ResourceSet results = service.query(query);
                XmldbCursor cursor = new XmldbCursor(this, results, schema, dirtyRead, allRead, user, this.logger);
                return cursor;
            }
            catch (XMLDBException e) {
                throw new DatabaseException("XPath query failed " + query + " ", e);
            }
        }
    }

    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws DatabaseException {
        try {
            return this.queryInterval(timestamp, null, schema, null, user);
        }
        catch (UnknownSchemaException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String XPathQuery, String user) throws DatabaseException, UnknownSchemaException {
        XmldbCursor uidTime;
        this.logger.finest("Interval query: " + XPathQuery + "   from: " + timeFrom.toISOString() + "   to: " + (timeTo == null ? "now" : timeTo.toISOString()));
        this.connect();
        Collection collection = this.descriptor;
        synchronized (collection) {
            String query = "/descriptor[@schemaname=\"" + schema + "\"][history/latest/attribute::timestamp>\"" + timeFrom.toISOString() + "\"]";
            if (timeTo != null) {
                query = query + "[history/latest/attribute::timestamp<\"" + timeTo.toISOString() + "\"]";
            }
            try {
                XPathQueryService service = (XPathQueryService)this.descriptor.getService("XPathQueryService", "1.0");
                ResourceSet results = service.query(query);
                uidTime = new XmldbCursor(this, results, schema, false, false, user, this.logger);
            }
            catch (XMLDBException e) {
                throw new DatabaseException("XPath query failed " + query + " ", e);
            }
        }
        if (XPathQuery != null) {
            XmldbCursor uidQuery;
            HashMap namespaces = XmldbSchemaManager.instance(this.logger).getSchemaNamespaces(XmldbSchemaManager.instance(this.logger).getSchemaURI(schema));
            Collection e = this.latest;
            synchronized (e) {
                try {
                    XPathQueryService service = (XPathQueryService)this.latest.getService("XPathQueryService", "1.0");
                    this.registerNamespaces(service, namespaces);
                    ResourceSet results = service.query(XPathQuery);
                    uidQuery = new XmldbCursor(this, results, schema, false, false, user, this.logger);
                }
                catch (XMLDBException e2) {
                    throw new DatabaseException("XPath query failed " + XPathQuery + " ", e2);
                }
            }
            HashSet<URI> uids = new HashSet<URI>();
            try {
                while (uidTime.hasNext()) {
                    uids.add(uidTime.next().getUri());
                }
            }
            catch (ArchiveException e3) {
                throw new DatabaseException("Problems in handling cursor. " + e3);
            }
            Vector<URI> out = new Vector<URI>();
            try {
                while (uidQuery.hasNext()) {
                    URI next = uidQuery.next().getUri();
                    if (!uids.contains(next)) continue;
                    out.add(next);
                    uids.remove(next);
                }
                uidTime.close();
                uidQuery.close();
            }
            catch (ArchiveException e4) {
                throw new DatabaseException("Problems in handling cursor. " + e4);
            }
            return out.toArray(new URI[0]);
        }
        URI[] ret = uidTime.uriList();
        try {
            uidTime.close();
        }
        catch (ArchiveException e) {
            throw new DatabaseException("Problems in handling cursor. " + e);
        }
        return ret;
    }

    private String URItoString(URI uri) {
        String tmp = uri.toASCIIString();
        tmp = tmp.replaceAll("://", "schemeSeperator");
        tmp = tmp.replaceAll("/", "slash");
        tmp = tmp.replaceAll("#", "hash");
        return tmp;
    }

    private URI URIAddTime(URI uri, ArchiveTimeStamp ts) {
        try {
            String suri = uri.toASCIIString();
            suri = suri + "#" + ts.toISOString();
            return new URI(suri);
        }
        catch (URISyntaxException e) {
            this.logger.severe(e.getLocalizedMessage());
            return null;
        }
    }
}

