/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.interfaces.IdentifierManager;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xmldb.api.base.XMLDBException;

public class XmldbIdentifierManager
extends IdentifierManager {
    private String location = "archive://identifier";
    private URI locationUri;
    private XmldbDatabase database;
    private static XmldbIdentifierManager _instance;
    private static int access_count;
    private Logger logger = null;

    public static XmldbIdentifierManager instance(Logger logger) throws DatabaseException {
        if (_instance == null) {
            try {
                XmldbDatabase database = XmldbDatabase.instance(logger);
                _instance = new XmldbIdentifierManager(database, logger);
            }
            catch (XMLDBException e) {
                throw new DatabaseException(e.getMessage());
            }
        }
        ++access_count;
        return _instance;
    }

    @Override
    public void close() throws DatabaseException {
        if (--access_count == 0) {
            _instance = null;
            this.database.close();
        }
    }

    protected XmldbIdentifierManager(XmldbDatabase db, Logger logger) throws DatabaseException {
        this.logger = logger;
        try {
            this.locationUri = new URI(this.location);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.database = db;
        this.logger = logger;
    }

    private void configure() throws DatabaseException {
        this.setArchiveId("00");
        this.setRangeId(0L);
        try {
            this.initialize();
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e);
        }
    }

    private String fetchAttribute(String name) throws DatabaseException {
        if (!this.database.exists(this.locationUri)) {
            this.configure();
        }
        String xml = this.database.getlatest(this.locationUri);
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build((Reader)new StringReader(xml));
            Element ids = doc.detachRootElement();
            String value = ids.getAttributeValue(name);
            return value;
        }
        catch (JDOMException e) {
            throw new DatabaseException(e);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    private void setAttribute(String name, String value) throws DatabaseException {
        String xml = "";
        Element ids = null;
        if (this.database.exists(this.locationUri)) {
            xml = this.database.getlatest(this.locationUri);
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build((Reader)new StringReader(xml));
                ids = doc.getRootElement();
            }
            catch (JDOMException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
        } else {
            ids = new Element("ids");
        }
        ids.setAttribute(name, value);
        XMLOutputter out = new XMLOutputter();
        xml = out.outputString(ids);
        this.database.putLatest(this.locationUri, xml);
    }

    @Override
    public String getArchiveId() throws DatabaseException {
        String archId = this.fetchAttribute("archiveid");
        try {
            return "X" + String.valueOf(Long.parseLong(archId));
        }
        catch (NumberFormatException e) {
            return archId;
        }
    }

    @Override
    protected void setArchiveId(String archiveId) throws DatabaseException {
        this.setAttribute("archiveid", archiveId);
    }

    @Override
    protected long getRangeId() throws DatabaseException {
        return Long.parseLong(this.fetchAttribute("rangeid"));
    }

    @Override
    protected void setRangeId(long rangeId) throws DatabaseException {
        this.setAttribute("rangeid", String.valueOf(rangeId));
    }

    @Override
    protected void initialize() throws DatabaseException, ModuleCriticalException {
    }

    static {
        access_count = 0;
    }
}

