/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.ArchiveIdentifierError.wrappers.AcsJArchiveIdentifierErrorEx;
import alma.acs.container.archive.Range;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.helpers.DatabaseHelper;
import alma.archive.database.interfaces.DBCursor;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.interfaces.UserManager;
import alma.archive.database.xmldb.DocumentDataXml;
import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.database.xmldb.XmldbCursor;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.database.xmldb.XmldbSchemaManager;
import alma.archive.database.xmldb.XmldbUserManager;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.EntityDirtyException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.EntityAlreadyDeletedException;
import alma.archive.exceptions.general.EntityDoesNotExistException;
import alma.archive.exceptions.general.EntityExistsException;
import alma.archive.exceptions.general.EntityUndeletedException;
import alma.archive.exceptions.general.HistoryInconsistencyException;
import alma.archive.exceptions.general.IllegalTimestampException;
import alma.archive.exceptions.general.NotImplementedException;
import alma.archive.exceptions.general.UndefinedNamespaceException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.IllegalHistoryNumberException;
import alma.archive.exceptions.syntax.MalformedPermissionsException;
import alma.archive.exceptions.syntax.MalformedQueryException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.syntax.MalformedXPointerException;
import alma.archive.exceptions.syntax.UnderspecifiedQueryException;
import alma.archive.exceptions.syntax.UnknownFlagException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.archive.wrappers.DocumentData;
import alma.archive.wrappers.Permissions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.xmldb.api.base.XMLDBException;

public class XmldbInternalIF
implements InternalIF {
    private Logger logger = null;
    private XmldbDatabase database = null;
    private static XmldbInternalIF _instance = null;
    private static XmldbSchemaManager smanager = null;
    private static int access_count = 0;

    public static InternalIF instance(Logger logger) throws DatabaseException {
        if (_instance == null) {
            XmldbDatabase db;
            try {
                db = XmldbDatabase.instance(logger);
            }
            catch (XMLDBException e) {
                logger.severe(e.getLocalizedMessage());
                throw new DatabaseException(e);
            }
            _instance = new XmldbInternalIF(db, logger);
        }
        ++access_count;
        return _instance;
    }

    @Override
    public void init() throws DatabaseException {
        smanager.refresh();
    }

    @Override
    public void close() throws DatabaseException {
        if (--access_count == 0) {
            smanager.close();
            this.database.close();
            _instance = null;
        }
    }

    protected XmldbInternalIF(XmldbDatabase db, Logger logger) throws DatabaseException {
        this.logger = logger;
        this.database = db;
        smanager = XmldbSchemaManager.instance(logger);
    }

    @Override
    public String getSchemaOfUid(URI uid) throws DatabaseException, EntityDoesNotExistException, URISyntaxException, ModuleCriticalException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void store(URI uri, String xml, URI schema, String schemaName, String owner, Permissions permissions, String user, boolean emitLogs) throws DatabaseException, ArchiveException, MalformedURIException, MalformedXMLException, EntityExistsException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException, ModuleCriticalException {
        if (!DatabaseHelper.checkArchiveIdStoragePermission(uri, InternalIFFactory.getIdentifierManager(this.logger))) {
            throw new ArchiveException("Cannot store document with UID " + uri.toString() + ": does not match with ArchiveId: " + InternalIFFactory.getIdentifierManager(this.logger).getArchiveId());
        }
        if (smanager.verifySchema(schema, schemaName)) {
            DocumentDataXml dd = new DocumentDataXml(uri, schema, schemaName, owner, permissions);
            this.database.putDescriptor(uri, dd.toXmlString());
            this.database.putLatest(uri, xml);
        }
    }

    @Override
    public void store(String uid, String xml, String schemaName, boolean emitLogs) throws ModuleCriticalException, DatabaseException, ArchiveException, MalformedURIException, MalformedXMLException, EntityExistsException, UnknownSchemaException, UserDoesNotExistException, MalformedPermissionsException {
        try {
            this.store(new URI(uid), xml, smanager.getSchemaURI(schemaName), schemaName, "no owner specified", new Permissions(), "no user specified", emitLogs);
        }
        catch (URISyntaxException e) {
            throw new MalformedURIException(e);
        }
    }

    @Override
    public void update(URI uri, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user, OracleConnection conn) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, HistoryInconsistencyException, MalformedXMLException, EntityDoesNotExistException, UserDoesNotExistException, UnknownSchemaException {
        this.logger.severe("Transaction handling method called: Only supported for test, not for operational environment!");
        this.update(uri, timeStamp, xml, schema, force, user);
    }

    @Override
    public void update(URI uri, ArchiveTimeStamp timeStamp, String xml, URI schema, boolean force, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, HistoryInconsistencyException, MalformedXMLException, EntityDoesNotExistException, UserDoesNotExistException, UnknownSchemaException {
        ArchiveTimeStamp latestTimeStamp;
        String schemaName = smanager.getSchemaName(schema);
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (!force && !timeStamp.equals(latestTimeStamp = dd.getLatestTimeStamp())) {
            throw new HistoryInconsistencyException("Presented timestamp: " + timeStamp.toISOString() + " does not equal latest timestamp: " + latestTimeStamp.toISOString());
        }
        String oldLatest = this.database.getlatest(uri);
        this.database.putDocuments(uri, dd.getLatestTimeStamp(), oldLatest);
        this.database.delLatest(uri);
        dd.addLatest();
        dd.setSchema(schema, schemaName);
        this.database.putLatest(uri, xml);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public String get(URI uri, String user) throws PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (dd.isDeleted()) {
            throw new EntityDoesNotExistException("The entity: " + uri.toASCIIString() + " is flagged as deleted");
        }
        if (dd.isDirty()) {
            throw new EntityDirtyException("The entity: " + uri.toASCIIString() + " is flagged as dirty");
        }
        if (!dd.checkReadPermision(user)) {
            throw new PermissionDeniedException(user + " does not have permission to access: " + uri.toASCIIString());
        }
        return this.database.getlatest(uri);
    }

    @Override
    public String[] get(URI uri, String xpath, Map<String, String> namespaces, String user) throws PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, UndefinedNamespaceException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (dd.isDeleted()) {
            throw new EntityDoesNotExistException("The entity: " + uri.toASCIIString() + " is flagged as deleted");
        }
        if (dd.isDirty()) {
            throw new EntityDirtyException("The entity: " + uri.toASCIIString() + " is flagged as dirty");
        }
        if (!dd.checkReadPermision(user)) {
            throw new PermissionDeniedException(user + " does not have permission to access: " + uri.toASCIIString());
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            Document doc = builder.build((Reader)new StringReader(this.database.getlatest(uri)));
            Element root = doc.getRootElement();
            XPath path = XPath.newInstance((String)xpath);
            List results = path.selectNodes((Object)root);
            if (results.size() == 0) {
                return new String[0];
            }
            ListIterator iter = results.listIterator();
            String[] string_array = new String[results.size()];
            while (iter.hasNext()) {
                XMLOutputter out = new XMLOutputter(Format.getRawFormat());
                int index = iter.nextIndex();
                Object n = iter.next();
                String result_string = "";
                if (n instanceof Element) {
                    result_string = out.outputString((Element)n);
                }
                if (n instanceof Text) {
                    result_string = out.outputString((Text)n);
                }
                if (n instanceof CDATA) {
                    result_string = out.outputString((CDATA)n);
                }
                if (n instanceof Comment) {
                    result_string = out.outputString((Comment)n);
                }
                if (n instanceof ProcessingInstruction) {
                    result_string = out.outputString((ProcessingInstruction)n);
                }
                if (n instanceof Attribute) {
                    Attribute tmp = (Attribute)n;
                    result_string = tmp.getValue();
                }
                string_array[index] = result_string;
            }
            return string_array;
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        catch (IOException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getDirty(URI uri, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (dd.isDeleted()) {
            throw new EntityDoesNotExistException("The entity: " + uri.toASCIIString() + " is flagged as deleted");
        }
        if (!dd.checkReadPermision(user)) {
            throw new PermissionDeniedException(user + " does not have permission to access: " + uri.toASCIIString());
        }
        return this.database.getlatest(uri);
    }

    @Override
    public void delete(URI uri, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (dd.isDeleted()) {
            throw new EntityAlreadyDeletedException("The entity: " + uri.toASCIIString() + " is flagged as deleted");
        }
        dd.setDelete(true);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void undelete(URI uri, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        if (!dd.isDeleted()) {
            throw new EntityUndeletedException("The entity: " + uri.toASCIIString() + " is not flagged as deleted");
        }
        dd.setDelete(false);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void dirty(URI uri, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setDirty(true);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void clean(URI uri, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setDirty(false);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void hidden(URI uri, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setHidden(true);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void visible(URI uri, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setHidden(false);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void setVirtual(URI uri, String user, boolean virtual) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setVirtual(virtual);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public DocumentData status(URI uri, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        return dd.getDocumentData();
    }

    protected DocumentData status(URI uri) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, IllegalTimestampException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        return dd.getDocumentData();
    }

    @Override
    public DBCursor query(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.database.queryLatest(query, namespaces, schema, dirtyRead, false, user);
    }

    @Override
    public Collection<String> getLog(String timeFrom, String timeTo, int minType, int maxType, String routine, String source, String process, int maxRow) throws ArchiveException {
        this.logger.warning("queryLog only supported for Oracle database. Check your dbConfig.properties file!");
        throw new ArchiveException("queryLog only supported for Oracle database.");
    }

    @Override
    public DBCursor queryContent(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.database.queryLatest(query, namespaces, schema, dirtyRead, false, user);
    }

    @Override
    public ArrayList<String[]> querySubmissions(short fieldID, String searchString, boolean caseSensitive, boolean containsQuery, String PiCoIfilter) throws DatabaseException, NotImplementedException {
        throw new NotImplementedException("Operation querySubmissions only supported for Oracle.");
    }

    @Override
    public URI[] queryRecent(ArchiveTimeStamp timestamp, String schema, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        return this.database.queryRecent(timestamp, schema, user);
    }

    @Override
    public URI[] queryInterval(ArchiveTimeStamp timeFrom, ArchiveTimeStamp timeTo, String schema, String XPathQuery, String user) throws DatabaseException, ArchiveException {
        return this.database.queryInterval(timeFrom, timeTo, schema, XPathQuery, user);
    }

    @Override
    public URI[] queryIDs(String query, String schema, Map<String, String> namespaces, boolean dirtyRead, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        XmldbCursor cursor = this.database.queryLatest(query, namespaces, schema, dirtyRead, false, user);
        return cursor.uriList();
    }

    @Override
    public URI[] queryIDsAll(String query, String schema, Map<String, String> namespaces, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException {
        XmldbCursor cursor = this.database.queryLatest(query, namespaces, schema, true, true, user);
        return cursor.uriList();
    }

    @Override
    public void setFlag(URI uid, String flagName, boolean flagValue, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
    }

    @Override
    public void changeOwner(URI uid, String newOwner, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
    }

    @Override
    public SchemaManager getSchemaManager(String user) throws ArchiveException, PermissionDeniedException, UserDoesNotExistException {
        return XmldbSchemaManager.instance(this.logger);
    }

    @Override
    public UserManager getUserManager(String user) throws ArchiveException, PermissionDeniedException, UserDoesNotExistException {
        return XmldbUserManager.getInstance(this.logger);
    }

    @Override
    public void remove(URI uri, boolean keepHead, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        List stamps = dd.getOtherTimeStamp();
        ListIterator iter = stamps.listIterator();
        while (iter.hasNext()) {
            ArchiveTimeStamp ts = (ArchiveTimeStamp)iter.next();
            this.database.delDocuments(uri, ts);
        }
        this.database.delDescriptor(uri);
        if (keepHead) {
            dd.removeHistory();
            this.database.delDescriptor(uri);
            this.database.putDescriptor(uri, dd.toXmlString());
        } else {
            this.database.delLatest(uri);
        }
    }

    @Override
    public void setPermission(URI uri, Permissions permissions, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException {
        if (!this.database.exists(uri)) {
            throw new EntityDoesNotExistException("The URI: " + uri.toASCIIString() + " was not found in the database");
        }
        DocumentDataXml dd = this.database.getDescriptor(uri);
        dd.setPermissions(permissions);
        this.database.delDescriptor(uri);
        this.database.putDescriptor(uri, dd.toXmlString());
    }

    @Override
    public void notifyConfigChange() {
    }

    @Override
    public void cleanTestArea(String user) throws PermissionDeniedException, DatabaseException, ArchiveException, UserDoesNotExistException {
        try {
            XmldbConnector connector = XmldbConnector.instance(this.logger, true);
            connector.cleanTestCollections();
        }
        catch (XMLDBException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        XmldbSchemaManager.instance(this.logger).removeAll();
    }

    protected void loadIdentifierRangeSchema(String user) throws DatabaseException, UserDoesNotExistException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
        URI idRangeURI;
        BufferedReader UIDschemaReader;
        ClassLoader loader = DBConfiguration.class.getClassLoader();
        StringBuffer UIDschema = new StringBuffer();
        URL UIDschemaFile = loader.getResource("IdentifierRange.xsd");
        if (UIDschemaFile == null) {
            this.logger.severe("Could not find IdentifierRange.xsd. Assumed location: IdentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Could not find IdentifierRange.xsd. Assumed location: IdentifierRange.xsd in archive_xmlstore_if.jar");
        }
        this.logger.info("-------- Loading " + UIDschemaFile);
        try {
            UIDschemaReader = new BufferedReader(new InputStreamReader(UIDschemaFile.openStream()));
        }
        catch (IOException e1) {
            this.logger.severe("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
        }
        try {
            while (UIDschemaReader.ready()) {
                UIDschema.append(UIDschemaReader.readLine());
            }
        }
        catch (IOException e) {
            this.logger.severe("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
            throw new DatabaseException("Problems when opening schema file for UID range. Location: IndentifierRange.xsd in archive_xmlstore_if.jar");
        }
        try {
            idRangeURI = new Range(InternalIFFactory.getIdentifierManager(this.logger).getNewRange()).next();
        }
        catch (ArchiveException e) {
            throw new DatabaseException(e);
        }
        catch (ModuleCriticalException e) {
            throw new DatabaseException(e.getCause());
        }
        catch (AcsJArchiveIdentifierErrorEx e) {
            throw new DatabaseException(e);
        }
        this.logger.info("Storing IdentifierRange.xsd under UID: " + idRangeURI);
        XmldbSchemaManager.instance(this.logger).addSchema("IdentifierRange", UIDschema.toString(), "", idRangeURI, user, new Permissions());
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public void updateXML(URI uid, String schema, String newChild) throws DatabaseException, EntityDoesNotExistException, MalformedXMLException {
        String xml;
        try {
            xml = this.database.getlatest(uid);
        }
        catch (DatabaseException e) {
            throw new EntityDoesNotExistException(uid.toString());
        }
        xml = DatabaseHelper.addAsLastChild(xml, newChild);
        this.database.putLatest(uid, xml);
    }

    @Override
    public void addElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation addElement only supported for Oracle.");
    }

    @Override
    public void updateElement(URI uid, String schemaName, String xPath, String xmlElement, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation updateElement only supported for Oracle.");
    }

    @Override
    public void deleteElement(URI uid, String schemaName, String xPath, String user) throws EntityDoesNotExistException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Operation deleteElement only supported for Oracle.");
    }

    @Override
    public void storeLog(String message, int level, String attributeValue, String attributeValue2, String attributeValue3, String attributeValue4, String attributeValue5, String attributeValue6, String attributeValue7, String attributeValue8, String attributeValue9, String attributeValue10, String attributeValue11, String attributeValue12, String attributeValue13, String attributeValue14, String attributeValue15, String[] dataStrings, String xml, boolean commit, String steEnv) {
    }

    @Override
    public OracleConnection openConnection() throws DatabaseException {
        this.logger.severe("Transaction handling method called: Only supported for test, not for operational environment!");
        return null;
    }

    @Override
    public synchronized void store(URI uid, String xml, String schemaName, String owner, Permissions permissions, String user, boolean newEntity, OracleConnection conn) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException, ArchiveException {
        this.logger.severe("Transaction handling method called: Only supported for test, not for operational environment!");
        this.store(uid, xml, smanager.getSchemaURI(schemaName), schemaName, owner, permissions, user, true);
    }

    @Override
    public void storeAll(URI[] uid, String[] xml, String[] schemaName, String[] owner, Permissions[] permissions, String user, boolean[] newEntity) throws EntityDoesNotExistException, EntityExistsException, DatabaseException, PermissionDeniedException, ModuleCriticalException {
        throw new DatabaseException("Method only supported for Oracle!");
    }

    @Override
    public void commit(OracleConnection conn) throws DatabaseException {
        this.logger.severe("Transaction handling method called: Only supported for test, not for operational environment!");
    }

    @Override
    public String get(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.get(uid, user);
    }

    @Override
    public String[] get(URI uid, String schema, String xpath, Map<String, String> namespaces, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDirtyException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, IllegalHistoryNumberException, UserDoesNotExistException, MalformedXPointerException, UndefinedNamespaceException {
        return this.get(uid, xpath, namespaces, user);
    }

    @Override
    public String getDirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, MalformedURIException {
        return this.getDirty(uid, user);
    }

    @Override
    public void dirty(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.dirty(uid, user);
    }

    @Override
    public void clean(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.clean(uid, user);
    }

    @Override
    public void hidden(URI uid, String schema, String user) throws PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException {
        this.hidden(uid, user);
    }

    @Override
    public void visible(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.visible(uid, user);
    }

    @Override
    public void setFlag(URI uid, String schema, String flagName, boolean flagValue, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, UnknownFlagException {
        this.setFlag(uid, flagName, flagValue, user);
    }

    @Override
    public void remove(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityDoesNotExistException {
        this.remove(uid, false, user);
    }

    @Override
    public void setPermission(URI uid, String schema, Permissions permissions, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, MalformedPermissionsException {
        this.setPermission(uid, permissions, user);
    }

    @Override
    public void delete(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, MalformedURIException, UserDoesNotExistException, EntityAlreadyDeletedException {
        this.delete(uid, user);
    }

    @Override
    public void undelete(URI uid, String schema, String user) throws PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException, EntityUndeletedException {
        this.undelete(uid, user);
    }

    @Override
    public void setVirtual(URI uid, String schema, String user, boolean virtual) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.setVirtual(uid, user, virtual);
    }

    @Override
    public void changeOwner(URI uid, String schema, String newOwner, String user) throws ModuleCriticalException, PermissionDeniedException, DatabaseException, ArchiveException, MalformedURIException, EntityDoesNotExistException, UserDoesNotExistException {
        this.changeOwner(uid, newOwner, user);
    }

    @Override
    public DocumentData status(URI uid, String schema, String user) throws ModuleCriticalException, PermissionDeniedException, EntityDoesNotExistException, DatabaseException, ArchiveException, UserDoesNotExistException, IllegalHistoryNumberException, MalformedURIException {
        return this.status(uid, user);
    }
}

