/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.helpers.Cache;
import alma.archive.database.interfaces.SchemaManager;
import alma.archive.database.xmldb.DocumentDataXml;
import alma.archive.database.xmldb.XmldbConnector;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.database.xmldb.XmldbInternalIF;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.NamespaceDefinedException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedURIException;
import alma.archive.exceptions.syntax.MalformedXMLException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.wrappers.Permissions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.xmldb.api.base.XMLDBException;

public final class XmldbSchemaManager
implements SchemaManager {
    private XmldbDatabase database;
    private Logger logger;
    private String _schemas = "archive://schemas";
    private String _namespaces = "archive://namespaces";
    private String _testns = "uid://test";
    private String _schemans = "http://www.w3.org/2001/XMLSchema";
    private URI schemasUri;
    private URI namespacesUri;
    private URI testns;
    private URI schemans;
    private final int cacheSize = 100;
    private Cache namespaceCache = null;
    private static XmldbSchemaManager _instance = null;
    private static int access_count = 0;
    private Document nsdoc = null;
    private Document scdoc = null;
    private Element namespaces = null;
    private Element schemas = null;

    protected static XmldbSchemaManager instance(Logger logger) throws DatabaseException {
        if (_instance == null) {
            _instance = new XmldbSchemaManager(logger);
        }
        ++access_count;
        return _instance;
    }

    @Override
    public void close() throws DatabaseException {
        if (--access_count == 0) {
            this.database.close();
            _instance = null;
        }
    }

    private XmldbSchemaManager(Logger logger) throws DatabaseException {
        this.logger = logger;
        try {
            this.schemasUri = new URI(this._schemas);
            this.namespacesUri = new URI(this._namespaces);
            this.testns = new URI(this._testns);
            this.schemans = new URI(this._schemans);
        }
        catch (URISyntaxException e) {
            logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        try {
            this.database = XmldbDatabase.instance(logger);
            this.build();
        }
        catch (XMLDBException e) {
            logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public void refresh() throws DatabaseException {
        this.database.refresh();
        this.nsdoc = null;
        this.scdoc = null;
        this.namespaces = null;
        this.schemas = null;
        this.build();
    }

    private void build() throws DatabaseException {
        SAXBuilder builder;
        this.logger.info("Getting schema information from Xmldb.");
        if (this.database.exists(this.namespacesUri)) {
            builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(true);
            try {
                this.database.flushLatest(this.namespacesUri);
                this.nsdoc = builder.build((Reader)new StringReader(this.database.getlatest(this.namespacesUri)));
                this.namespaces = this.nsdoc.getRootElement();
            }
            catch (JDOMException e) {
                this.logger.severe(e.getLocalizedMessage());
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                this.logger.severe(e.getLocalizedMessage());
                throw new DatabaseException(e);
            }
        } else {
            this.namespaces = new Element("namespaces");
            this.nsdoc = new Document(this.namespaces);
        }
        if (this.database.exists(this.schemasUri)) {
            builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(true);
            try {
                this.database.flushLatest(this.schemasUri);
                this.scdoc = builder.build((Reader)new StringReader(this.database.getlatest(this.schemasUri)));
                this.schemas = this.scdoc.getRootElement();
            }
            catch (JDOMException e) {
                this.logger.severe(e.getLocalizedMessage());
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                this.logger.severe(e.getLocalizedMessage());
                throw new DatabaseException(e);
            }
        } else {
            this.schemas = new Element("schemas");
            this.scdoc = new Document(this.schemas);
        }
        this.namespaceCache = new Cache(100);
    }

    @Override
    public void registerNamespace(String tag, URI namespace) throws DatabaseException, MalformedURIException, NamespaceDefinedException {
        try {
            String existingUri;
            XPath path = XPath.newInstance((String)("/namespaces/namespace[@name=\"" + tag + "\"]"));
            Element result = (Element)path.selectSingleNode((Object)this.namespaces);
            if (result != null && !(existingUri = result.getAttributeValue("URI")).equalsIgnoreCase(namespace.toASCIIString())) {
                throw new NamespaceDefinedException("Namespace: " + tag + " is already defined as: " + existingUri);
            }
            Element ns = new Element("namespace");
            ns.setAttribute("name", tag);
            ns.setAttribute("URI", namespace.toASCIIString());
            this.namespaces.addContent((Content)ns);
            this.save();
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean namespaceExists(URI namespace) throws DatabaseException {
        if (namespace.equals(this.testns)) {
            return true;
        }
        try {
            XPath path = XPath.newInstance((String)("/namespaces/namespace[@URI=\"" + namespace.toASCIIString() + "\"]"));
            Element result = (Element)path.selectSingleNode((Object)this.namespaces);
            return result != null;
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public void removeNamespace(String name) throws DatabaseException {
        try {
            XPath path = XPath.newInstance((String)("/namespaces/namespace[@name=\"" + name + "\"]"));
            Element result = (Element)path.selectSingleNode((Object)this.namespaces);
            this.namespaces.removeContent((Content)result);
            if (this.schemas.getChildren().size() > 0) {
                path = XPath.newInstance((String)("/schemas/schema/namespace[@name=\"" + name + "\"]"));
                List ns = path.selectNodes((Object)this.schemas);
                ListIterator iter = ns.listIterator();
                while (iter.hasNext()) {
                    Element n = (Element)iter.next();
                    Element parent = (Element)n.getParent();
                    URI schemaUri = new URI(parent.getAttributeValue("URI"));
                    parent.removeContent((Content)n);
                    if (!this.namespaceCache.containsKey(schemaUri)) continue;
                    this.namespaceCache.remove(schemaUri);
                }
            }
            this.save();
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public void removeAll() throws DatabaseException {
        XmldbConnector conn = null;
        try {
            conn = XmldbConnector.instance(this.logger, this.database.dbConfig.testMode);
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        catch (XMLDBException e1) {
            e1.printStackTrace();
        }
        conn.cleanCollections();
        this.refresh();
        try {
            ((XmldbInternalIF)XmldbInternalIF.instance(this.logger)).loadIdentifierRangeSchema("xmldbSchemaManager");
        }
        catch (ArchiveException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void assignNamespace(String name, URI schemaUri) throws DatabaseException, UnknownSchemaException {
        try {
            String _path = "/schemas/schema[@URI=\"" + schemaUri.toASCIIString() + "\"]";
            XPath schemaPath = XPath.newInstance((String)_path);
            Element schemaResult = (Element)schemaPath.selectSingleNode((Object)this.schemas);
            if (schemaResult == null) {
                throw new UnknownSchemaException();
            }
            XPath nspath = XPath.newInstance((String)("/namespaces/namespace[@name=\"" + name + "\"]"));
            Element nsresult = (Element)nspath.selectSingleNode((Object)this.namespaces);
            schemaResult.addContent((Content)((Element)nsresult.clone()));
            if (this.namespaceCache.containsKey(schemaUri)) {
                this.namespaceCache.remove(schemaUri);
            }
            this.save();
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public void withdrawNamespace(String name, URI schemaUri) throws DatabaseException, UnknownSchemaException {
        try {
            String _path = "/schemas/schema[@URI=\"" + schemaUri.toASCIIString() + "\"]/namespace[@name=\"" + name + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.schemas);
            if (result == null) {
                throw new UnknownSchemaException(schemaUri.toString() + " does not contain namespace prefix " + name);
            }
            Element parent = (Element)result.getParent();
            parent.removeContent((Content)result);
            if (this.namespaceCache.containsKey(schemaUri)) {
                this.namespaceCache.remove(schemaUri);
            }
            this.save();
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    public HashMap namespaces() {
        HashMap<String, String> results = new HashMap<String, String>();
        List list = this.namespaces.getChildren();
        for (Element ns : list) {
            results.put(ns.getAttributeValue("name"), ns.getAttributeValue("URI"));
        }
        return results;
    }

    public List listSchema() {
        List schemaList = this.schemas.getChildren();
        ListIterator iter = schemaList.listIterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iter.hasNext()) {
            Element schema = (Element)iter.next();
            String name = schema.getAttributeValue("name");
            results.add(name);
        }
        return results;
    }

    private void checkValidXml(String xml) throws MalformedXMLException {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        try {
            Document document = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new MalformedXMLException(e.getMessage());
        }
        catch (IOException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new MalformedXMLException(e.getMessage());
        }
    }

    @Override
    public void addSchema(String schemaName, String xml, String indexConfig, URI schemaURInew, String owner, Permissions permissions) throws DatabaseException, UserDoesNotExistException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
        this.checkValidXml(xml);
        Element schema = new Element("schema");
        schema.setAttribute("URI", schemaURInew.toASCIIString());
        schema.setAttribute("name", schemaName);
        schema.setAttribute("version", "1");
        schema.setAttribute("previous", "");
        if (this.database.exists(schemaURInew)) {
            throw new DatabaseException("URI: " + schemaURInew.toASCIIString() + " already occupied");
        }
        DocumentDataXml dd = new DocumentDataXml(schemaURInew, this.schemans, "Schema", owner, permissions);
        this.database.putDescriptor(schemaURInew, dd.toXmlString());
        this.database.putLatest(schemaURInew, xml);
        this.schemas.addContent((Content)schema);
        this.save();
    }

    private int version(URI uri) throws DatabaseException {
        String _path = "/schemas/schema[@URI=\"" + uri.toASCIIString() + "\"]";
        try {
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.schemas);
            if (result == null) {
                return -1;
            }
            return Integer.parseInt(result.getAttributeValue("version"));
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public void updateSchema(String schemaName, String xml, String indexConfig, URI schemaURIold, URI schemaURInew, String owner, Permissions permissions) throws DatabaseException, UserDoesNotExistException, MalformedURIException, UnknownSchemaException, PermissionDeniedException, MalformedXMLException {
        this.checkValidXml(xml);
        Element schema = new Element("schema");
        schema.setAttribute("URI", schemaURInew.toASCIIString());
        schema.setAttribute("name", schemaName);
        if (!this.database.exists(schemaURIold)) {
            throw new DatabaseException("Previous URI: " + schemaURIold.toASCIIString() + " does not exist");
        }
        if (this.database.exists(schemaURInew)) {
            throw new DatabaseException("URI: " + schemaURInew.toASCIIString() + " already occupied");
        }
        int pversion = this.version(schemaURIold);
        schema.setAttribute("version", Integer.toString(++pversion));
        schema.setAttribute("previous", schemaURIold.toASCIIString());
        DocumentDataXml dd = new DocumentDataXml(schemaURInew, this.schemans, "Schema", owner, permissions);
        this.database.putDescriptor(schemaURInew, dd.toXmlString());
        this.database.putLatest(schemaURInew, xml);
        this.schemas.addContent((Content)schema);
        this.save();
    }

    @Override
    public void removeSchema(String schemaName) throws DatabaseException, UserDoesNotExistException, UnknownSchemaException, PermissionDeniedException {
        try {
            String _path = "/schemas/schema[@name=\"" + schemaName + "\"]";
            XPath schemaPath = XPath.newInstance((String)_path);
            List results = schemaPath.selectNodes((Object)this.schemas);
            if (results.size() == 0) {
                throw new UnknownSchemaException("Cannot find schema: " + schemaName + " to remeove");
            }
            for (Element res : results) {
                URI uri = new URI(res.getAttributeValue("URI"));
                if (this.namespaceCache.containsKey(uri)) {
                    this.namespaceCache.remove(uri);
                }
                this.database.delDescriptor(uri);
                this.database.delLatest(uri);
                this.schemas.removeContent((Content)res);
            }
            this.save();
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public URI getSchemaURI(String schema) throws DatabaseException, UnknownSchemaException {
        if (schema.equalsIgnoreCase("test")) {
            return this.testns;
        }
        try {
            String _path = "/schemas/schema[@name=\"" + schema + "\"]";
            XPath path = XPath.newInstance((String)_path);
            List results = path.selectNodes((Object)this.schemas);
            if (results.size() == 0) {
                throw new UnknownSchemaException("Could not find scehma: " + schema);
            }
            Iterator iter = results.iterator();
            int version = -1;
            String uri = "";
            while (iter.hasNext()) {
                Element result = (Element)iter.next();
                int tmpVersion = Integer.parseInt(result.getAttributeValue("version"));
                if (tmpVersion <= version) continue;
                version = tmpVersion;
                uri = result.getAttributeValue("URI");
            }
            return new URI(uri);
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public URI getSchemaURI(String schema, int version) throws DatabaseException, UnknownSchemaException {
        if (schema.equalsIgnoreCase("test")) {
            return this.testns;
        }
        try {
            String _path = "/schemas/schema[@name=\"" + schema + "\" and @version='" + Integer.toString(version) + "']";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.schemas);
            if (result == null) {
                throw new UnknownSchemaException("Could not find scehma: " + schema);
            }
            return new URI(result.getAttributeValue("URI"));
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
        catch (URISyntaxException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    public HashMap getSchemaNamespaces(URI schemaUri) throws DatabaseException {
        if (schemaUri.equals(this.testns)) {
            return null;
        }
        if (this.namespaceCache.containsKey(schemaUri)) {
            return (HashMap)this.namespaceCache.get(schemaUri);
        }
        HashMap<String, String> results = new HashMap<String, String>();
        String _path = "/schemas/schema[@URI=\"" + schemaUri.toASCIIString() + "\"]/namespace";
        try {
            XPath path = XPath.newInstance((String)_path);
            List list = path.selectNodes((Object)this.schemas);
            for (Element ns : list) {
                results.put(ns.getAttributeValue("name"), ns.getAttributeValue("URI"));
            }
            this.namespaceCache.put(schemaUri, results);
            return results;
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getSchemaName(URI schemaUri) throws DatabaseException, UnknownSchemaException {
        if (schemaUri.equals(this.testns)) {
            return "test";
        }
        if (schemaUri.equals(this.schemans)) {
            return "Schema";
        }
        String _path = "/schemas/schema[@URI=\"" + schemaUri.toASCIIString() + "\"]";
        try {
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.schemas);
            if (result == null) {
                throw new UnknownSchemaException("No schema is registered with the URI: " + schemaUri.toASCIIString() + " ");
            }
            return result.getAttributeValue("name");
        }
        catch (JDOMException e) {
            this.logger.severe(e.getLocalizedMessage());
            throw new DatabaseException(e);
        }
    }

    protected boolean verifySchema(URI schemaUri, String schemaName) throws DatabaseException, UnknownSchemaException, MalformedURIException {
        if (schemaUri.equals(this.testns) && schemaName.equals("test")) {
            return true;
        }
        if (schemaUri.equals(this.schemans) && schemaName.equals("Schema")) {
            return true;
        }
        String name = this.getSchemaName(schemaUri);
        if (!name.equals(schemaName)) {
            throw new UnknownSchemaException("As scehma is registered at the URL: " + schemaUri.toASCIIString() + " But it does not have the name: " + schemaName);
        }
        return true;
    }

    @Override
    public int getSchemaVersion(URI schemaUri) throws DatabaseException, UnknownSchemaException, MalformedURIException {
        if (schemaUri.equals(this.testns)) {
            return 0;
        }
        return this.version(schemaUri);
    }

    private void save() throws DatabaseException {
        this.database.putLatest(this.namespacesUri, this.toXmlString(this.nsdoc));
        this.database.putLatest(this.schemasUri, this.toXmlString(this.scdoc));
    }

    private String toXmlString(Document doc) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(doc);
    }

    private String toPrettyXmlString(Document doc) {
        XMLOutputter out = new XMLOutputter(Format.getRawFormat());
        return out.outputString(doc);
    }
}

