/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.database.xmldb;

import alma.archive.database.interfaces.UserManager;
import alma.archive.database.xmldb.XmldbDatabase;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.user.RoleAlreadyExistsException;
import alma.archive.exceptions.user.RoleDoesNotExistException;
import alma.archive.exceptions.user.RoleNotAssignedException;
import alma.archive.exceptions.user.UserAlreadyExistsException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.xmldb.api.base.XMLDBException;

public final class XmldbUserManager
implements UserManager {
    private static XmldbUserManager _instance = null;
    private static int access_count = 0;
    private XmldbDatabase database;
    private String location;
    private URI locationUri;
    private Document doc;
    private Element root;
    private Element roles;
    private Element users;

    public static XmldbUserManager getInstance(Logger logger) throws DatabaseException {
        if (_instance == null) {
            _instance = new XmldbUserManager(logger);
        }
        ++access_count;
        return _instance;
    }

    @Override
    public void close() throws DatabaseException {
        if (--access_count == 0) {
            this.database.close();
            _instance = null;
        }
    }

    private XmldbUserManager(Logger logger) throws DatabaseException {
        block8: {
            this.location = "archive://users";
            this.doc = null;
            this.root = null;
            this.roles = null;
            this.users = null;
            try {
                this.locationUri = new URI(this.location);
            }
            catch (URISyntaxException e1) {
                logger.fine(e1.toString());
            }
            try {
                this.database = XmldbDatabase.instance(logger);
                if (this.database.exists(this.locationUri)) {
                    SAXBuilder builder = new SAXBuilder();
                    builder.setIgnoringElementContentWhitespace(true);
                    try {
                        this.doc = builder.build((Reader)new StringReader(this.database.getlatest(this.locationUri)));
                        this.root = this.doc.getRootElement();
                        this.roles = this.root.getChild("roles");
                        this.users = this.root.getChild("users");
                        break block8;
                    }
                    catch (JDOMException e) {
                        throw new DatabaseException(e.getMessage());
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e.getMessage());
                    }
                }
                this.root = new Element("usermanager");
                this.roles = new Element("roles");
                this.users = new Element("users");
                this.root.addContent((Content)this.roles);
                this.root.addContent((Content)this.users);
                this.doc = new Document(this.root);
            }
            catch (XMLDBException e) {
                throw new DatabaseException(e.getMessage());
            }
        }
    }

    @Override
    public void addUser(String user) throws DatabaseException, ArchiveException, UserAlreadyExistsException {
        Element u = new Element("user");
        u.setAttribute("name", user);
        this.users.addContent((Content)u);
        this.save();
    }

    @Override
    public void deleteUser(String user) throws DatabaseException, ArchiveException, UserDoesNotExistException {
        try {
            String _path = "//user[@name=\"" + user + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.users);
            if (result == null) {
                throw new UserDoesNotExistException();
            }
            this.users.removeContent((Content)result);
            this.save();
        }
        catch (JDOMException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    @Override
    public void addRole(String role) throws DatabaseException, ArchiveException, RoleAlreadyExistsException {
        Element r = new Element("role");
        r.setAttribute("name", role);
        this.roles.addContent((Content)r);
        this.save();
    }

    @Override
    public void deleteRole(String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException {
        try {
            String _path = "//role[@name=\"" + role + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.roles);
            if (result == null) {
                throw new RoleDoesNotExistException();
            }
            this.roles.removeContent((Content)result);
            this.save();
        }
        catch (JDOMException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    @Override
    public void assignRole(String user, String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException, UserDoesNotExistException {
        try {
            String _path = "//role[@name=\"" + role + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.root);
            if (result == null) {
                throw new RoleDoesNotExistException();
            }
            _path = "//user[@name=\"" + user + "\"]";
            path = XPath.newInstance((String)_path);
            result = (Element)path.selectSingleNode((Object)this.root);
            if (result == null) {
                throw new RoleDoesNotExistException();
            }
            Element r = new Element("role");
            r.setAttribute("name", role);
            result.addContent((Content)r);
            this.save();
        }
        catch (JDOMException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    @Override
    public void withdrawRole(String user, String role) throws DatabaseException, ArchiveException, RoleDoesNotExistException, UserDoesNotExistException, RoleNotAssignedException {
        try {
            String _path = "//user[@name=\"" + user + "\"]/role[@name=\"" + role + "\"]";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.root);
            if (result == null) {
                throw new UserDoesNotExistException();
            }
            Element parent = (Element)result.getParent();
            parent.removeContent((Content)result);
            this.save();
        }
        catch (JDOMException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public String getRole(String user) throws DatabaseException, UserDoesNotExistException {
        try {
            String _path = "//user[@name=\"" + user + "\"]/role";
            XPath path = XPath.newInstance((String)_path);
            Element result = (Element)path.selectSingleNode((Object)this.root);
            if (result == null) {
                throw new UserDoesNotExistException();
            }
            return result.getAttributeValue("name");
        }
        catch (JDOMException e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    private void save() throws DatabaseException {
        this.database.putLatest(this.locationUri, this.toXmlString(this.doc));
    }

    private String toXmlString(Document doc) {
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        return out.outputString(doc);
    }
}

