/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.TypeMapper;
import alma.xmlentity.XmlEntityStruct;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;

public class CastorUnmarshalMapper
extends TypeMapper {
    public CastorUnmarshalMapper(Object delegate, Logger logger) {
        super(delegate, logger);
    }

    @Override
    public boolean canTranslate(Class<?> oldObjClass, Class<?> newObjClass, ComponentInvocationHandler invHandler) {
        boolean canTranslate = false;
        if (XmlEntityStruct.class.isAssignableFrom(oldObjClass)) {
            ClassDescriptorResolverImpl clDescRes = new ClassDescriptorResolverImpl();
            clDescRes.setIntrospection(false);
            if (clDescRes.resolve(newObjClass) != null) {
                canTranslate = true;
            }
        }
        if (this.m_verbose) {
            String msg = "can " + (canTranslate ? "" : "not ") + "translate from class '" + oldObjClass.getName() + "' to class '" + newObjClass.getName() + "'.";
            this.m_logger.finer(msg);
        }
        return canTranslate;
    }

    @Override
    public <T> Object translate(Object oldObject, T newObjectTemplate, Class<T> newObjectClass, ComponentInvocationHandler invHandler) throws DynWrapperException {
        Object entity;
        XmlEntityStruct entStruct = (XmlEntityStruct)oldObject;
        if (entStruct == null || entStruct.xmlString == null || entStruct.xmlString.trim().length() == 0) {
            return null;
        }
        Unmarshaller unmarsh = new Unmarshaller(newObjectClass);
        unmarsh.setValidation(false);
        unmarsh.setWhitespacePreserve(true);
        try {
            entity = unmarsh.unmarshal((Reader)new StringReader(entStruct.xmlString));
        }
        catch (Exception ex) {
            String errorMsg = "failed to unmarshal entity object of type '" + entStruct.entityTypeName + "' using the Castor framework. ";
            if (ex.getMessage().trim().startsWith("unable to find FieldDescriptor for")) {
                errorMsg = errorMsg + "This is likely a versioning problem, where the XML document contains data types which are no longer allowed by the current XML schema, and are therefore unknown to the generated Castor binding classes. ";
            }
            String xmlMsg = null;
            xmlMsg = entStruct.xmlString.length() <= 300 ? "XML string=\n" + entStruct.xmlString : "XML string (first 300 chars) =\n" + entStruct.xmlString.substring(0, 300) + "***TRUNCATED|";
            throw new DynWrapperException(errorMsg + xmlMsg, ex);
        }
        return entity;
    }
}

