/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container;

import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.AcsEmbeddedContainerRunner;
import alma.acs.container.AcsManagerProxy;
import alma.acs.container.ShutdownHook;
import alma.acs.container.corba.AcsCorba;
import alma.acs.container.corba.OrbConfigurator;
import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.CmdLineArgs;
import alma.acs.util.CmdLineOption;
import alma.acs.util.CmdLineRegisteredOption;
import alma.acs.util.StopWatch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AcsContainerRunner {
    private static final String CONTAINER_NAME_PROPERTYNAME = "ACS.containerName";
    private static final String MANAGER_PROPERTYNAME = "ACS.manager";
    public static final String CONTAINER_STARTTIME_DELAY_MILLIS_PROPERTYNAME = "acs.container.starttimeDelayMillis";
    protected String m_containerName;
    protected String m_managerLoc;
    protected Boolean m_recoveryModeOverride;
    protected AcsEmbeddedContainerRunner embeddedRunner;
    protected AcsLogger m_logger;
    protected AcsCorba m_acsCorba;
    protected int m_containerPort = -1;
    private ShutdownHook m_shutdownHook;
    protected int initialSleeptimeMillis = 0;

    protected AcsContainerRunner() {
    }

    public static void main(String[] args) {
        block3: {
            AcsContainerRunner contRunner = null;
            try {
                contRunner = new AcsContainerRunner();
                contRunner.run(args);
            }
            catch (Throwable thr) {
                StringWriter sw = new StringWriter();
                thr.printStackTrace(new PrintWriter(sw));
                String msg = "\n *** Top level exception in AcsContainerRunner#main: " + sw.toString();
                if (contRunner.m_logger != null) {
                    contRunner.m_logger.severe(msg);
                }
                System.err.println(msg);
                if (contRunner.m_acsCorba == null) break block3;
                contRunner.m_acsCorba.doneCorba();
            }
        }
    }

    private void run(String[] args) throws AcsJContainerEx {
        StopWatch containerStartWatch = new StopWatch();
        this.m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("AcsContainerRunner", true);
        String argsString = "";
        for (String arg : args) {
            argsString = argsString + arg + " ";
        }
        this.m_logger.log(Level.INFO, "AcsContainerRunner#run with arguments " + argsString);
        this.setOptions(args);
        this.embeddedRunner = new AcsEmbeddedContainerRunner(false, this.m_recoveryModeOverride);
        this.embeddedRunner.setContainerName(this.m_containerName);
        this.embeddedRunner.setManagerLoc(this.m_managerLoc);
        this.checkReadyToRun();
        this.m_logger = this.embeddedRunner.getContainerLogger();
        this.m_acsCorba = new AcsCorba(this.m_logger);
        if (this.initialSleeptimeMillis > 0) {
            this.m_logger.fine("Container will sleep for " + this.initialSleeptimeMillis + " ms, e.g. to allow remote debuggers to attach at this early stage.");
            try {
                Thread.sleep(this.initialSleeptimeMillis);
            }
            catch (InterruptedException e) {
                this.m_logger.info("Woken up too early from initial-delay sleep.");
            }
        }
        this.m_acsCorba.initCorba(args, this.m_containerPort);
        this.m_acsCorba.runCorba();
        this.embeddedRunner.run(this.m_acsCorba);
        this.m_shutdownHook = new ShutdownHook((Logger)this.m_logger);
        Runtime.getRuntime().addShutdownHook((Thread)((Object)this.m_shutdownHook));
        this.m_shutdownHook.setAcsContainer(this.embeddedRunner.getContainer());
        this.initAcsLogging(this.embeddedRunner.getManagerProxy());
        this.m_logger.fine("entering orb loop");
        containerStartWatch.setLogger((Logger)this.m_logger);
        containerStartWatch.logLapTime("start the container");
        this.m_acsCorba.blockOnORB();
        this.m_logger.fine("orb loop over.");
        this.m_logger.exiting(AcsContainerRunner.class.getName(), "run");
        this.m_shutdownHook.setRegularShutdownExpected();
    }

    protected void initAcsLogging(final AcsManagerProxy managerProxy) {
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                AcsContainerRunner.this.m_logger.finer("asynchronously calling ClientLogManager#initRemoteLogging()...");
                boolean gotLogService = false;
                try {
                    gotLogService = ClientLogManager.getAcsLogManager().initRemoteLogging(AcsContainerRunner.this.m_acsCorba.getORB(), managerProxy.getManager(), managerProxy.getManagerHandle(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (gotLogService) {
                    AcsContainerRunner.this.m_logger.finer("done ClientLogManager#initRemoteLogging");
                } else {
                    AcsContainerRunner.this.m_logger.log(Level.WARNING, "ACS central logging not available!");
                }
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("InitRemoteLogging"));
        executor.execute(cmd);
    }

    void setOptions(String[] args) throws AcsJContainerEx {
        CmdLineArgs cmdArgs = new CmdLineArgs();
        CmdLineRegisteredOption optContainerName = new CmdLineRegisteredOption("-containerName", 1);
        cmdArgs.registerOption(optContainerName);
        CmdLineRegisteredOption optContainerPort = new CmdLineRegisteredOption("-OAPort", "-OAport", 1);
        cmdArgs.registerOption(optContainerPort);
        CmdLineRegisteredOption optManagerLoc = new CmdLineRegisteredOption("-manager", "-m", 1);
        cmdArgs.registerOption(optManagerLoc);
        CmdLineRegisteredOption optRecoveryMode = new CmdLineRegisteredOption("-recovery", "-r", 0);
        cmdArgs.registerOption(optRecoveryMode);
        CmdLineRegisteredOption optNoRecoveryMode = new CmdLineRegisteredOption("-norecovery", "-nr", 0);
        cmdArgs.registerOption(optNoRecoveryMode);
        try {
            Integer starttimeDelayMillisProperty;
            cmdArgs.parseArgs(args);
            this.m_containerName = cmdArgs.isSpecified(optContainerName) ? cmdArgs.getValues((CmdLineOption)optContainerName)[0].trim() : System.getProperty(CONTAINER_NAME_PROPERTYNAME);
            this.m_containerPort = cmdArgs.isSpecified(optContainerPort) ? Integer.parseInt(cmdArgs.getValues((CmdLineOption)optContainerPort)[0]) : OrbConfigurator.ORB_DEFAULT_PORT;
            this.m_managerLoc = cmdArgs.isSpecified(optManagerLoc) ? cmdArgs.getValues((CmdLineOption)optManagerLoc)[0].trim() : (System.getProperty(MANAGER_PROPERTYNAME) != null ? System.getProperty(MANAGER_PROPERTYNAME).trim() : AcsManagerProxy.getLocalManagerCorbaloc());
            if (cmdArgs.isSpecified(optRecoveryMode)) {
                this.m_recoveryModeOverride = Boolean.TRUE;
                if (cmdArgs.isSpecified(optNoRecoveryMode)) {
                    this.m_logger.warning("Conflicting command line options for recovery mode: both -r and -nr are specified. Will use -r.");
                }
            } else if (cmdArgs.isSpecified(optNoRecoveryMode)) {
                this.m_recoveryModeOverride = Boolean.FALSE;
            }
            if ((starttimeDelayMillisProperty = Integer.getInteger(CONTAINER_STARTTIME_DELAY_MILLIS_PROPERTYNAME)) != null) {
                this.initialSleeptimeMillis = starttimeDelayMillisProperty;
            }
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("incorrect or missing arguments.");
            throw ex;
        }
    }

    protected void checkReadyToRun() throws AcsJContainerEx {
        String msg = null;
        if (this.m_containerPort <= 0) {
            msg = "no container port specified; ";
        }
        this.embeddedRunner.checkReadyToRun(msg);
    }
}

